/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
	apisv1 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1"
)

// MeshStatusApplyConfiguration represents a declarative configuration of the MeshStatus type for use
// with apply.
type MeshStatusApplyConfiguration struct {
	Conditions        []v1.ConditionApplyConfiguration            `json:"conditions,omitempty"`
	SupportedFeatures []apisv1.SupportedFeatureApplyConfiguration `json:"supportedFeatures,omitempty"`
}

// MeshStatusApplyConfiguration constructs a declarative configuration of the MeshStatus type for use with
// apply.
func MeshStatus() *MeshStatusApplyConfiguration {
	return &MeshStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *MeshStatusApplyConfiguration) WithConditions(values ...*v1.ConditionApplyConfiguration) *MeshStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithSupportedFeatures adds the given value to the SupportedFeatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SupportedFeatures field.
func (b *MeshStatusApplyConfiguration) WithSupportedFeatures(values ...*apisv1.SupportedFeatureApplyConfiguration) *MeshStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSupportedFeatures")
		}
		b.SupportedFeatures = append(b.SupportedFeatures, *values[i])
	}
	return b
}
