{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Combines multiple sorters by trying them in turn.
-- 
-- If the first sorter compares two items as equal,
-- the second is tried next, and so on.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MultiSorter
    ( 

-- * Exported types
    MultiSorter(..)                         ,
    IsMultiSorter                           ,
    toMultiSorter                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gtk.Objects.MultiSorter#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.MultiSorter#g:method:remove"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMultiSorterMethod                ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    MultiSorterAppendMethodInfo             ,
#endif
    multiSorterAppend                       ,


-- ** new #method:new#

    multiSorterNew                          ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    MultiSorterRemoveMethodInfo             ,
#endif
    multiSorterRemove                       ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiSorterItemTypePropertyInfo         ,
#endif
    getMultiSorterItemType                  ,
#if defined(ENABLE_OVERLOADING)
    multiSorterItemType                     ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiSorterNItemsPropertyInfo           ,
#endif
    getMultiSorterNItems                    ,
#if defined(ENABLE_OVERLOADING)
    multiSorterNItems                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype MultiSorter = MultiSorter (SP.ManagedPtr MultiSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype MultiSorter where
    toManagedPtr (MultiSorter p) = p

foreign import ccall "gtk_multi_sorter_get_type"
    c_gtk_multi_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject MultiSorter where
    glibType = c_gtk_multi_sorter_get_type

instance B.Types.GObject MultiSorter

-- | Type class for types which can be safely cast to t'MultiSorter', for instance with `toMultiSorter`.
class (SP.GObject o, O.IsDescendantOf MultiSorter o) => IsMultiSorter o
instance (SP.GObject o, O.IsDescendantOf MultiSorter o) => IsMultiSorter o

instance O.HasParentTypes MultiSorter
type instance O.ParentTypes MultiSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object, Gio.ListModel.ListModel, Gtk.Buildable.Buildable]

-- | Cast to t'MultiSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMultiSorter :: (MIO.MonadIO m, IsMultiSorter o) => o -> m MultiSorter
toMultiSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo MultiSorter

-- | Convert t'MultiSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MultiSorter) where
    gvalueGType_ = c_gtk_multi_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MultiSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MultiSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MultiSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMultiSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMultiSorterMethod "append" o = MultiSorterAppendMethodInfo
    ResolveMultiSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMultiSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMultiSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveMultiSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveMultiSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMultiSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMultiSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMultiSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMultiSorterMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveMultiSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMultiSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMultiSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMultiSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMultiSorterMethod "remove" o = MultiSorterRemoveMethodInfo
    ResolveMultiSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMultiSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMultiSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMultiSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMultiSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMultiSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMultiSorterMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveMultiSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMultiSorterMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveMultiSorterMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveMultiSorterMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveMultiSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveMultiSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMultiSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMultiSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMultiSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMultiSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMultiSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMultiSorterMethod t MultiSorter, O.OverloadedMethod info MultiSorter p) => OL.IsLabel t (MultiSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMultiSorterMethod t MultiSorter, O.OverloadedMethod info MultiSorter p, R.HasField t MultiSorter p) => R.HasField t MultiSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMultiSorterMethod t MultiSorter, O.OverloadedMethodInfo info MultiSorter) => OL.IsLabel t (O.MethodProxy info MultiSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiSorter #itemType
-- @
getMultiSorterItemType :: (MonadIO m, IsMultiSorter o) => o -> m GType
getMultiSorterItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data MultiSorterItemTypePropertyInfo
instance AttrInfo MultiSorterItemTypePropertyInfo where
    type AttrAllowedOps MultiSorterItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiSorterItemTypePropertyInfo = IsMultiSorter
    type AttrSetTypeConstraint MultiSorterItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiSorterItemTypePropertyInfo = (~) ()
    type AttrTransferType MultiSorterItemTypePropertyInfo = ()
    type AttrGetType MultiSorterItemTypePropertyInfo = GType
    type AttrLabel MultiSorterItemTypePropertyInfo = "item-type"
    type AttrOrigin MultiSorterItemTypePropertyInfo = MultiSorter
    attrGet = getMultiSorterItemType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSorter.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSorter.html#g:attr:itemType"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiSorter #nItems
-- @
getMultiSorterNItems :: (MonadIO m, IsMultiSorter o) => o -> m Word32
getMultiSorterNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data MultiSorterNItemsPropertyInfo
instance AttrInfo MultiSorterNItemsPropertyInfo where
    type AttrAllowedOps MultiSorterNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiSorterNItemsPropertyInfo = IsMultiSorter
    type AttrSetTypeConstraint MultiSorterNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiSorterNItemsPropertyInfo = (~) ()
    type AttrTransferType MultiSorterNItemsPropertyInfo = ()
    type AttrGetType MultiSorterNItemsPropertyInfo = Word32
    type AttrLabel MultiSorterNItemsPropertyInfo = "n-items"
    type AttrOrigin MultiSorterNItemsPropertyInfo = MultiSorter
    attrGet = getMultiSorterNItems
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSorter.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSorter.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MultiSorter
type instance O.AttributeList MultiSorter = MultiSorterAttributeList
type MultiSorterAttributeList = ('[ '("itemType", MultiSorterItemTypePropertyInfo), '("nItems", MultiSorterNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
multiSorterItemType :: AttrLabelProxy "itemType"
multiSorterItemType = AttrLabelProxy

multiSorterNItems :: AttrLabelProxy "nItems"
multiSorterNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MultiSorter = MultiSorterSignalList
type MultiSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MultiSorter::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MultiSorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_sorter_new" gtk_multi_sorter_new :: 
    IO (Ptr MultiSorter)

-- | Creates a new multi sorter.
-- 
-- This sorter compares items by trying each of the sorters
-- in turn, until one returns non-zero. In particular, if
-- no sorter has been added to it, it will always compare
-- items as equal.
multiSorterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MultiSorter
    -- ^ __Returns:__ a new @GtkMultiSorter@
multiSorterNew  = liftIO $ do
    result <- gtk_multi_sorter_new
    checkUnexpectedReturnNULL "multiSorterNew" result
    result' <- (wrapObject MultiSorter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MultiSorter::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMultiSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sorter"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a sorter to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_sorter_append" gtk_multi_sorter_append :: 
    Ptr MultiSorter ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MultiSorter"})
    Ptr Gtk.Sorter.Sorter ->                -- sorter : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    IO ()

-- | Add /@sorter@/ to /@self@/ to use for sorting at the end.
-- 
-- /@self@/ will consult all existing sorters before it will
-- sort with the given /@sorter@/.
multiSorterAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiSorter a, Gtk.Sorter.IsSorter b) =>
    a
    -- ^ /@self@/: a @GtkMultiSorter@
    -> b
    -- ^ /@sorter@/: a sorter to add
    -> m ()
multiSorterAppend self sorter = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    sorter' <- B.ManagedPtr.disownObject sorter
    gtk_multi_sorter_append self' sorter'
    touchManagedPtr self
    touchManagedPtr sorter
    return ()

#if defined(ENABLE_OVERLOADING)
data MultiSorterAppendMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMultiSorter a, Gtk.Sorter.IsSorter b) => O.OverloadedMethod MultiSorterAppendMethodInfo a signature where
    overloadedMethod = multiSorterAppend

instance O.OverloadedMethodInfo MultiSorterAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSorter.multiSorterAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSorter.html#v:multiSorterAppend"
        })


#endif

-- method MultiSorter::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMultiSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position of sorter to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_sorter_remove" gtk_multi_sorter_remove :: 
    Ptr MultiSorter ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MultiSorter"})
    Word32 ->                               -- position : TBasicType TUInt
    IO ()

-- | Removes the sorter at the given /@position@/ from the list of sorter
-- used by /@self@/.
-- 
-- If /@position@/ is larger than the number of sorters, nothing happens.
multiSorterRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiSorter a) =>
    a
    -- ^ /@self@/: a @GtkMultiSorter@
    -> Word32
    -- ^ /@position@/: position of sorter to remove
    -> m ()
multiSorterRemove self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_multi_sorter_remove self' position
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MultiSorterRemoveMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsMultiSorter a) => O.OverloadedMethod MultiSorterRemoveMethodInfo a signature where
    overloadedMethod = multiSorterRemove

instance O.OverloadedMethodInfo MultiSorterRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSorter.multiSorterRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSorter.html#v:multiSorterRemove"
        })


#endif


