/* sega-cd-header.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sega-cd-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Documentation: https://en.wikibooks.org/wiki/Genesis_Programming*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include "games-sega-cd-plugin.h"

#define GAMES_SEGA_CD_HEADER_HEADER_LENGTH ((gsize) 0x200)
#define GAMES_SEGA_CD_HEADER_CD_OFFSET ((gsize) 0x0)
#define GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET ((gsize) 0x100)
#define GAMES_SEGA_CD_HEADER_SYSTEM_SIZE ((gsize) 0xf)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_SEGA_CD_HEADER (games_sega_cd_header_get_type ())
#define GAMES_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader))
#define GAMES_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))
#define GAMES_IS_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_IS_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_SEGA_CD_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))

typedef struct _GamesSegaCDHeader GamesSegaCDHeader;
typedef struct _GamesSegaCDHeaderClass GamesSegaCDHeaderClass;
typedef struct _GamesSegaCDHeaderPrivate GamesSegaCDHeaderPrivate;
typedef enum  {
	GAMES_SEGA_CD_SYSTEM_INVALID,
	GAMES_SEGA_CD_SYSTEM_SEGA_CD,
	GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X
} GamesSegaCDSystem;

#define GAMES_TYPE_SEGA_CD_SYSTEM (games_sega_cd_system_get_type ())
enum  {
	GAMES_SEGA_CD_HEADER_0_PROPERTY,
	GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY,
	GAMES_SEGA_CD_HEADER_NUM_PROPERTIES
};
static GParamSpec* games_sega_cd_header_properties[GAMES_SEGA_CD_HEADER_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_SEGA_CD_ERROR (games_sega_cd_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesSegaCDHeader {
	GObject parent_instance;
	GamesSegaCDHeaderPrivate * priv;
};

struct _GamesSegaCDHeaderClass {
	GObjectClass parent_class;
};

struct _GamesSegaCDHeaderPrivate {
	GamesSegaCDSystem* _system;
	GFile* file;
	gsize* offset;
};

typedef enum  {
	GAMES_SEGA_CD_ERROR_INVALID_HEADER,
	GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET,
	GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE
} GamesSegaCDError;
#define GAMES_SEGA_CD_ERROR games_sega_cd_error_quark ()

static gint GamesSegaCDHeader_private_offset;
static gpointer games_sega_cd_header_parent_class = NULL;
static GType games_sega_cd_header_type_id = 0;

GType games_sega_cd_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_sega_cd_header_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_sega_cd_system_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSegaCDHeader* games_sega_cd_header_new (GFile* file);
VALA_EXTERN GamesSegaCDHeader* games_sega_cd_header_construct (GType object_type,
                                                   GFile* file);
VALA_EXTERN void games_sega_cd_header_check_validity (GamesSegaCDHeader* self,
                                          GError** error);
VALA_EXTERN GamesSegaCDSystem games_sega_cd_header_get_system (GamesSegaCDHeader* self);
VALA_EXTERN GQuark games_sega_cd_error_quark (void);
VALA_EXTERN GType games_sega_cd_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gsize games_sega_cd_header_get_offset (GamesSegaCDHeader* self,
                                       GError** error);
static gsize* _size_t_dup (gsize* self);
static GamesSegaCDSystem games_sega_cd_header_parse_system (GamesSegaCDHeader* self,
                                                     GError** error);
VALA_EXTERN gboolean games_sega_cd_header_is_sega_cd (GamesSegaCDHeader* self);
VALA_EXTERN gboolean games_sega_cd_header_is_sega_cd_32x (GamesSegaCDHeader* self);
static GamesSegaCDSystem* _games_sega_cd_system_dup (GamesSegaCDSystem* self);
static void games_sega_cd_header_finalize (GObject * obj);
static void _vala_games_sega_cd_header_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);

static const gsize GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS[2] = {(gsize) 0x0, (gsize) 0x10};

static inline gpointer
games_sega_cd_header_get_instance_private (GamesSegaCDHeader* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSegaCDHeader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesSegaCDHeader*
games_sega_cd_header_construct (GType object_type,
                                GFile* file)
{
	GamesSegaCDHeader * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesSegaCDHeader*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

GamesSegaCDHeader*
games_sega_cd_header_new (GFile* file)
{
	return games_sega_cd_header_construct (GAMES_TYPE_SEGA_CD_HEADER, file);
}

void
games_sega_cd_header_check_validity (GamesSegaCDHeader* self,
                                     GError** error)
{
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GAMES_SEGA_CD_SYSTEM_INVALID) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_HEADER, "The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header.");
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gsize*
_size_t_dup (gsize* self)
{
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}

static gpointer
__size_t_dup0 (gpointer self)
{
	return self ? _size_t_dup (self) : NULL;
}

gsize
games_sega_cd_header_get_offset (GamesSegaCDHeader* self,
                                 GError** error)
{
	gsize* _tmp0_;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	GError* _tmp12_;
	gsize _tmp13_ = 0UL;
	GError* _inner_error0_ = NULL;
	gsize result;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	{
		gsize* possible_offset_collection = NULL;
		gint possible_offset_collection_length1 = 0;
		gint _possible_offset_collection_size_ = 0;
		gint possible_offset_it = 0;
		possible_offset_collection = GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS;
		possible_offset_collection_length1 = G_N_ELEMENTS (GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS);
		for (possible_offset_it = 0; possible_offset_it < possible_offset_collection_length1; possible_offset_it = possible_offset_it + 1) {
			gsize possible_offset = 0UL;
			possible_offset = possible_offset_collection[possible_offset_it];
			{
				gchar* system_string = NULL;
				GamesStringInputStream* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp4_ = stream;
				_tmp5_ = games_string_input_stream_read_string_for_size (_tmp4_, possible_offset + GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET, GAMES_SEGA_CD_HEADER_SYSTEM_SIZE, &_inner_error0_);
				system_string = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gsize _tmp6_ = 0UL;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (stream);
					return _tmp6_;
				}
				_tmp7_ = system_string;
				_tmp8_ = string_strip (_tmp7_);
				_g_free0 (system_string);
				system_string = _tmp8_;
				_tmp9_ = system_string;
				if (g_str_has_prefix (_tmp9_, "SEGA")) {
					gsize* _tmp10_;
					gsize* _tmp11_;
					_tmp10_ = __size_t_dup0 (&possible_offset);
					_g_free0 (self->priv->offset);
					self->priv->offset = _tmp10_;
					_tmp11_ = self->priv->offset;
					result = *_tmp11_;
					_g_free0 (system_string);
					_g_object_unref0 (stream);
					return result;
				}
				_g_free0 (system_string);
			}
		}
	}
	_tmp12_ = g_error_new_literal (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_HEADER, "The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header.");
	_inner_error0_ = _tmp12_;
	g_propagate_error (error, _inner_error0_);
	_g_object_unref0 (stream);
	return _tmp13_;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static GamesSegaCDSystem
games_sega_cd_header_parse_system (GamesSegaCDHeader* self,
                                   GError** error)
{
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gsize offset = 0UL;
	gboolean _tmp2_ = FALSE;
	GamesStringInputStream* _tmp3_;
	gchar* system_string = NULL;
	GamesStringInputStream* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GQuark _tmp11_ = 0U;
	static GQuark _tmp10_label0 = 0;
	static GQuark _tmp10_label1 = 0;
	static GQuark _tmp10_label2 = 0;
	static GQuark _tmp10_label3 = 0;
	static GQuark _tmp10_label4 = 0;
	static GQuark _tmp10_label5 = 0;
	GError* _inner_error0_ = NULL;
	GamesSegaCDSystem result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	offset = games_sega_cd_header_get_offset (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp3_ = stream;
	_tmp2_ = games_string_input_stream_has_string (_tmp3_, offset + GAMES_SEGA_CD_HEADER_CD_OFFSET, "SEGADISCSYSTEM", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return 0;
	}
	if (!_tmp2_) {
		result = GAMES_SEGA_CD_SYSTEM_INVALID;
		_g_object_unref0 (stream);
		return result;
	}
	_tmp4_ = stream;
	_tmp5_ = games_string_input_stream_read_string_for_size (_tmp4_, offset + GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET, GAMES_SEGA_CD_HEADER_SYSTEM_SIZE, &_inner_error0_);
	system_string = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp6_ = system_string;
	_tmp7_ = string_chomp (_tmp6_);
	_g_free0 (system_string);
	system_string = _tmp7_;
	_tmp8_ = system_string;
	_tmp9_ = _tmp8_;
	_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if (((((_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("SEGA MEGA DRIVE")))) || (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("SEGA GENESIS"))))) || (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string (" SEGA MEGA DRIV"))))) || (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("SEGA_SEGA_CD"))))) || (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("SEGA are Regist"))))) {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_SEGA_CD;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else if (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("SEGA 32X")))) {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_INVALID;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	}
}

gboolean
games_sega_cd_header_is_sega_cd (GamesSegaCDHeader* self)
{
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_SEGA_CD_SYSTEM_SEGA_CD:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
games_sega_cd_header_is_sega_cd_32x (GamesSegaCDHeader* self)
{
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static GamesSegaCDSystem*
_games_sega_cd_system_dup (GamesSegaCDSystem* self)
{
	GamesSegaCDSystem* dup;
	dup = g_new0 (GamesSegaCDSystem, 1);
	memcpy (dup, self, sizeof (GamesSegaCDSystem));
	return dup;
}

static gpointer
__games_sega_cd_system_dup0 (gpointer self)
{
	return self ? _games_sega_cd_system_dup (self) : NULL;
}

GamesSegaCDSystem
games_sega_cd_header_get_system (GamesSegaCDHeader* self)
{
	GamesSegaCDSystem result;
	GamesSegaCDSystem* _tmp0_;
	GamesSegaCDSystem* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_system;
	if (_tmp0_ != NULL) {
		GamesSegaCDSystem* _tmp1_;
		_tmp1_ = self->priv->_system;
		result = *_tmp1_;
		return result;
	}
	{
		GamesSegaCDSystem _tmp2_ = 0;
		GamesSegaCDSystem* _tmp3_;
		_tmp2_ = games_sega_cd_header_parse_system (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = __games_sega_cd_system_dup0 (&_tmp2_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp3_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GamesSegaCDSystem _tmp6_;
		GamesSegaCDSystem* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_debug ("sega-cd-header.vala:26: %s", _tmp5_);
		_tmp6_ = GAMES_SEGA_CD_SYSTEM_INVALID;
		_tmp7_ = __games_sega_cd_system_dup0 (&_tmp6_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp7_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp8_ = self->priv->_system;
	result = *_tmp8_;
	return result;
}

static void
games_sega_cd_header_class_init (GamesSegaCDHeaderClass * klass,
                                 gpointer klass_data)
{
	games_sega_cd_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSegaCDHeader_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_sega_cd_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_sega_cd_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY, games_sega_cd_header_properties[GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY] = g_param_spec_enum ("system", "system", "system", GAMES_TYPE_SEGA_CD_SYSTEM, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_sega_cd_header_instance_init (GamesSegaCDHeader * self,
                                    gpointer klass)
{
	self->priv = games_sega_cd_header_get_instance_private (self);
}

static void
games_sega_cd_header_finalize (GObject * obj)
{
	GamesSegaCDHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader);
	_g_free0 (self->priv->_system);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->offset);
	G_OBJECT_CLASS (games_sega_cd_header_parent_class)->finalize (obj);
}

GType
games_sega_cd_header_get_type (void)
{
	return games_sega_cd_header_type_id;
}

GType
games_sega_cd_header_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSegaCDHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_sega_cd_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSegaCDHeader), 0, (GInstanceInitFunc) games_sega_cd_header_instance_init, NULL };
	games_sega_cd_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSegaCDHeader", &g_define_type_info, 0);
	GamesSegaCDHeader_private_offset = sizeof (GamesSegaCDHeaderPrivate);
	return games_sega_cd_header_type_id;
}

static void
_vala_games_sega_cd_header_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesSegaCDHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader);
	switch (property_id) {
		case GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY:
		g_value_set_enum (value, games_sega_cd_header_get_system (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
games_sega_cd_error_quark (void)
{
	return g_quark_from_static_string ("games-sega-cd-error-quark");
}

static GType
games_sega_cd_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_SEGA_CD_ERROR_INVALID_HEADER, "GAMES_SEGA_CD_ERROR_INVALID_HEADER", "invalid-header"}, {GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET, "GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET", "invalid-cue-sheet"}, {GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE, "GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE", "invalid-file-type"}, {0, NULL, NULL}};
	GType games_sega_cd_error_type_id;
	games_sega_cd_error_type_id = g_enum_register_static ("GamesSegaCDError", values);
	return games_sega_cd_error_type_id;
}

GType
games_sega_cd_error_get_type (void)
{
	static volatile gsize games_sega_cd_error_type_id__once = 0;
	if (g_once_init_enter (&games_sega_cd_error_type_id__once)) {
		GType games_sega_cd_error_type_id;
		games_sega_cd_error_type_id = games_sega_cd_error_get_type_once ();
		g_once_init_leave (&games_sega_cd_error_type_id__once, games_sega_cd_error_type_id);
	}
	return games_sega_cd_error_type_id__once;
}

