#ifndef _EFL_UI_HOMOGENEOUS_MODEL_EO_H_
#define _EFL_UI_HOMOGENEOUS_MODEL_EO_H_

#ifndef _EFL_UI_HOMOGENEOUS_MODEL_EO_CLASS_TYPE
#define _EFL_UI_HOMOGENEOUS_MODEL_EO_CLASS_TYPE

typedef Eo Efl_Ui_Homogeneous_Model;

#endif

#ifndef _EFL_UI_HOMOGENEOUS_MODEL_EO_TYPES
#define _EFL_UI_HOMOGENEOUS_MODEL_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Class to be used to store object item size for List/Grid View.
 *
 * This model provides the properties <tt>"item.width"</tt> and
 * <tt>"item.height"</tt> which have the same value for all siblings of this
 * object. The first sibling that defines <tt>"self.width"</tt> and
 * <tt>"self.height"</tt> set them for all other siblings and also set
 * <tt>"item.width"</tt> and <tt>"item.height"</tt> for the parent (See
 * @ref Efl_Ui_Size_Model).
 *
 * Subsequent attempts to set <tt>"self.width"</tt> or
 * <tt>"self.height"</tt> will fail with a Read Only error code.
 *
 * The properties <tt>"total.width"</tt> and <tt>"total.height"</tt>
 * are computed from the number of node, the <tt>"self.width"</tt> and
 * <tt>"self.height"</tt> assuming that the View is a vertical list.
 *
 * @ingroup Efl_Ui_Homogeneous_Model
 */
#define EFL_UI_HOMOGENEOUS_MODEL_CLASS efl_ui_homogeneous_model_class_get()

EAPI EAPI_WEAK const Efl_Class *efl_ui_homogeneous_model_class_get(void) EINA_CONST;
#endif /* EFL_BETA_API_SUPPORT */

#endif
