// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/user.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UserState int32

const (
	UserState_USER_STATE_UNSPECIFIED UserState = 0
	UserState_USER_STATE_ACTIVE      UserState = 1
	UserState_USER_STATE_DEACTIVATED UserState = 2
)

// Enum value maps for UserState.
var (
	UserState_name = map[int32]string{
		0: "USER_STATE_UNSPECIFIED",
		1: "USER_STATE_ACTIVE",
		2: "USER_STATE_DEACTIVATED",
	}
	UserState_value = map[string]int32{
		"USER_STATE_UNSPECIFIED": 0,
		"USER_STATE_ACTIVE":      1,
		"USER_STATE_DEACTIVATED": 2,
	}
)

func (x UserState) Enum() *UserState {
	p := new(UserState)
	*p = x
	return p
}

func (x UserState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserState) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_user_proto_enumTypes[0].Descriptor()
}

func (UserState) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_user_proto_enumTypes[0]
}

func (x UserState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type UserType int32

const (
	UserType_USER_TYPE_UNSPECIFIED UserType = 0
	UserType_USER_TYPE_PERSONAL    UserType = 1
	UserType_USER_TYPE_MACHINE     UserType = 2
	UserType_USER_TYPE_SYSTEM      UserType = 3
)

// Enum value maps for UserType.
var (
	UserType_name = map[int32]string{
		0: "USER_TYPE_UNSPECIFIED",
		1: "USER_TYPE_PERSONAL",
		2: "USER_TYPE_MACHINE",
		3: "USER_TYPE_SYSTEM",
	}
	UserType_value = map[string]int32{
		"USER_TYPE_UNSPECIFIED": 0,
		"USER_TYPE_PERSONAL":    1,
		"USER_TYPE_MACHINE":     2,
		"USER_TYPE_SYSTEM":      3,
	}
)

func (x UserType) Enum() *UserType {
	p := new(UserType)
	*p = x
	return p
}

func (x UserType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_user_proto_enumTypes[1].Descriptor()
}

func (UserType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_user_proto_enumTypes[1]
}

func (x UserType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type User struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Username           string                 `protobuf:"bytes,4,opt,name=username,proto3"`
	xxx_hidden_Deactivated        bool                   `protobuf:"varint,5,opt,name=deactivated,proto3"`
	xxx_hidden_Description        string                 `protobuf:"bytes,6,opt,name=description,proto3"`
	xxx_hidden_Url                string                 `protobuf:"bytes,7,opt,name=url,proto3"`
	xxx_hidden_VerificationStatus VerificationStatus     `protobuf:"varint,8,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	xxx_hidden_UserType           UserType               `protobuf:"varint,9,opt,name=user_type,json=userType,proto3,enum=buf.alpha.registry.v1alpha1.UserType"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *User) Reset() {
	*x = User{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *User) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *User) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *User) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *User) GetUsername() string {
	if x != nil {
		return x.xxx_hidden_Username
	}
	return ""
}

func (x *User) GetDeactivated() bool {
	if x != nil {
		return x.xxx_hidden_Deactivated
	}
	return false
}

func (x *User) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *User) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *User) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *User) GetUserType() UserType {
	if x != nil {
		return x.xxx_hidden_UserType
	}
	return UserType_USER_TYPE_UNSPECIFIED
}

func (x *User) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *User) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *User) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *User) SetUsername(v string) {
	x.xxx_hidden_Username = v
}

func (x *User) SetDeactivated(v bool) {
	x.xxx_hidden_Deactivated = v
}

func (x *User) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *User) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *User) SetVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

func (x *User) SetUserType(v UserType) {
	x.xxx_hidden_UserType = v
}

func (x *User) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *User) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *User) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *User) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type User_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique, immutable
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// mutable
	UpdateTime *timestamppb.Timestamp
	// unique, mutable
	Username string
	// mutable
	Deactivated bool
	// description is the user configurable description of the user.
	Description string
	// url is the user configurable URL in the description of the user,
	// always included the scheme and will not have a #fragment suffix.
	Url string
	// verification status of the user, configurable by server admin.
	VerificationStatus VerificationStatus
	// user type of the user, depends on how the user was created.
	UserType UserType
}

func (b0 User_builder) Build() *User {
	m0 := &User{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Username = b.Username
	x.xxx_hidden_Deactivated = b.Deactivated
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	x.xxx_hidden_UserType = b.UserType
	return m0
}

// TODO: #663 move this to organization service
type OrganizationUser struct {
	state                             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User                   *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	xxx_hidden_OrganizationId         string                 `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationRole       OrganizationRole       `protobuf:"varint,3,opt,name=organization_role,json=organizationRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_OrganizationRoleSource OrganizationRoleSource `protobuf:"varint,4,opt,name=organization_role_source,json=organizationRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *OrganizationUser) Reset() {
	*x = OrganizationUser{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationUser) ProtoMessage() {}

func (x *OrganizationUser) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OrganizationUser) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *OrganizationUser) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *OrganizationUser) GetOrganizationRole() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OrganizationRole
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *OrganizationUser) GetOrganizationRoleSource() OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_OrganizationRoleSource
	}
	return OrganizationRoleSource_ORGANIZATION_ROLE_SOURCE_UNSPECIFIED
}

func (x *OrganizationUser) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *OrganizationUser) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *OrganizationUser) SetOrganizationRole(v OrganizationRole) {
	x.xxx_hidden_OrganizationRole = v
}

func (x *OrganizationUser) SetOrganizationRoleSource(v OrganizationRoleSource) {
	x.xxx_hidden_OrganizationRoleSource = v
}

func (x *OrganizationUser) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *OrganizationUser) ClearUser() {
	x.xxx_hidden_User = nil
}

type OrganizationUser_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
	// The ID of the organization for which the role belongs to.
	OrganizationId string
	// The role that the user has in the organization above.
	OrganizationRole OrganizationRole
	// The source of the user's role in the organization above.
	OrganizationRoleSource OrganizationRoleSource
}

func (b0 OrganizationUser_builder) Build() *OrganizationUser {
	m0 := &OrganizationUser{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationRole = b.OrganizationRole
	x.xxx_hidden_OrganizationRoleSource = b.OrganizationRoleSource
	return m0
}

type CreateUserRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Username string                 `protobuf:"bytes,1,opt,name=username,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CreateUserRequest) Reset() {
	*x = CreateUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserRequest) ProtoMessage() {}

func (x *CreateUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateUserRequest) GetUsername() string {
	if x != nil {
		return x.xxx_hidden_Username
	}
	return ""
}

func (x *CreateUserRequest) SetUsername(v string) {
	x.xxx_hidden_Username = v
}

type CreateUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Username string
}

func (b0 CreateUserRequest_builder) Build() *CreateUserRequest {
	m0 := &CreateUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Username = b.Username
	return m0
}

type CreateUserResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *CreateUserResponse) Reset() {
	*x = CreateUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserResponse) ProtoMessage() {}

func (x *CreateUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateUserResponse) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *CreateUserResponse) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *CreateUserResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *CreateUserResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type CreateUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
}

func (b0 CreateUserResponse_builder) Build() *CreateUserResponse {
	m0 := &CreateUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	return m0
}

type GetUserRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserRequest) Reset() {
	*x = GetUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserRequest) ProtoMessage() {}

func (x *GetUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *GetUserRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type GetUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 GetUserRequest_builder) Build() *GetUserRequest {
	m0 := &GetUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type GetUserResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetUserResponse) Reset() {
	*x = GetUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserResponse) ProtoMessage() {}

func (x *GetUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserResponse) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *GetUserResponse) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *GetUserResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *GetUserResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type GetUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
}

func (b0 GetUserResponse_builder) Build() *GetUserResponse {
	m0 := &GetUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	return m0
}

type GetUserByUsernameRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Username string                 `protobuf:"bytes,1,opt,name=username,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetUserByUsernameRequest) Reset() {
	*x = GetUserByUsernameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserByUsernameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserByUsernameRequest) ProtoMessage() {}

func (x *GetUserByUsernameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserByUsernameRequest) GetUsername() string {
	if x != nil {
		return x.xxx_hidden_Username
	}
	return ""
}

func (x *GetUserByUsernameRequest) SetUsername(v string) {
	x.xxx_hidden_Username = v
}

type GetUserByUsernameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Username string
}

func (b0 GetUserByUsernameRequest_builder) Build() *GetUserByUsernameRequest {
	m0 := &GetUserByUsernameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Username = b.Username
	return m0
}

type GetUserByUsernameResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetUserByUsernameResponse) Reset() {
	*x = GetUserByUsernameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserByUsernameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserByUsernameResponse) ProtoMessage() {}

func (x *GetUserByUsernameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserByUsernameResponse) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *GetUserByUsernameResponse) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *GetUserByUsernameResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *GetUserByUsernameResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type GetUserByUsernameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
}

func (b0 GetUserByUsernameResponse_builder) Build() *GetUserByUsernameResponse {
	m0 := &GetUserByUsernameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	return m0
}

type ListUsersRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize        uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken       string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse         bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	xxx_hidden_UserStateFilter UserState              `protobuf:"varint,4,opt,name=user_state_filter,json=userStateFilter,proto3,enum=buf.alpha.registry.v1alpha1.UserState"`
	xxx_hidden_UserTypeFilters []UserType             `protobuf:"varint,5,rep,packed,name=user_type_filters,json=userTypeFilters,proto3,enum=buf.alpha.registry.v1alpha1.UserType"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ListUsersRequest) Reset() {
	*x = ListUsersRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersRequest) ProtoMessage() {}

func (x *ListUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUsersRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListUsersRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListUsersRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListUsersRequest) GetUserStateFilter() UserState {
	if x != nil {
		return x.xxx_hidden_UserStateFilter
	}
	return UserState_USER_STATE_UNSPECIFIED
}

func (x *ListUsersRequest) GetUserTypeFilters() []UserType {
	if x != nil {
		return x.xxx_hidden_UserTypeFilters
	}
	return nil
}

func (x *ListUsersRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListUsersRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListUsersRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

func (x *ListUsersRequest) SetUserStateFilter(v UserState) {
	x.xxx_hidden_UserStateFilter = v
}

func (x *ListUsersRequest) SetUserTypeFilters(v []UserType) {
	x.xxx_hidden_UserTypeFilters = v
}

type ListUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
	// If the user_state_filter is unspecified, users of all states are included.
	UserStateFilter UserState
	// If the user_type_filters is empty, users of all types are included.
	UserTypeFilters []UserType
}

func (b0 ListUsersRequest_builder) Build() *ListUsersRequest {
	m0 := &ListUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	x.xxx_hidden_UserStateFilter = b.UserStateFilter
	x.xxx_hidden_UserTypeFilters = b.UserTypeFilters
	return m0
}

type ListUsersResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Users         *[]*User               `protobuf:"bytes,1,rep,name=users,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListUsersResponse) Reset() {
	*x = ListUsersResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersResponse) ProtoMessage() {}

func (x *ListUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUsersResponse) GetUsers() []*User {
	if x != nil {
		if x.xxx_hidden_Users != nil {
			return *x.xxx_hidden_Users
		}
	}
	return nil
}

func (x *ListUsersResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListUsersResponse) SetUsers(v []*User) {
	x.xxx_hidden_Users = &v
}

func (x *ListUsersResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Users []*User
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListUsersResponse_builder) Build() *ListUsersResponse {
	m0 := &ListUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Users = &b.Users
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListOrganizationUsersRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_PageSize       uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken      string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse        bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ListOrganizationUsersRequest) Reset() {
	*x = ListOrganizationUsersRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationUsersRequest) ProtoMessage() {}

func (x *ListOrganizationUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationUsersRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *ListOrganizationUsersRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListOrganizationUsersRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListOrganizationUsersRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListOrganizationUsersRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *ListOrganizationUsersRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListOrganizationUsersRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListOrganizationUsersRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListOrganizationUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OrganizationId string
	PageSize       uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListOrganizationUsersRequest_builder) Build() *ListOrganizationUsersRequest {
	m0 := &ListOrganizationUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListOrganizationUsersResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Users         *[]*OrganizationUser   `protobuf:"bytes,1,rep,name=users,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListOrganizationUsersResponse) Reset() {
	*x = ListOrganizationUsersResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationUsersResponse) ProtoMessage() {}

func (x *ListOrganizationUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationUsersResponse) GetUsers() []*OrganizationUser {
	if x != nil {
		if x.xxx_hidden_Users != nil {
			return *x.xxx_hidden_Users
		}
	}
	return nil
}

func (x *ListOrganizationUsersResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListOrganizationUsersResponse) SetUsers(v []*OrganizationUser) {
	x.xxx_hidden_Users = &v
}

func (x *ListOrganizationUsersResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListOrganizationUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Users []*OrganizationUser
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListOrganizationUsersResponse_builder) Build() *ListOrganizationUsersResponse {
	m0 := &ListOrganizationUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Users = &b.Users
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type DeleteUserRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteUserRequest) Reset() {
	*x = DeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserRequest) ProtoMessage() {}

func (x *DeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteUserRequest_builder) Build() *DeleteUserRequest {
	m0 := &DeleteUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeleteUserResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteUserResponse) Reset() {
	*x = DeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserResponse) ProtoMessage() {}

func (x *DeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteUserResponse_builder) Build() *DeleteUserResponse {
	m0 := &DeleteUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeactivateUserRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeactivateUserRequest) Reset() {
	*x = DeactivateUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeactivateUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeactivateUserRequest) ProtoMessage() {}

func (x *DeactivateUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeactivateUserRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *DeactivateUserRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type DeactivateUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 DeactivateUserRequest_builder) Build() *DeactivateUserRequest {
	m0 := &DeactivateUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type DeactivateUserResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeactivateUserResponse) Reset() {
	*x = DeactivateUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeactivateUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeactivateUserResponse) ProtoMessage() {}

func (x *DeactivateUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeactivateUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeactivateUserResponse_builder) Build() *DeactivateUserResponse {
	m0 := &DeactivateUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UpdateUserServerRoleRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId     string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_ServerRole ServerRole             `protobuf:"varint,2,opt,name=server_role,json=serverRole,proto3,enum=buf.alpha.registry.v1alpha1.ServerRole"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UpdateUserServerRoleRequest) Reset() {
	*x = UpdateUserServerRoleRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserServerRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserServerRoleRequest) ProtoMessage() {}

func (x *UpdateUserServerRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUserServerRoleRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *UpdateUserServerRoleRequest) GetServerRole() ServerRole {
	if x != nil {
		return x.xxx_hidden_ServerRole
	}
	return ServerRole_SERVER_ROLE_UNSPECIFIED
}

func (x *UpdateUserServerRoleRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *UpdateUserServerRoleRequest) SetServerRole(v ServerRole) {
	x.xxx_hidden_ServerRole = v
}

type UpdateUserServerRoleRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the user for which to be updated a role.
	UserId string
	// The new role of the user in the server.
	ServerRole ServerRole
}

func (b0 UpdateUserServerRoleRequest_builder) Build() *UpdateUserServerRoleRequest {
	m0 := &UpdateUserServerRoleRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_ServerRole = b.ServerRole
	return m0
}

type UpdateUserServerRoleResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUserServerRoleResponse) Reset() {
	*x = UpdateUserServerRoleResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserServerRoleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserServerRoleResponse) ProtoMessage() {}

func (x *UpdateUserServerRoleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateUserServerRoleResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateUserServerRoleResponse_builder) Build() *UpdateUserServerRoleResponse {
	m0 := &UpdateUserServerRoleResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type CountUsersRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserStateFilter UserState              `protobuf:"varint,1,opt,name=user_state_filter,json=userStateFilter,proto3,enum=buf.alpha.registry.v1alpha1.UserState"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *CountUsersRequest) Reset() {
	*x = CountUsersRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountUsersRequest) ProtoMessage() {}

func (x *CountUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CountUsersRequest) GetUserStateFilter() UserState {
	if x != nil {
		return x.xxx_hidden_UserStateFilter
	}
	return UserState_USER_STATE_UNSPECIFIED
}

func (x *CountUsersRequest) SetUserStateFilter(v UserState) {
	x.xxx_hidden_UserStateFilter = v
}

type CountUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// If the user_state_filter is unspecified, all users are included.
	UserStateFilter UserState
}

func (b0 CountUsersRequest_builder) Build() *CountUsersRequest {
	m0 := &CountUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserStateFilter = b.UserStateFilter
	return m0
}

type CountUsersResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TotalCount uint32                 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CountUsersResponse) Reset() {
	*x = CountUsersResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountUsersResponse) ProtoMessage() {}

func (x *CountUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CountUsersResponse) GetTotalCount() uint32 {
	if x != nil {
		return x.xxx_hidden_TotalCount
	}
	return 0
}

func (x *CountUsersResponse) SetTotalCount(v uint32) {
	x.xxx_hidden_TotalCount = v
}

type CountUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TotalCount uint32
}

func (b0 CountUsersResponse_builder) Build() *CountUsersResponse {
	m0 := &CountUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TotalCount = b.TotalCount
	return m0
}

type UpdateUserSettingsRequest struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId      string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_Description *string                `protobuf:"bytes,2,opt,name=description,proto3,oneof"`
	xxx_hidden_Url         *string                `protobuf:"bytes,3,opt,name=url,proto3,oneof"`
	XXX_raceDetectHookData protoimpl.RaceDetectHookData
	XXX_presence           [1]uint32
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *UpdateUserSettingsRequest) Reset() {
	*x = UpdateUserSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserSettingsRequest) ProtoMessage() {}

func (x *UpdateUserSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUserSettingsRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *UpdateUserSettingsRequest) GetDescription() string {
	if x != nil {
		if x.xxx_hidden_Description != nil {
			return *x.xxx_hidden_Description
		}
		return ""
	}
	return ""
}

func (x *UpdateUserSettingsRequest) GetUrl() string {
	if x != nil {
		if x.xxx_hidden_Url != nil {
			return *x.xxx_hidden_Url
		}
		return ""
	}
	return ""
}

func (x *UpdateUserSettingsRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *UpdateUserSettingsRequest) SetDescription(v string) {
	x.xxx_hidden_Description = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 3)
}

func (x *UpdateUserSettingsRequest) SetUrl(v string) {
	x.xxx_hidden_Url = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 3)
}

func (x *UpdateUserSettingsRequest) HasDescription() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *UpdateUserSettingsRequest) HasUrl() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdateUserSettingsRequest) ClearDescription() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_Description = nil
}

func (x *UpdateUserSettingsRequest) ClearUrl() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_Url = nil
}

type UpdateUserSettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	UserId string
	// optional, update to description will only be made when this is present
	Description *string
	// optional, update to url will only be made when this is present
	Url *string
}

func (b0 UpdateUserSettingsRequest_builder) Build() *UpdateUserSettingsRequest {
	m0 := &UpdateUserSettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	if b.Description != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 3)
		x.xxx_hidden_Description = b.Description
	}
	if b.Url != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 3)
		x.xxx_hidden_Url = b.Url
	}
	return m0
}

type UpdateUserSettingsResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUserSettingsResponse) Reset() {
	*x = UpdateUserSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserSettingsResponse) ProtoMessage() {}

func (x *UpdateUserSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateUserSettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateUserSettingsResponse_builder) Build() *UpdateUserSettingsResponse {
	m0 := &UpdateUserSettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_user_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_user_proto_rawDesc = "" +
	"\n" +
	"&buf/alpha/registry/v1alpha1/user.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/registry/v1alpha1/role.proto\x1a5buf/alpha/registry/v1alpha1/verification_status.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xa8\x03\n" +
	"\x04User\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12;\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"updateTime\x12\x1a\n" +
	"\busername\x18\x04 \x01(\tR\busername\x12 \n" +
	"\vdeactivated\x18\x05 \x01(\bR\vdeactivated\x12 \n" +
	"\vdescription\x18\x06 \x01(\tR\vdescription\x12\x10\n" +
	"\x03url\x18\a \x01(\tR\x03url\x12`\n" +
	"\x13verification_status\x18\b \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x12verificationStatus\x12B\n" +
	"\tuser_type\x18\t \x01(\x0e2%.buf.alpha.registry.v1alpha1.UserTypeR\buserType\"\xbd\x02\n" +
	"\x10OrganizationUser\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\x12'\n" +
	"\x0forganization_id\x18\x02 \x01(\tR\x0eorganizationId\x12Z\n" +
	"\x11organization_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x10organizationRole\x12m\n" +
	"\x18organization_role_source\x18\x04 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x16organizationRoleSource\"/\n" +
	"\x11CreateUserRequest\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"K\n" +
	"\x12CreateUserResponse\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\" \n" +
	"\x0eGetUserRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"H\n" +
	"\x0fGetUserResponse\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\"6\n" +
	"\x18GetUserByUsernameRequest\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"R\n" +
	"\x19GetUserByUsernameResponse\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\"\x8f\x02\n" +
	"\x10ListUsersRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\x12R\n" +
	"\x11user_state_filter\x18\x04 \x01(\x0e2&.buf.alpha.registry.v1alpha1.UserStateR\x0fuserStateFilter\x12Q\n" +
	"\x11user_type_filters\x18\x05 \x03(\x0e2%.buf.alpha.registry.v1alpha1.UserTypeR\x0fuserTypeFilters\"t\n" +
	"\x11ListUsersResponse\x127\n" +
	"\x05users\x18\x01 \x03(\v2!.buf.alpha.registry.v1alpha1.UserR\x05users\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x9d\x01\n" +
	"\x1cListOrganizationUsersRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\x8c\x01\n" +
	"\x1dListOrganizationUsersResponse\x12C\n" +
	"\x05users\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.OrganizationUserR\x05users\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x13\n" +
	"\x11DeleteUserRequest\"\x14\n" +
	"\x12DeleteUserResponse\"'\n" +
	"\x15DeactivateUserRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"\x18\n" +
	"\x16DeactivateUserResponse\"\x80\x01\n" +
	"\x1bUpdateUserServerRoleRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12H\n" +
	"\vserver_role\x18\x02 \x01(\x0e2'.buf.alpha.registry.v1alpha1.ServerRoleR\n" +
	"serverRole\"\x1e\n" +
	"\x1cUpdateUserServerRoleResponse\"g\n" +
	"\x11CountUsersRequest\x12R\n" +
	"\x11user_state_filter\x18\x01 \x01(\x0e2&.buf.alpha.registry.v1alpha1.UserStateR\x0fuserStateFilter\"5\n" +
	"\x12CountUsersResponse\x12\x1f\n" +
	"\vtotal_count\x18\x01 \x01(\rR\n" +
	"totalCount\"\x8a\x01\n" +
	"\x19UpdateUserSettingsRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12%\n" +
	"\vdescription\x18\x02 \x01(\tH\x00R\vdescription\x88\x01\x01\x12\x15\n" +
	"\x03url\x18\x03 \x01(\tH\x01R\x03url\x88\x01\x01B\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_url\"\x1c\n" +
	"\x1aUpdateUserSettingsResponse*Z\n" +
	"\tUserState\x12\x1a\n" +
	"\x16USER_STATE_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11USER_STATE_ACTIVE\x10\x01\x12\x1a\n" +
	"\x16USER_STATE_DEACTIVATED\x10\x02*j\n" +
	"\bUserType\x12\x19\n" +
	"\x15USER_TYPE_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12USER_TYPE_PERSONAL\x10\x01\x12\x15\n" +
	"\x11USER_TYPE_MACHINE\x10\x02\x12\x14\n" +
	"\x10USER_TYPE_SYSTEM\x10\x032\xfb\t\n" +
	"\vUserService\x12r\n" +
	"\n" +
	"CreateUser\x12..buf.alpha.registry.v1alpha1.CreateUserRequest\x1a/.buf.alpha.registry.v1alpha1.CreateUserResponse\"\x03\x90\x02\x02\x12i\n" +
	"\aGetUser\x12+.buf.alpha.registry.v1alpha1.GetUserRequest\x1a,.buf.alpha.registry.v1alpha1.GetUserResponse\"\x03\x90\x02\x01\x12\x87\x01\n" +
	"\x11GetUserByUsername\x125.buf.alpha.registry.v1alpha1.GetUserByUsernameRequest\x1a6.buf.alpha.registry.v1alpha1.GetUserByUsernameResponse\"\x03\x90\x02\x01\x12o\n" +
	"\tListUsers\x12-.buf.alpha.registry.v1alpha1.ListUsersRequest\x1a..buf.alpha.registry.v1alpha1.ListUsersResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15ListOrganizationUsers\x129.buf.alpha.registry.v1alpha1.ListOrganizationUsersRequest\x1a:.buf.alpha.registry.v1alpha1.ListOrganizationUsersResponse\"\x03\x90\x02\x01\x12r\n" +
	"\n" +
	"DeleteUser\x12..buf.alpha.registry.v1alpha1.DeleteUserRequest\x1a/.buf.alpha.registry.v1alpha1.DeleteUserResponse\"\x03\x90\x02\x02\x12~\n" +
	"\x0eDeactivateUser\x122.buf.alpha.registry.v1alpha1.DeactivateUserRequest\x1a3.buf.alpha.registry.v1alpha1.DeactivateUserResponse\"\x03\x90\x02\x02\x12\x8b\x01\n" +
	"\x14UpdateUserServerRole\x128.buf.alpha.registry.v1alpha1.UpdateUserServerRoleRequest\x1a9.buf.alpha.registry.v1alpha1.UpdateUserServerRoleResponse\x12r\n" +
	"\n" +
	"CountUsers\x12..buf.alpha.registry.v1alpha1.CountUsersRequest\x1a/.buf.alpha.registry.v1alpha1.CountUsersResponse\"\x03\x90\x02\x01\x12\x85\x01\n" +
	"\x12UpdateUserSettings\x126.buf.alpha.registry.v1alpha1.UpdateUserSettingsRequest\x1a7.buf.alpha.registry.v1alpha1.UpdateUserSettingsResponseB\x96\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\tUserProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_user_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_alpha_registry_v1alpha1_user_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_buf_alpha_registry_v1alpha1_user_proto_goTypes = []any{
	(UserState)(0),                        // 0: buf.alpha.registry.v1alpha1.UserState
	(UserType)(0),                         // 1: buf.alpha.registry.v1alpha1.UserType
	(*User)(nil),                          // 2: buf.alpha.registry.v1alpha1.User
	(*OrganizationUser)(nil),              // 3: buf.alpha.registry.v1alpha1.OrganizationUser
	(*CreateUserRequest)(nil),             // 4: buf.alpha.registry.v1alpha1.CreateUserRequest
	(*CreateUserResponse)(nil),            // 5: buf.alpha.registry.v1alpha1.CreateUserResponse
	(*GetUserRequest)(nil),                // 6: buf.alpha.registry.v1alpha1.GetUserRequest
	(*GetUserResponse)(nil),               // 7: buf.alpha.registry.v1alpha1.GetUserResponse
	(*GetUserByUsernameRequest)(nil),      // 8: buf.alpha.registry.v1alpha1.GetUserByUsernameRequest
	(*GetUserByUsernameResponse)(nil),     // 9: buf.alpha.registry.v1alpha1.GetUserByUsernameResponse
	(*ListUsersRequest)(nil),              // 10: buf.alpha.registry.v1alpha1.ListUsersRequest
	(*ListUsersResponse)(nil),             // 11: buf.alpha.registry.v1alpha1.ListUsersResponse
	(*ListOrganizationUsersRequest)(nil),  // 12: buf.alpha.registry.v1alpha1.ListOrganizationUsersRequest
	(*ListOrganizationUsersResponse)(nil), // 13: buf.alpha.registry.v1alpha1.ListOrganizationUsersResponse
	(*DeleteUserRequest)(nil),             // 14: buf.alpha.registry.v1alpha1.DeleteUserRequest
	(*DeleteUserResponse)(nil),            // 15: buf.alpha.registry.v1alpha1.DeleteUserResponse
	(*DeactivateUserRequest)(nil),         // 16: buf.alpha.registry.v1alpha1.DeactivateUserRequest
	(*DeactivateUserResponse)(nil),        // 17: buf.alpha.registry.v1alpha1.DeactivateUserResponse
	(*UpdateUserServerRoleRequest)(nil),   // 18: buf.alpha.registry.v1alpha1.UpdateUserServerRoleRequest
	(*UpdateUserServerRoleResponse)(nil),  // 19: buf.alpha.registry.v1alpha1.UpdateUserServerRoleResponse
	(*CountUsersRequest)(nil),             // 20: buf.alpha.registry.v1alpha1.CountUsersRequest
	(*CountUsersResponse)(nil),            // 21: buf.alpha.registry.v1alpha1.CountUsersResponse
	(*UpdateUserSettingsRequest)(nil),     // 22: buf.alpha.registry.v1alpha1.UpdateUserSettingsRequest
	(*UpdateUserSettingsResponse)(nil),    // 23: buf.alpha.registry.v1alpha1.UpdateUserSettingsResponse
	(*timestamppb.Timestamp)(nil),         // 24: google.protobuf.Timestamp
	(VerificationStatus)(0),               // 25: buf.alpha.registry.v1alpha1.VerificationStatus
	(OrganizationRole)(0),                 // 26: buf.alpha.registry.v1alpha1.OrganizationRole
	(OrganizationRoleSource)(0),           // 27: buf.alpha.registry.v1alpha1.OrganizationRoleSource
	(ServerRole)(0),                       // 28: buf.alpha.registry.v1alpha1.ServerRole
}
var file_buf_alpha_registry_v1alpha1_user_proto_depIdxs = []int32{
	24, // 0: buf.alpha.registry.v1alpha1.User.create_time:type_name -> google.protobuf.Timestamp
	24, // 1: buf.alpha.registry.v1alpha1.User.update_time:type_name -> google.protobuf.Timestamp
	25, // 2: buf.alpha.registry.v1alpha1.User.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	1,  // 3: buf.alpha.registry.v1alpha1.User.user_type:type_name -> buf.alpha.registry.v1alpha1.UserType
	2,  // 4: buf.alpha.registry.v1alpha1.OrganizationUser.user:type_name -> buf.alpha.registry.v1alpha1.User
	26, // 5: buf.alpha.registry.v1alpha1.OrganizationUser.organization_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	27, // 6: buf.alpha.registry.v1alpha1.OrganizationUser.organization_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	2,  // 7: buf.alpha.registry.v1alpha1.CreateUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	2,  // 8: buf.alpha.registry.v1alpha1.GetUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	2,  // 9: buf.alpha.registry.v1alpha1.GetUserByUsernameResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	0,  // 10: buf.alpha.registry.v1alpha1.ListUsersRequest.user_state_filter:type_name -> buf.alpha.registry.v1alpha1.UserState
	1,  // 11: buf.alpha.registry.v1alpha1.ListUsersRequest.user_type_filters:type_name -> buf.alpha.registry.v1alpha1.UserType
	2,  // 12: buf.alpha.registry.v1alpha1.ListUsersResponse.users:type_name -> buf.alpha.registry.v1alpha1.User
	3,  // 13: buf.alpha.registry.v1alpha1.ListOrganizationUsersResponse.users:type_name -> buf.alpha.registry.v1alpha1.OrganizationUser
	28, // 14: buf.alpha.registry.v1alpha1.UpdateUserServerRoleRequest.server_role:type_name -> buf.alpha.registry.v1alpha1.ServerRole
	0,  // 15: buf.alpha.registry.v1alpha1.CountUsersRequest.user_state_filter:type_name -> buf.alpha.registry.v1alpha1.UserState
	4,  // 16: buf.alpha.registry.v1alpha1.UserService.CreateUser:input_type -> buf.alpha.registry.v1alpha1.CreateUserRequest
	6,  // 17: buf.alpha.registry.v1alpha1.UserService.GetUser:input_type -> buf.alpha.registry.v1alpha1.GetUserRequest
	8,  // 18: buf.alpha.registry.v1alpha1.UserService.GetUserByUsername:input_type -> buf.alpha.registry.v1alpha1.GetUserByUsernameRequest
	10, // 19: buf.alpha.registry.v1alpha1.UserService.ListUsers:input_type -> buf.alpha.registry.v1alpha1.ListUsersRequest
	12, // 20: buf.alpha.registry.v1alpha1.UserService.ListOrganizationUsers:input_type -> buf.alpha.registry.v1alpha1.ListOrganizationUsersRequest
	14, // 21: buf.alpha.registry.v1alpha1.UserService.DeleteUser:input_type -> buf.alpha.registry.v1alpha1.DeleteUserRequest
	16, // 22: buf.alpha.registry.v1alpha1.UserService.DeactivateUser:input_type -> buf.alpha.registry.v1alpha1.DeactivateUserRequest
	18, // 23: buf.alpha.registry.v1alpha1.UserService.UpdateUserServerRole:input_type -> buf.alpha.registry.v1alpha1.UpdateUserServerRoleRequest
	20, // 24: buf.alpha.registry.v1alpha1.UserService.CountUsers:input_type -> buf.alpha.registry.v1alpha1.CountUsersRequest
	22, // 25: buf.alpha.registry.v1alpha1.UserService.UpdateUserSettings:input_type -> buf.alpha.registry.v1alpha1.UpdateUserSettingsRequest
	5,  // 26: buf.alpha.registry.v1alpha1.UserService.CreateUser:output_type -> buf.alpha.registry.v1alpha1.CreateUserResponse
	7,  // 27: buf.alpha.registry.v1alpha1.UserService.GetUser:output_type -> buf.alpha.registry.v1alpha1.GetUserResponse
	9,  // 28: buf.alpha.registry.v1alpha1.UserService.GetUserByUsername:output_type -> buf.alpha.registry.v1alpha1.GetUserByUsernameResponse
	11, // 29: buf.alpha.registry.v1alpha1.UserService.ListUsers:output_type -> buf.alpha.registry.v1alpha1.ListUsersResponse
	13, // 30: buf.alpha.registry.v1alpha1.UserService.ListOrganizationUsers:output_type -> buf.alpha.registry.v1alpha1.ListOrganizationUsersResponse
	15, // 31: buf.alpha.registry.v1alpha1.UserService.DeleteUser:output_type -> buf.alpha.registry.v1alpha1.DeleteUserResponse
	17, // 32: buf.alpha.registry.v1alpha1.UserService.DeactivateUser:output_type -> buf.alpha.registry.v1alpha1.DeactivateUserResponse
	19, // 33: buf.alpha.registry.v1alpha1.UserService.UpdateUserServerRole:output_type -> buf.alpha.registry.v1alpha1.UpdateUserServerRoleResponse
	21, // 34: buf.alpha.registry.v1alpha1.UserService.CountUsers:output_type -> buf.alpha.registry.v1alpha1.CountUsersResponse
	23, // 35: buf.alpha.registry.v1alpha1.UserService.UpdateUserSettings:output_type -> buf.alpha.registry.v1alpha1.UpdateUserSettingsResponse
	26, // [26:36] is the sub-list for method output_type
	16, // [16:26] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_user_proto_init() }
func file_buf_alpha_registry_v1alpha1_user_proto_init() {
	if File_buf_alpha_registry_v1alpha1_user_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_user_proto_msgTypes[20].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_user_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_user_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_user_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_user_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_user_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_user_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_user_proto = out.File
	file_buf_alpha_registry_v1alpha1_user_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_user_proto_depIdxs = nil
}
