/* Manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BLUETOOTH_TYPE_OBJECT_MANAGER (bluetooth_object_manager_get_type ())
#define BLUETOOTH_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager))
#define BLUETOOTH_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))
#define BLUETOOTH_IS_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_IS_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_OBJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))

typedef struct _BluetoothObjectManager BluetoothObjectManager;
typedef struct _BluetoothObjectManagerClass BluetoothObjectManagerClass;
typedef struct _BluetoothObjectManagerPrivate BluetoothObjectManagerPrivate;
enum  {
	BLUETOOTH_OBJECT_MANAGER_0_PROPERTY,
	BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY,
	BLUETOOTH_OBJECT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* bluetooth_object_manager_properties[BLUETOOTH_OBJECT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothObjectManagerCreateManagerData BluetoothObjectManagerCreateManagerData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_ADAPTER (bluetooth_adapter_get_type ())
#define BLUETOOTH_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter))
#define BLUETOOTH_IS_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_ADAPTER))
#define BLUETOOTH_ADAPTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapterIface))

typedef struct _BluetoothAdapter BluetoothAdapter;
typedef struct _BluetoothAdapterIface BluetoothAdapterIface;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BluetoothObjectManagerStartDiscoveryData BluetoothObjectManagerStartDiscoveryData;
typedef struct _BluetoothObjectManagerStopDiscoveryData BluetoothObjectManagerStopDiscoveryData;
enum  {
	BLUETOOTH_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL,
	BLUETOOTH_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL,
	BLUETOOTH_OBJECT_MANAGER_STATUS_DISCOVERING_SIGNAL,
	BLUETOOTH_OBJECT_MANAGER_NUM_SIGNALS
};
static guint bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BluetoothObjectManager {
	GObject parent_instance;
	BluetoothObjectManagerPrivate * priv;
};

struct _BluetoothObjectManagerClass {
	GObjectClass parent_class;
};

struct _BluetoothObjectManagerPrivate {
	gboolean _has_object;
	GDBusObjectManagerClient* object_manager;
};

struct _Block8Data {
	int _ref_count_;
	BluetoothObjectManager* self;
	GDBusObject* object;
};

struct _Block9Data {
	int _ref_count_;
	BluetoothObjectManager* self;
	GDBusObject* object;
};

struct _Block10Data {
	int _ref_count_;
	BluetoothObjectManager* self;
	GDBusObject* object;
};

struct _BluetoothObjectManagerCreateManagerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothObjectManager* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GDBusObjectManagerClient* _tmp6_;
	GDBusObjectManagerClient* _tmp7_;
	GDBusObjectManagerClient* _tmp8_;
	GDBusObjectManagerClient* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BluetoothAdapterIface {
	GTypeInterface parent_iface;
	void (*remove_device) (BluetoothAdapter* self, const char* device, GError** error);
	void (*set_discovery_filter) (BluetoothAdapter* self, GHashTable* properties, GError** error);
	void (*start_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	void (*stop_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_UUIDs) (BluetoothAdapter* self, gint* result_length1);
	gboolean (*get_discoverable) (BluetoothAdapter* self);
	void (*set_discoverable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_discovering) (BluetoothAdapter* self);
	gboolean (*get_pairable) (BluetoothAdapter* self);
	void (*set_pairable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_powered) (BluetoothAdapter* self);
	void (*set_powered) (BluetoothAdapter* self, gboolean value);
	gchar* (*get_address) (BluetoothAdapter* self);
	gchar* (*get_alias) (BluetoothAdapter* self);
	void (*set_alias) (BluetoothAdapter* self, const gchar* value);
	gchar* (*get_modalias) (BluetoothAdapter* self);
	gchar* (*get_name) (BluetoothAdapter* self);
	guint (*get_class) (BluetoothAdapter* self);
	guint (*get_discoverable_timeout) (BluetoothAdapter* self);
	guint (*get_pairable_timeout) (BluetoothAdapter* self);
};

struct _Block11Data {
	int _ref_count_;
	BluetoothObjectManager* self;
	GeeLinkedList* adapters;
};

struct _Block12Data {
	int _ref_count_;
	BluetoothObjectManager* self;
	GeeLinkedList* devices;
};

struct _BluetoothObjectManagerStartDiscoveryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothObjectManager* self;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp1_;
	gint _adapter_size;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _adapter_index;
	gint _tmp5_;
	gint _tmp6_;
	BluetoothAdapter* adapter;
	GeeLinkedList* _tmp7_;
	gpointer _tmp8_;
	BluetoothAdapter* _tmp9_;
	BluetoothAdapter* _tmp10_;
	GError* e;
	BluetoothAdapter* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _BluetoothObjectManagerStopDiscoveryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothObjectManager* self;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp1_;
	gint _adapter_size;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _adapter_index;
	gint _tmp5_;
	gint _tmp6_;
	BluetoothAdapter* adapter;
	GeeLinkedList* _tmp7_;
	gpointer _tmp8_;
	BluetoothAdapter* _tmp9_;
	gboolean _tmp10_;
	BluetoothAdapter* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	BluetoothAdapter* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	BluetoothAdapter* _tmp17_;
	GError* e;
	BluetoothAdapter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

static gint BluetoothObjectManager_private_offset;
static gpointer bluetooth_object_manager_parent_class = NULL;

VALA_EXTERN GType bluetooth_object_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObjectManager, g_object_unref)
static void bluetooth_object_manager_create_manager_data_free (gpointer _data);
VALA_EXTERN void bluetooth_object_manager_create_manager (BluetoothObjectManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void bluetooth_object_manager_create_manager_finish (BluetoothObjectManager* self,
                                                     GAsyncResult* _res_);
static gboolean bluetooth_object_manager_create_manager_co (BluetoothObjectManagerCreateManagerData* _data_);
static GType bluetooth_object_manager_object_manager_proxy_get_type (BluetoothObjectManager* self,
                                                              GDBusObjectManagerClient* manager,
                                                              const gchar* object_path,
                                                              const gchar* interface_name);
static GType _bluetooth_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                      const gchar* object_path,
                                                                                      const gchar* interface_name,
                                                                                      gpointer self);
static void bluetooth_object_manager_create_manager_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void ___lambda4_ (BluetoothObjectManager* self,
                  GDBusObject* object);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda5_ (Block8Data* _data8_,
                 GDBusInterface* iface);
static void bluetooth_object_manager_on_interface_added (BluetoothObjectManager* self,
                                                  GDBusObject* object,
                                                  GDBusInterface* iface);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda4__gfunc (gconstpointer data,
                         gpointer self);
static void _bluetooth_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                         GDBusObject* object,
                                                                                         GDBusInterface* interface_,
                                                                                         gpointer self);
static void bluetooth_object_manager_on_interface_removed (BluetoothObjectManager* self,
                                                    GDBusObject* object,
                                                    GDBusInterface* iface);
static void _bluetooth_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                             GDBusObject* object,
                                                                                             GDBusInterface* interface_,
                                                                                             gpointer self);
static void ___lambda8_ (BluetoothObjectManager* self,
                  GDBusObject* object);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda9_ (Block9Data* _data9_,
                 GDBusInterface* iface);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
static void ____lambda8__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                      GDBusObject* object,
                                                      gpointer self);
static void ___lambda10_ (BluetoothObjectManager* self,
                   GDBusObject* object);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda11_ (Block10Data* _data10_,
                  GDBusInterface* iface);
static void ___lambda11__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda10__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                         GDBusObject* object,
                                                         gpointer self);
GType bluetooth_device_proxy_get_type (void);
GType bluetooth_adapter_proxy_get_type (void);
static void bluetooth_object_manager_register_obex_agentmanager (BluetoothObjectManager* self);
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN guint bluetooth_adapter_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType bluetooth_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothAdapter, g_object_unref)
static void bluetooth_object_manager_set_has_object (BluetoothObjectManager* self,
                                              gboolean value);
static void ____lambda6_ (BluetoothObjectManager* self,
                   GVariant* changed,
                   gchar** invalid);
static void _____lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
VALA_EXTERN GeeLinkedList* bluetooth_object_manager_get_adapters (BluetoothObjectManager* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda7_ (Block11Data* _data11_,
                 GDBusObject* object);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN GeeCollection* bluetooth_object_manager_get_devices (BluetoothObjectManager* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda12_ (Block12Data* _data12_,
                  GDBusObject* object);
static void ___lambda12__gfunc (gconstpointer data,
                         gpointer self);
static void bluetooth_object_manager_start_discovery_data_free (gpointer _data);
VALA_EXTERN void bluetooth_object_manager_start_discovery (BluetoothObjectManager* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void bluetooth_object_manager_start_discovery_finish (BluetoothObjectManager* self,
                                                      GAsyncResult* _res_);
static gboolean bluetooth_object_manager_start_discovery_co (BluetoothObjectManagerStartDiscoveryData* _data_);
VALA_EXTERN void bluetooth_adapter_set_discoverable (BluetoothAdapter* self,
                                         gboolean value);
VALA_EXTERN void bluetooth_adapter_start_discovery (BluetoothAdapter* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void bluetooth_adapter_start_discovery_finish (BluetoothAdapter* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void bluetooth_object_manager_start_discovery_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN gchar* bluetooth_adapter_get_name (BluetoothAdapter* self);
VALA_EXTERN gboolean bluetooth_object_manager_check_discovering (BluetoothObjectManager* self);
VALA_EXTERN gboolean bluetooth_adapter_get_discovering (BluetoothAdapter* self);
static void bluetooth_object_manager_stop_discovery_data_free (gpointer _data);
VALA_EXTERN void bluetooth_object_manager_stop_discovery (BluetoothObjectManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void bluetooth_object_manager_stop_discovery_finish (BluetoothObjectManager* self,
                                                     GAsyncResult* _res_);
static gboolean bluetooth_object_manager_stop_discovery_co (BluetoothObjectManagerStopDiscoveryData* _data_);
VALA_EXTERN gboolean bluetooth_adapter_get_powered (BluetoothAdapter* self);
VALA_EXTERN void bluetooth_adapter_stop_discovery (BluetoothAdapter* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void bluetooth_adapter_stop_discovery_finish (BluetoothAdapter* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void bluetooth_object_manager_stop_discovery_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN BluetoothAdapter* bluetooth_object_manager_get_adapter_from_path (BluetoothObjectManager* self,
                                                                  const gchar* path);
VALA_EXTERN BluetoothDevice* bluetooth_object_manager_get_device (BluetoothObjectManager* self,
                                                      const gchar* address);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
VALA_EXTERN BluetoothObjectManager* bluetooth_object_manager_new (void);
VALA_EXTERN BluetoothObjectManager* bluetooth_object_manager_construct (GType object_type);
VALA_EXTERN gboolean bluetooth_object_manager_get_has_object (BluetoothObjectManager* self);
static GObject * bluetooth_object_manager_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void bluetooth_object_manager_finalize (GObject * obj);
static GType bluetooth_object_manager_get_type_once (void);
static void _vala_bluetooth_object_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_bluetooth_object_manager_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
bluetooth_object_manager_get_instance_private (BluetoothObjectManager* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothObjectManager_private_offset);
}

static void
bluetooth_object_manager_create_manager_data_free (gpointer _data)
{
	BluetoothObjectManagerCreateManagerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothObjectManagerCreateManagerData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bluetooth_object_manager_create_manager (BluetoothObjectManager* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	BluetoothObjectManagerCreateManagerData* _data_;
	BluetoothObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothObjectManagerCreateManagerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_object_manager_create_manager_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_object_manager_create_manager_co (_data_);
}

void
bluetooth_object_manager_create_manager_finish (BluetoothObjectManager* self,
                                                GAsyncResult* _res_)
{
	BluetoothObjectManagerCreateManagerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static GType
_bluetooth_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                const gchar* object_path,
                                                                                const gchar* interface_name,
                                                                                gpointer self)
{
	GType result;
	result = bluetooth_object_manager_object_manager_proxy_get_type ((BluetoothObjectManager*) self, manager, object_path, interface_name);
	return result;
}

static void
bluetooth_object_manager_create_manager_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	BluetoothObjectManagerCreateManagerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_object_manager_create_manager_co (_data_);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BluetoothObjectManager* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->object);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda5_ (Block8Data* _data8_,
            GDBusInterface* iface)
{
	BluetoothObjectManager* self;
	self = _data8_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_object_manager_on_interface_added (self, _data8_->object, iface);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (GDBusInterface*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda4_ (BluetoothObjectManager* self,
             GDBusObject* object)
{
	Block8Data* _data8_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data8_->object);
	_data8_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data8_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda5__gfunc, _data8_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
____lambda4__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda4_ ((BluetoothObjectManager*) self, (GDBusObject*) data);
}

static void
_bluetooth_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                    GDBusObject* object,
                                                                                    GDBusInterface* interface_,
                                                                                    gpointer self)
{
	bluetooth_object_manager_on_interface_added ((BluetoothObjectManager*) self, object, interface_);
}

static void
_bluetooth_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                        GDBusObject* object,
                                                                                        GDBusInterface* interface_,
                                                                                        gpointer self)
{
	bluetooth_object_manager_on_interface_removed ((BluetoothObjectManager*) self, object, interface_);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BluetoothObjectManager* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->object);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda9_ (Block9Data* _data9_,
            GDBusInterface* iface)
{
	BluetoothObjectManager* self;
	self = _data9_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_object_manager_on_interface_added (self, _data9_->object, iface);
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (GDBusInterface*) data);
}

static void
___lambda8_ (BluetoothObjectManager* self,
             GDBusObject* object)
{
	Block9Data* _data9_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data9_->object);
	_data9_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data9_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda9__gfunc, _data9_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
____lambda8__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                 GDBusObject* object,
                                                 gpointer self)
{
	___lambda8_ ((BluetoothObjectManager*) self, object);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BluetoothObjectManager* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->object);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda11_ (Block10Data* _data10_,
             GDBusInterface* iface)
{
	BluetoothObjectManager* self;
	self = _data10_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_object_manager_on_interface_removed (self, _data10_->object, iface);
}

static void
___lambda11__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda11_ (self, (GDBusInterface*) data);
}

static void
___lambda10_ (BluetoothObjectManager* self,
              GDBusObject* object)
{
	Block10Data* _data10_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data10_->object);
	_data10_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data10_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda11__gfunc, _data10_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
____lambda10__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                    GDBusObject* object,
                                                    gpointer self)
{
	___lambda10_ ((BluetoothObjectManager*) self, object);
}

static gboolean
bluetooth_object_manager_create_manager_co (BluetoothObjectManagerCreateManagerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.bluez", "/", _bluetooth_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, NULL, bluetooth_object_manager_create_manager_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->object_manager);
		_data_->self->priv->object_manager = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->object_manager;
		_data_->_tmp4_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		g_list_foreach (_data_->_tmp5_, ____lambda4__gfunc, _data_->self);
		(_data_->_tmp5_ == NULL) ? NULL : (_data_->_tmp5_ = (_g_list_free__g_object_unref0_ (_data_->_tmp5_), NULL));
		_data_->_tmp6_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp6_, "interface-added", (GCallback) _bluetooth_object_manager_on_interface_added_g_dbus_object_manager_interface_added, _data_->self, 0);
		_data_->_tmp7_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp7_, "interface-removed", (GCallback) _bluetooth_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp8_, "object-added", (GCallback) ____lambda8__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->_tmp9_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp9_, "object-removed", (GCallback) ____lambda10__g_dbus_object_manager_object_removed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_critical ("Manager.vala:53: Error getting Bluez object manager: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GType
bluetooth_object_manager_object_manager_proxy_get_type (BluetoothObjectManager* self,
                                                        GDBusObjectManagerClient* manager,
                                                        const gchar* object_path,
                                                        const gchar* interface_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (object_path != NULL, 0UL);
	if (interface_name == NULL) {
		result = g_dbus_object_proxy_get_type ();
		return result;
	}
	_tmp0_ = interface_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("org.bluez.Device1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_device_proxy_get_type ();
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("org.bluez.Adapter1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_adapter_proxy_get_type ();
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = g_dbus_proxy_get_type ();
				return result;
			}
		}
	}
}

static void
bluetooth_object_manager_register_obex_agentmanager (BluetoothObjectManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_variant_new ("(o)", "/org/bluez/obex/budgie", NULL);
		g_variant_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		g_dbus_connection_call (connection, "org.bluez.obex", "/org/bluez/obex", "org.bluez.obex.AgentManager1", "RegisterAgent", _tmp2_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL, NULL);
		_g_variant_unref0 (_tmp2_);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("Manager.vala:89: Error registering Obex agent manager: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda6_ (BluetoothObjectManager* self,
              GVariant* changed,
              gchar** invalid)
{
	GVariant* discovering = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp1_ = g_variant_lookup_value (changed, "Discovering", _tmp0_);
	discovering = _tmp1_;
	_tmp2_ = discovering;
	if (_tmp2_ != NULL) {
		g_signal_emit (self, bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_STATUS_DISCOVERING_SIGNAL], 0);
	}
	_g_variant_unref0 (discovering);
}

static void
_____lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	____lambda6_ ((BluetoothObjectManager*) self, changed_properties, invalidated_properties);
}

static void
bluetooth_object_manager_on_interface_added (BluetoothObjectManager* self,
                                             GDBusObject* object,
                                             GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_IS_DEVICE (iface)) {
		BluetoothDevice* device = NULL;
		BluetoothDevice* _tmp0_;
		device = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_TYPE_DEVICE, BluetoothDevice);
		_tmp0_ = device;
		g_signal_emit (self, bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL], 0, _tmp0_);
	} else {
		if (BLUETOOTH_IS_ADAPTER (iface)) {
			BluetoothAdapter* adapter = NULL;
			BluetoothAdapter* _tmp1_;
			adapter = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter);
			bluetooth_object_manager_set_has_object (self, TRUE);
			_tmp1_ = adapter;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _____lambda6__g_dbus_proxy_g_properties_changed, self, 0);
		}
	}
}

static void
bluetooth_object_manager_on_interface_removed (BluetoothObjectManager* self,
                                               GDBusObject* object,
                                               GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_IS_DEVICE (iface)) {
		g_signal_emit (self, bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_TYPE_DEVICE, BluetoothDevice));
	} else {
		if (BLUETOOTH_IS_ADAPTER (iface)) {
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp0_ = bluetooth_object_manager_get_adapters (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			bluetooth_object_manager_set_has_object (self, !_tmp3_);
			_g_object_unref0 (_tmp1_);
		}
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		BluetoothObjectManager* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->adapters);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda7_ (Block11Data* _data11_,
            GDBusObject* object)
{
	BluetoothObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data11_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Adapter1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data11_->adapters;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter));
	_g_object_unref0 (iface);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ (self, (GDBusObject*) data);
}

GeeLinkedList*
bluetooth_object_manager_get_adapters (BluetoothObjectManager* self)
{
	GDBusObjectManagerClient* _tmp0_;
	Block11Data* _data11_;
	GeeLinkedList* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_manager;
	_vala_return_val_if_fail (_tmp0_ != NULL, "object_manager != null", NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp1_ = gee_linked_list_new (BLUETOOTH_TYPE_ADAPTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data11_->adapters = _tmp1_;
	_tmp2_ = self->priv->object_manager;
	_tmp3_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_list_foreach (_tmp4_, ___lambda7__gfunc, _data11_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__g_object_unref0_ (_tmp4_), NULL));
	_tmp5_ = _data11_->adapters;
	_data11_->adapters = NULL;
	result = _tmp5_;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		BluetoothObjectManager* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->devices);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda12_ (Block12Data* _data12_,
             GDBusObject* object)
{
	BluetoothObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data12_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Device1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data12_->devices;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_TYPE_DEVICE, BluetoothDevice));
	_g_object_unref0 (iface);
}

static void
___lambda12__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda12_ (self, (GDBusObject*) data);
}

GeeCollection*
bluetooth_object_manager_get_devices (BluetoothObjectManager* self)
{
	GDBusObjectManagerClient* _tmp0_;
	Block12Data* _data12_;
	GeeLinkedList* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_manager;
	_vala_return_val_if_fail (_tmp0_ != NULL, "object_manager != null", NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp1_ = gee_linked_list_new (BLUETOOTH_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data12_->devices = _tmp1_;
	_tmp2_ = self->priv->object_manager;
	_tmp3_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_list_foreach (_tmp4_, ___lambda12__gfunc, _data12_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__g_object_unref0_ (_tmp4_), NULL));
	_tmp5_ = _data12_->devices;
	_data12_->devices = NULL;
	result = (GeeCollection*) _tmp5_;
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}

static void
bluetooth_object_manager_start_discovery_data_free (gpointer _data)
{
	BluetoothObjectManagerStartDiscoveryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothObjectManagerStartDiscoveryData, _data_);
}

void
bluetooth_object_manager_start_discovery (BluetoothObjectManager* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BluetoothObjectManagerStartDiscoveryData* _data_;
	BluetoothObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothObjectManagerStartDiscoveryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_object_manager_start_discovery_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_object_manager_start_discovery_co (_data_);
}

void
bluetooth_object_manager_start_discovery_finish (BluetoothObjectManager* self,
                                                 GAsyncResult* _res_)
{
	BluetoothObjectManagerStartDiscoveryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_object_manager_start_discovery_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	BluetoothObjectManagerStartDiscoveryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_object_manager_start_discovery_co (_data_);
}

static gboolean
bluetooth_object_manager_start_discovery_co (BluetoothObjectManagerStartDiscoveryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = bluetooth_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_adapter_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_adapter_size = _data_->_tmp4_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp5_ = _data_->_adapter_index;
			_data_->_tmp6_ = _data_->_adapter_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_adapter_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_adapter_index);
			_data_->adapter = (BluetoothAdapter*) _data_->_tmp8_;
			{
				_data_->_tmp9_ = _data_->adapter;
				bluetooth_adapter_set_discoverable (_data_->_tmp9_, TRUE);
				_data_->_tmp10_ = _data_->adapter;
				_data_->_state_ = 1;
				bluetooth_adapter_start_discovery (_data_->_tmp10_, bluetooth_object_manager_start_discovery_ready, _data_);
				return FALSE;
				_state_1:
				bluetooth_adapter_start_discovery_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp11_ = _data_->adapter;
				_data_->_tmp12_ = bluetooth_adapter_get_name (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_tmp15_ = _data_->e;
				_data_->_tmp16_ = _data_->_tmp15_->message;
				g_critical ("Manager.vala:151: Error starting discovery on Bluetooth adapter '%s': " \
"%s", _data_->_tmp14_, _data_->_tmp16_);
				_g_free0 (_data_->_tmp14_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->adapter);
				_g_object_unref0 (_data_->adapters);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->adapter);
		}
	}
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
bluetooth_object_manager_check_discovering (BluetoothObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bluetooth_object_manager_get_adapters (self);
	adapters = _tmp0_;
	{
		GeeLinkedList* _adapter_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _adapter_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _adapter_index = 0;
		_tmp1_ = adapters;
		_adapter_list = _tmp1_;
		_tmp2_ = _adapter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_adapter_size = _tmp4_;
		_adapter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BluetoothAdapter* adapter = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			BluetoothAdapter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_adapter_index = _adapter_index + 1;
			_tmp5_ = _adapter_index;
			_tmp6_ = _adapter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _adapter_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _adapter_index);
			adapter = (BluetoothAdapter*) _tmp8_;
			_tmp9_ = adapter;
			_tmp10_ = bluetooth_adapter_get_discovering (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				result = TRUE;
				_g_object_unref0 (adapter);
				_g_object_unref0 (adapters);
				return result;
			}
			_g_object_unref0 (adapter);
		}
	}
	result = FALSE;
	_g_object_unref0 (adapters);
	return result;
}

static void
bluetooth_object_manager_stop_discovery_data_free (gpointer _data)
{
	BluetoothObjectManagerStopDiscoveryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothObjectManagerStopDiscoveryData, _data_);
}

void
bluetooth_object_manager_stop_discovery (BluetoothObjectManager* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	BluetoothObjectManagerStopDiscoveryData* _data_;
	BluetoothObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothObjectManagerStopDiscoveryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_object_manager_stop_discovery_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_object_manager_stop_discovery_co (_data_);
}

void
bluetooth_object_manager_stop_discovery_finish (BluetoothObjectManager* self,
                                                GAsyncResult* _res_)
{
	BluetoothObjectManagerStopDiscoveryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_object_manager_stop_discovery_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	BluetoothObjectManagerStopDiscoveryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_object_manager_stop_discovery_co (_data_);
}

static gboolean
bluetooth_object_manager_stop_discovery_co (BluetoothObjectManagerStopDiscoveryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = bluetooth_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_adapter_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_adapter_size = _data_->_tmp4_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp5_ = _data_->_adapter_index;
			_data_->_tmp6_ = _data_->_adapter_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_adapter_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_adapter_index);
			_data_->adapter = (BluetoothAdapter*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->adapter;
			bluetooth_adapter_set_discoverable (_data_->_tmp9_, FALSE);
			{
				_data_->_tmp11_ = _data_->adapter;
				_data_->_tmp12_ = bluetooth_adapter_get_powered (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				if (_data_->_tmp13_) {
					_data_->_tmp14_ = _data_->adapter;
					_data_->_tmp15_ = bluetooth_adapter_get_discovering (_data_->_tmp14_);
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp10_ = _data_->_tmp16_;
				} else {
					_data_->_tmp10_ = FALSE;
				}
				if (_data_->_tmp10_) {
					_data_->_tmp17_ = _data_->adapter;
					_data_->_state_ = 1;
					bluetooth_adapter_stop_discovery (_data_->_tmp17_, bluetooth_object_manager_stop_discovery_ready, _data_);
					return FALSE;
					_state_1:
					bluetooth_adapter_stop_discovery_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp18_ = _data_->adapter;
				_data_->_tmp19_ = bluetooth_adapter_get_name (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = _data_->e;
				_data_->_tmp23_ = _data_->_tmp22_->message;
				g_critical ("Manager.vala:179: Error stopping discovery on Bluetooth adapter '%s': " \
"%s", _data_->_tmp21_, _data_->_tmp23_);
				_g_free0 (_data_->_tmp21_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->adapter);
				_g_object_unref0 (_data_->adapters);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->adapter);
		}
	}
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BluetoothAdapter*
bluetooth_object_manager_get_adapter_from_path (BluetoothObjectManager* self,
                                                const gchar* path)
{
	GDBusObject* object = NULL;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObject* _tmp1_;
	GDBusObject* _tmp2_;
	BluetoothAdapter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->object_manager;
	_tmp1_ = g_dbus_object_manager_get_object ((GDBusObjectManager*) _tmp0_, path);
	object = _tmp1_;
	_tmp2_ = object;
	if (_tmp2_ != NULL) {
		GDBusObject* _tmp3_;
		GDBusInterface* _tmp4_;
		_tmp3_ = object;
		_tmp4_ = g_dbus_object_get_interface (_tmp3_, "org.bluez.Adapter1");
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter);
		_g_object_unref0 (object);
		return result;
	}
	result = NULL;
	_g_object_unref0 (object);
	return result;
}

BluetoothDevice*
bluetooth_object_manager_get_device (BluetoothObjectManager* self,
                                     const gchar* address)
{
	GeeCollection* devices = NULL;
	GeeCollection* _tmp0_;
	BluetoothDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (address != NULL, NULL);
	_tmp0_ = bluetooth_object_manager_get_devices (self);
	devices = _tmp0_;
	{
		GeeIterator* _device_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = devices;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_device_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			BluetoothDevice* device = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			BluetoothDevice* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp3_ = _device_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _device_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			device = (BluetoothDevice*) _tmp5_;
			_tmp6_ = device;
			_tmp7_ = bluetooth_device_get_address (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, address) == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				result = device;
				_g_object_unref0 (_device_it);
				_g_object_unref0 (devices);
				return result;
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	result = NULL;
	_g_object_unref0 (devices);
	return result;
}

BluetoothObjectManager*
bluetooth_object_manager_construct (GType object_type)
{
	BluetoothObjectManager * self = NULL;
	self = (BluetoothObjectManager*) g_object_new (object_type, NULL);
	return self;
}

BluetoothObjectManager*
bluetooth_object_manager_new (void)
{
	return bluetooth_object_manager_construct (BLUETOOTH_TYPE_OBJECT_MANAGER);
}

gboolean
bluetooth_object_manager_get_has_object (BluetoothObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_object;
	return result;
}

static void
bluetooth_object_manager_set_has_object (BluetoothObjectManager* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_object_manager_get_has_object (self);
	if (old_value != value) {
		self->priv->_has_object = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_object_manager_properties[BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY]);
	}
}

static GObject *
bluetooth_object_manager_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothObjectManager * self;
	parent_class = G_OBJECT_CLASS (bluetooth_object_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager);
	bluetooth_object_manager_create_manager (self, NULL, NULL);
	bluetooth_object_manager_register_obex_agentmanager (self);
	return obj;
}

static void
bluetooth_object_manager_class_init (BluetoothObjectManagerClass * klass,
                                     gpointer klass_data)
{
	bluetooth_object_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothObjectManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_object_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_object_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_object_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_object_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY, bluetooth_object_manager_properties[BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY] = g_param_spec_boolean ("has-object", "has-object", "has-object", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", BLUETOOTH_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_TYPE_DEVICE);
	bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL] = g_signal_new ("device-removed", BLUETOOTH_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_TYPE_DEVICE);
	bluetooth_object_manager_signals[BLUETOOTH_OBJECT_MANAGER_STATUS_DISCOVERING_SIGNAL] = g_signal_new ("status-discovering", BLUETOOTH_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bluetooth_object_manager_instance_init (BluetoothObjectManager * self,
                                        gpointer klass)
{
	self->priv = bluetooth_object_manager_get_instance_private (self);
	self->priv->_has_object = FALSE;
}

static void
bluetooth_object_manager_finalize (GObject * obj)
{
	BluetoothObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager);
	_g_object_unref0 (self->priv->object_manager);
	G_OBJECT_CLASS (bluetooth_object_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
bluetooth_object_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothObjectManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_object_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothObjectManager), 0, (GInstanceInitFunc) bluetooth_object_manager_instance_init, NULL };
	GType bluetooth_object_manager_type_id;
	bluetooth_object_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BluetoothObjectManager", &g_define_type_info, 0);
	BluetoothObjectManager_private_offset = g_type_add_instance_private (bluetooth_object_manager_type_id, sizeof (BluetoothObjectManagerPrivate));
	return bluetooth_object_manager_type_id;
}

GType
bluetooth_object_manager_get_type (void)
{
	static volatile gsize bluetooth_object_manager_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_object_manager_type_id__once)) {
		GType bluetooth_object_manager_type_id;
		bluetooth_object_manager_type_id = bluetooth_object_manager_get_type_once ();
		g_once_init_leave (&bluetooth_object_manager_type_id__once, bluetooth_object_manager_type_id);
	}
	return bluetooth_object_manager_type_id__once;
}

static void
_vala_bluetooth_object_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	BluetoothObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager);
	switch (property_id) {
		case BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		g_value_set_boolean (value, bluetooth_object_manager_get_has_object (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_object_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	BluetoothObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager);
	switch (property_id) {
		case BLUETOOTH_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		bluetooth_object_manager_set_has_object (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

