/* Scrollbar.c generated by valac 0.56.17, the Vala compiler
 * generated from Scrollbar.vala, do not modify */

/*
Copyright (C) 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SCROLLBAR_0_PROPERTY,
	BIRD_FONT_SCROLLBAR_NUM_PROPERTIES
};
static GParamSpec* bird_font_scrollbar_properties[BIRD_FONT_SCROLLBAR_NUM_PROPERTIES];

static gpointer bird_font_scrollbar_parent_class = NULL;

static void bird_font_scrollbar_finalize (GObject * obj);
static GType bird_font_scrollbar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BirdFontScrollbar*
bird_font_scrollbar_construct (GType object_type)
{
	BirdFontScrollbar * self = NULL;
	self = (BirdFontScrollbar*) g_object_new (object_type, NULL);
	return self;
}

BirdFontScrollbar*
bird_font_scrollbar_new (void)
{
	return bird_font_scrollbar_construct (BIRD_FONT_TYPE_SCROLLBAR);
}

gboolean
bird_font_scrollbar_button_press (BirdFontScrollbar* self,
                                  guint button,
                                  gdouble x,
                                  gdouble y)
{
	gdouble h = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean _tmp3_ = FALSE;
	gdouble _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!bird_font_scrollbar_is_visible (self)) {
		result = FALSE;
		return result;
	}
	h = (self->height * self->position) * self->scroll_max;
	_tmp1_ = x;
	if ((self->left_x < _tmp1_) && (_tmp1_ < (self->left_x + self->width))) {
		gdouble _tmp2_;
		_tmp2_ = y;
		_tmp0_ = ((h - self->corner) < _tmp2_) && (_tmp2_ < (((h + (self->height * self->size)) + self->corner) + (2 * self->margin)));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->motion_x = x;
		self->motion_y = y;
		self->move = TRUE;
	}
	_tmp4_ = x;
	if ((self->left_x < _tmp4_) && (_tmp4_ < (self->left_x + self->width))) {
		gdouble _tmp5_;
		_tmp5_ = self->size;
		_tmp3_ = (((gdouble) 0) < _tmp5_) && (_tmp5_ < ((gdouble) 1));
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

gboolean
bird_font_scrollbar_button_release (BirdFontScrollbar* self,
                                    guint button,
                                    gdouble x,
                                    gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!bird_font_scrollbar_is_visible (self)) {
		result = FALSE;
		return result;
	}
	if (self->move) {
		self->move = FALSE;
		result = TRUE;
		return result;
	} else {
		gdouble _tmp0_;
		_tmp0_ = x;
		if ((self->left_x < _tmp0_) && (_tmp0_ < (self->left_x + self->width))) {
			gdouble h = 0.0;
			h = (self->height * self->position) * self->scroll_max;
			if (y > (h + (self->size * self->height))) {
				self->position = self->position + self->size;
			}
			if (y < h) {
				self->position = self->position - self->size;
			}
			if (self->position > ((gdouble) 1)) {
				self->position = (gdouble) 1;
			} else {
				if (self->position < ((gdouble) 0)) {
					self->position = (gdouble) 0;
				}
			}
			bird_font_tab_content_scroll_to (self->position);
			bird_font_glyph_canvas_redraw ();
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
bird_font_scrollbar_motion (BirdFontScrollbar* self,
                            gdouble x,
                            gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gdouble p = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->move) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !bird_font_scrollbar_is_visible (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	p = (y - self->motion_y) / (self->height - (self->size * self->height));
	self->position = self->position + p;
	if (self->position > ((gdouble) 1)) {
		self->position = (gdouble) 1;
	} else {
		if (self->position < ((gdouble) 0)) {
			self->position = (gdouble) 0;
		}
	}
	bird_font_tab_content_scroll_to (self->position);
	bird_font_glyph_canvas_redraw ();
	self->motion_y = y;
	self->motion_x = x;
	result = FALSE;
	return result;
}

void
bird_font_scrollbar_draw (BirdFontScrollbar* self,
                          cairo_t* cr,
                          BirdFontWidgetAllocation* content_allocation,
                          gdouble width)
{
	gdouble h = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (content_allocation != NULL);
	if (!bird_font_scrollbar_is_visible (self)) {
		return;
	}
	cairo_save (cr);
	self->width = width;
	self->left_x = (gdouble) content_allocation->width;
	self->height = (gdouble) content_allocation->height;
	self->corner = 4 * bird_font_screen_get_scale ();
	self->scroll_max = (1 - self->size) - ((2 * self->corner) / self->height);
	self->margin = 2 * bird_font_screen_get_scale ();
	bird_font_theme_color (cr, "Table Background 1");
	cairo_rectangle (cr, self->left_x, (gdouble) 0, width, self->height);
	cairo_fill (cr);
	bird_font_theme_color (cr, "Tool Foreground");
	h = (self->height * self->position) * self->scroll_max;
	bird_font_widget_draw_rounded_rectangle (cr, self->left_x + self->margin, h, width - (2 * self->margin), (self->height * self->size) + (2 * self->margin), self->corner);
	cairo_fill (cr);
	cairo_restore (cr);
}

gboolean
bird_font_scrollbar_is_visible (BirdFontScrollbar* self)
{
	gdouble _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->size;
	result = (((gdouble) 0) < _tmp0_) && (_tmp0_ < ((gdouble) 1));
	return result;
}

void
bird_font_scrollbar_set_size (BirdFontScrollbar* self,
                              gdouble size)
{
	g_return_if_fail (self != NULL);
	self->size = size;
}

void
bird_font_scrollbar_set_position (BirdFontScrollbar* self,
                                  gdouble position)
{
	g_return_if_fail (self != NULL);
	self->position = position;
}

static void
bird_font_scrollbar_class_init (BirdFontScrollbarClass * klass,
                                gpointer klass_data)
{
	bird_font_scrollbar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_scrollbar_finalize;
}

static void
bird_font_scrollbar_instance_init (BirdFontScrollbar * self,
                                   gpointer klass)
{
	self->position = (gdouble) 1;
	self->size = (gdouble) 1;
	self->width = (gdouble) 0;
	self->left_x = (gdouble) 0;
	self->height = (gdouble) 0;
	self->corner = (gdouble) 0;
	self->scroll_max = (gdouble) 1;
	self->margin = (gdouble) 0;
	self->motion_x = (gdouble) 0;
	self->motion_y = (gdouble) 0;
	self->move = FALSE;
}

static void
bird_font_scrollbar_finalize (GObject * obj)
{
	BirdFontScrollbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SCROLLBAR, BirdFontScrollbar);
	G_OBJECT_CLASS (bird_font_scrollbar_parent_class)->finalize (obj);
}

static GType
bird_font_scrollbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontScrollbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_scrollbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontScrollbar), 0, (GInstanceInitFunc) bird_font_scrollbar_instance_init, NULL };
	GType bird_font_scrollbar_type_id;
	bird_font_scrollbar_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontScrollbar", &g_define_type_info, 0);
	return bird_font_scrollbar_type_id;
}

GType
bird_font_scrollbar_get_type (void)
{
	static volatile gsize bird_font_scrollbar_type_id__once = 0;
	if (g_once_init_enter (&bird_font_scrollbar_type_id__once)) {
		GType bird_font_scrollbar_type_id;
		bird_font_scrollbar_type_id = bird_font_scrollbar_get_type_once ();
		g_once_init_leave (&bird_font_scrollbar_type_id__once, bird_font_scrollbar_type_id);
	}
	return bird_font_scrollbar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

