/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPanel;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PDFPagePanel
extends JPanel {
    private static final long serialVersionUID = -4629033339560890669L;
    private PDPage page;
    private PageDrawer drawer = new PageDrawer();
    private Dimension pageDimension = null;
    private Dimension drawDimension = null;

    public void setPage(PDPage pdfPage) {
        this.page = pdfPage;
        PDRectangle cropBox = this.page.findCropBox();
        this.drawDimension = cropBox.createDimension();
        this.pageDimension = this.page.findRotation() % 180 == 0 ? this.drawDimension : new Dimension(this.drawDimension.height, this.drawDimension.width);
        this.setSize(this.pageDimension);
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        try {
            int rotationAngle;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (rotationAngle = this.page.findRotation(); rotationAngle < 0; rotationAngle += 360) {
            }
            while (rotationAngle >= 360) {
                rotationAngle -= 360;
            }
            if (rotationAngle != 0) {
                Graphics2D g2D = (Graphics2D)g;
                double translateX = 0.0;
                double translateY = 0.0;
                switch (rotationAngle) {
                    case 90: {
                        translateX = this.pageDimension.getWidth();
                        break;
                    }
                    case 270: {
                        translateY = this.pageDimension.getHeight();
                        break;
                    }
                    case 180: {
                        translateX = this.pageDimension.getWidth();
                        translateY = this.pageDimension.getHeight();
                    }
                }
                g2D.translate(translateX, translateY);
                g2D.rotate(Math.toRadians(rotationAngle));
            }
            this.drawer.drawPage(g, this.page, this.drawDimension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

