/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.Paragraph;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class HangIndent
extends Primitive
implements Expandable,
InternalQuantity {
    public HangIndent() {
        this("hangindent");
    }

    public HangIndent(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new HangIndent(this.getName());
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXDimension teXDimension = teXParser.getSettings().getCurrentHangIndent();
        if (teXDimension == null) {
            return new UserDimension();
        }
        return teXDimension;
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
        if (!(teXObject instanceof TeXDimension)) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", new Object[0]);
        }
        teXParser.getSettings().setHangIndent((TeXDimension)teXObject);
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.popModifier(teXParser, teXObjectList, 61);
        TeXDimension teXDimension = teXObjectList.popDimension(teXParser);
        teXParser.getSettings().setHangIndent(teXDimension);
        Paragraph paragraph = teXParser.getListener().createParagraph();
        paragraph.setLeftMargin(teXDimension);
        paragraph.build(teXParser, teXObjectList);
        teXParser.getSettings().setHangIndent(null);
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add(paragraph);
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        this.popModifier(teXParser, teXParser, 61);
        TeXDimension teXDimension = teXParser.popDimension();
        teXParser.getSettings().setHangIndent(teXDimension);
        Paragraph paragraph = teXParser.getListener().createParagraph();
        paragraph.setLeftMargin(teXDimension);
        paragraph.build(teXParser, teXParser);
        teXParser.getSettings().setHangIndent(null);
        TeXObjectList teXObjectList = teXParser.getListener().createStack();
        teXObjectList.add(paragraph);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.popModifier(teXParser, teXObjectList, 61);
        TeXDimension teXDimension = teXObjectList.popDimension(teXParser);
        teXParser.getSettings().setHangIndent(teXDimension);
        Paragraph paragraph = teXParser.getListener().createParagraph();
        paragraph.setLeftMargin(teXDimension);
        paragraph.build(teXParser, teXObjectList);
        teXParser.getSettings().setHangIndent(null);
        teXObjectList.push(paragraph);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.popModifier(teXParser, teXParser, 61);
        TeXDimension teXDimension = teXParser.popDimension();
        teXParser.getSettings().setHangIndent(teXDimension);
        Paragraph paragraph = teXParser.getListener().createParagraph();
        paragraph.setLeftMargin(teXDimension);
        paragraph.build(teXParser, teXParser);
        teXParser.getSettings().setHangIndent(null);
        teXParser.push(paragraph);
    }
}

