/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.model.ACESccTransferFunctions;
import com.github.ajalt.colormath.model.ACEScctTransferFunctions;
import com.github.ajalt.colormath.model.BT2020TransferFunctions;
import com.github.ajalt.colormath.model.BT709TransferFunctions;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaceImpl;
import com.github.ajalt.colormath.model.RGBColorSpacesKt;
import com.github.ajalt.colormath.model.ROMMTransferFunctions;
import com.github.ajalt.colormath.model.SRGBTransferFunctions;
import com.github.ajalt.colormath.model.xyY;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpaces;", "", "<init>", "()V", "SRGB", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "getSRGB", "()Lcom/github/ajalt/colormath/model/RGBColorSpace;", "LinearSRGB", "getLinearSRGB", "ACES", "getACES", "ACEScc", "getACEScc", "ACEScct", "getACEScct", "ACEScg", "getACEScg", "AdobeRGB", "getAdobeRGB", "BT2020", "getBT2020", "BT709", "getBT709", "DCI_P3", "getDCI_P3", "DisplayP3", "getDisplayP3", "ROMM_RGB", "getROMM_RGB", "colormath"})
public final class RGBColorSpaces {
    @NotNull
    public static final RGBColorSpaces INSTANCE = new RGBColorSpaces();
    @NotNull
    private static final RGBColorSpace SRGB = new RGBColorSpaceImpl("sRGB", Illuminant.INSTANCE.getD65(), SRGBTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getSRGB_R$p(), RGBColorSpacesKt.access$getSRGB_G$p(), RGBColorSpacesKt.access$getSRGB_B$p(), RGBColorSpaces::SRGB$lambda$0);
    @NotNull
    private static final RGBColorSpace LinearSRGB = RGBColorSpacesKt.RGBColorSpace("Linear sRGB", Illuminant.INSTANCE.getD65(), RGBColorSpace.LinearTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getSRGB_R$p(), RGBColorSpacesKt.access$getSRGB_G$p(), RGBColorSpacesKt.access$getSRGB_B$p());
    @NotNull
    private static final RGBColorSpace ACES = RGBColorSpacesKt.RGBColorSpace("ACES2065-1", RGBColorSpacesKt.access$getACES_WHITE_POINT$p(), RGBColorSpace.LinearTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getACES_AP0_R$p(), RGBColorSpacesKt.access$getACES_AP0_G$p(), RGBColorSpacesKt.access$getACES_AP0_B$p());
    @NotNull
    private static final RGBColorSpace ACEScc = RGBColorSpacesKt.RGBColorSpace("ACEScc", RGBColorSpacesKt.access$getACES_WHITE_POINT$p(), ACESccTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getACES_AP1_R$p(), RGBColorSpacesKt.access$getACES_AP1_G$p(), RGBColorSpacesKt.access$getACES_AP1_B$p());
    @NotNull
    private static final RGBColorSpace ACEScct = RGBColorSpacesKt.RGBColorSpace("ACEScct", RGBColorSpacesKt.access$getACES_WHITE_POINT$p(), ACEScctTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getACES_AP1_R$p(), RGBColorSpacesKt.access$getACES_AP1_G$p(), RGBColorSpacesKt.access$getACES_AP1_B$p());
    @NotNull
    private static final RGBColorSpace ACEScg = RGBColorSpacesKt.RGBColorSpace("ACEScg", RGBColorSpacesKt.access$getACES_WHITE_POINT$p(), RGBColorSpace.LinearTransferFunctions.INSTANCE, RGBColorSpacesKt.access$getACES_AP1_R$p(), RGBColorSpacesKt.access$getACES_AP1_G$p(), RGBColorSpacesKt.access$getACES_AP1_B$p());
    @NotNull
    private static final RGBColorSpace AdobeRGB = RGBColorSpacesKt.RGBColorSpace("Adobe RGB", Illuminant.INSTANCE.getD65(), new RGBColorSpace.GammaTransferFunctions(2.19921875), new xyY(0.64, 0.33, null, 4, null), new xyY(0.21, 0.71, null, 4, null), new xyY(0.15, 0.06, null, 4, null));
    @NotNull
    private static final RGBColorSpace BT2020 = new RGBColorSpaceImpl("BT.2020", Illuminant.INSTANCE.getD65(), BT2020TransferFunctions.INSTANCE, new xyY(0.708, 0.292, null, 4, null), new xyY(0.17, 0.797, null, 4, null), new xyY(0.131, 0.046, null, 4, null), RGBColorSpaces::BT2020$lambda$1);
    @NotNull
    private static final RGBColorSpace BT709 = RGBColorSpacesKt.RGBColorSpace("BT.709", Illuminant.INSTANCE.getD65(), BT709TransferFunctions.INSTANCE, new xyY(0.64, 0.33, null, 4, null), new xyY(0.3, 0.6, null, 4, null), new xyY(0.15, 0.06, null, 4, null));
    @NotNull
    private static final RGBColorSpace DCI_P3 = RGBColorSpacesKt.RGBColorSpace("DCI P3", new WhitePoint("DCI P3", new xyY(0.314, 0.351, null, 4, null)), new RGBColorSpace.GammaTransferFunctions(2.6), new xyY(0.68, 0.32, null, 4, null), new xyY(0.265, 0.69, null, 4, null), new xyY(0.15, 0.06, null, 4, null));
    @NotNull
    private static final RGBColorSpace DisplayP3 = RGBColorSpacesKt.RGBColorSpace("Display P3", Illuminant.INSTANCE.getD65(), SRGBTransferFunctions.INSTANCE, new xyY(0.68, 0.32, null, 4, null), new xyY(0.265, 0.69, null, 4, null), new xyY(0.15, 0.06, null, 4, null));
    @NotNull
    private static final RGBColorSpace ROMM_RGB = RGBColorSpacesKt.RGBColorSpace("ROMM RGB", Illuminant.INSTANCE.getD50(), ROMMTransferFunctions.INSTANCE, new xyY(0.7347, 0.2653, null, 4, null), new xyY(0.1596, 0.8404, null, 4, null), new xyY(0.0366, 1.0E-4, null, 4, null));

    private RGBColorSpaces() {
    }

    @NotNull
    public final RGBColorSpace getSRGB() {
        return SRGB;
    }

    @NotNull
    public final RGBColorSpace getLinearSRGB() {
        return LinearSRGB;
    }

    @NotNull
    public final RGBColorSpace getACES() {
        return ACES;
    }

    @NotNull
    public final RGBColorSpace getACEScc() {
        return ACEScc;
    }

    @NotNull
    public final RGBColorSpace getACEScct() {
        return ACEScct;
    }

    @NotNull
    public final RGBColorSpace getACEScg() {
        return ACEScg;
    }

    @NotNull
    public final RGBColorSpace getAdobeRGB() {
        return AdobeRGB;
    }

    @NotNull
    public final RGBColorSpace getBT2020() {
        return BT2020;
    }

    @NotNull
    public final RGBColorSpace getBT709() {
        return BT709;
    }

    @NotNull
    public final RGBColorSpace getDCI_P3() {
        return DCI_P3;
    }

    @NotNull
    public final RGBColorSpace getDisplayP3() {
        return DisplayP3;
    }

    @NotNull
    public final RGBColorSpace getROMM_RGB() {
        return ROMM_RGB;
    }

    private static final RGB SRGB$lambda$0(RGBColorSpaceImpl $this$RGBColorSpaceImpl, Color it) {
        Intrinsics.checkNotNullParameter($this$RGBColorSpaceImpl, "$this$RGBColorSpaceImpl");
        Intrinsics.checkNotNullParameter(it, "it");
        return it.toSRGB();
    }

    private static final RGB BT2020$lambda$1(RGBColorSpaceImpl $this$RGBColorSpaceImpl, Color color) {
        Intrinsics.checkNotNullParameter($this$RGBColorSpaceImpl, "$this$RGBColorSpaceImpl");
        Intrinsics.checkNotNullParameter(color, "color");
        Color color2 = color;
        return color2 instanceof RGB ? ((RGB)color).convertTo($this$RGBColorSpaceImpl) : (color2 instanceof ICtCp ? ((ICtCp)color).toBT2020() : color.toXYZ().toRGB($this$RGBColorSpaceImpl));
    }
}

