const JWN_Code : array [128..255] of byte =
(065, 066,
 086, 071, 068, 069, 017, 090, 073, 018, 075, 076,
 077, 078, 079, 080, 082, 083, 084, 085, 070, 072,
 067, 081, 088, 087, 095, 089, 094, 003, 016, 023,
 097, 098, 118, 103, 100, 101, 025, 122, 105, 026,
 107, 108, 109, 110, 111, 112, 0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 0,   0,   0,   0,   114, 115, 116, 117, 102, 104,
 099, 113, 120, 119, 127, 121, 126, 011, 024, 031,
 019, 027, 125, 060, 062, 0,   0,   0,   0,   0,
 0,   0,   0,   0,   0,   0);

(**********************************************************************
 Alternative Coding           WNCyr Coding
-------- Big Letters --------------------------------------------------
CYR_A           := 128;   CYR_A           := oct"101";   065
CYR_BE          := 129;   CYR_BE          := oct"102";   066
CYR_VE          := 130;   CYR_VE          := oct"126";   086
CYR_GHE         := 131;   CYR_GHE         := oct"107";   071
CYR_DE          := 132;   CYR_DE          := oct"104";   068
CYR_E           := 133;   CYR_E           := oct"105";   069
CYR_YO          := 240;   CYR_YO          := oct"023";   019
CYR_ZHE         := 134;   CYR_ZHE         := oct"021";   017
CYR_ZE          := 135;   CYR_ZE          := oct"132";   090
CYR_I           := 136;   CYR_I           := oct"111";   073
CYR_SHORT_I     := 137;   CYR_SHORT_I     := oct"022";   018
CYR_KA          := 138;   CYR_KA          := oct"113";   075
CYR_EL          := 139;   CYR_EL          := oct"114";   076
CYR_EM          := 140;   CYR_EM          := oct"115";   077
CYR_EN          := 141;   CYR_EN          := oct"116";   078
CYR_O           := 142;   CYR_O           := oct"117";   079
CYR_PE          := 143;   CYR_PE          := oct"120";   080
CYR_ER          := 144;   CYR_ER          := oct"122";   082
CYR_ES          := 145;   CYR_ES          := oct"123";   083
CYR_TE          := 146;   CYR_TE          := oct"124";   084
CYR_U           := 147;   CYR_U           := oct"125";   085
CYR_EF          := 148;   CYR_EF          := oct"106";   070
CYR_KHA         := 149;   CYR_KHA         := oct"110";   072
CYR_TSE         := 150;   CYR_TSE         := oct"103";   067
CYR_CHE         := 151;   CYR_CHE         := oct"121";   081
CYR_SHA         := 152;   CYR_SHA         := oct"130";   088
CYR_SHCHA       := 153;   CYR_SHCHA       := oct"127";   087
CYR_HARD_SIGN   := 154;   CYR_HARD_SIGN   := oct"137";   095
CYR_ERY         := 155;   CYR_ERY         := oct"131";   089
CYR_SOFT_SIGN   := 156;   CYR_SOFT_SIGN   := oct"136";   094
CYR_REV_E       := 157;   CYR_REV_E       := oct"003";   003
CYR_YU          := 158;   CYR_YU          := oct"020";   016
CYR_YA          := 159;   CYR_YA          := oct"027";   023
----- Small Letters ---------------------------------------------------
CYR_a           := 160;   CYR_a           := oct"141";   097
CYR_be          := 161;   CYR_be          := oct"142";   098
CYR_ve          := 162;   CYR_ve          := oct"166";   118
CYR_ghe         := 163;   CYR_ghe         := oct"147";   103
CYR_de          := 164;   CYR_de          := oct"144";   100
CYR_e           := 165;   CYR_e           := oct"145";   101
CYR_yo          := 241;   CYR_yo          := oct"033";   027
CYR_zhe         := 166;   CYR_zhe         := oct"031";   025
CYR_ze          := 167;   CYR_ze          := oct"172";   122
CYR_i           := 168;   CYR_i           := oct"151";   105
CYR_short_i     := 169;   CYR_short_i     := oct"032";   026
CYR_ka          := 170;   CYR_ka          := oct"153";   107
CYR_el          := 171;   CYR_el          := oct"154";   108
CYR_em          := 172;   CYR_em          := oct"155";   109
CYR_en          := 173;   CYR_en          := oct"156";   110
CYR_o           := 174;   CYR_o           := oct"157";   111
CYR_pe          := 175;   CYR_pe          := oct"160";   112
CYR_er          := 224;   CYR_er          := oct"162";   114
CYR_es          := 225;   CYR_es          := oct"163";   115
CYR_te          := 226;   CYR_te          := oct"164";   116
CYR_u           := 227;   CYR_u           := oct"165";   117
CYR_ef          := 228;   CYR_ef          := oct"146";   102
CYR_kha         := 229;   CYR_kha         := oct"150";   104
CYR_tse         := 230;   CYR_tse         := oct"143";   099
CYR_che         := 231;   CYR_che         := oct"161";   113
CYR_sha         := 232;   CYR_sha         := oct"170";   120
CYR_shcha       := 233;   CYR_shcha       := oct"167";   119
CYR_hard_sign   := 234;   CYR_hard_sign   := oct"177";   127
CYR_ery         := 235;   CYR_ery         := oct"171";   121
CYR_soft_sign   := 236;   CYR_soft_sign   := oct"176";   126
CYR_rev_e       := 237;   CYR_rev_e       := oct"013";   011
CYR_yu          := 238;   CYR_yu          := oct"030";   024
CYR_ya          := 239;   CYR_ya          := oct"037";   031
--------- Punctuation -------------------------------------------------
CYR_No          := 242;   CYR_No          := oct"175";   125
CYR_open_quote  := 243;   CYR_open_quote  := oct"074";   060
CYR_close_quote := 244;   CYR_close_quote := oct"076";   062
----------Serb --------------------------------------------------------
                          CYR_SERB_SOFT_N := oct"000";  000
                          CYR_SERB_SOFT_L := oct"001";  001
                          CYR_SERB_HARD_DJ:= oct"002";  002
                          CYR_UKR_E       := oct"005";  005
                          CYR_OLD_IZHITSA := oct"024";  020
                          CYR_OLD_FITA    := oct"025";  021
                          CYR_MAC_ZELO    := oct"026";  022
                          CYR_UKR_HARD_G  := oct"225";  149
                          CYR_A_MODIFIED  := oct"255";  173
                          CYR_BUL_YUS     := oct"322";  210
                          CYR_SERB_soft_n := oct"010";  008
                          CYR_SERB_soft_l := oct"011";  009
                          CYR_SERB_hard_dj:= oct"012";  010
                          CYR_UKR_e       := oct"015";  013
                          CYR_OLD_izhitsa := oct"034";  028
                          CYR_OLD_fita    := oct"035";  029
                          CYR_MAC_zelo    := oct"036";  030
                          CYR_UKR_hard_g  := oct"235";  157
                          CYR_a_modified  := oct"265";  181
                          CYR_BUL_yus     := oct"332";  218
--------Serbspu--------------------------------------------------------
                          CYR_UKR_I       := oct"004";  004
                          CYR_SERB_SOFT_DJ:= oct"006";  006
                          CYR_SERB_SOFT_T := oct"007";  007
                          CYR_OLD_YATZ    := oct"043";  035
--------Cyrpunc--------------------------------------------------------
                          CYR_ACC_umlaut  := oct"040";  032
                          CYR_breve       := oct"044";  036
                          CYR_ACC_acute   := oct"046";  038
                          CYR_ACC_breve   := oct"100";  064
-------Cyrspl----------------------------------------------------------
                          CYR_UKR_i       := oct"014";  012
                          CYR_SERB_soft_dj:= oct"016";  014
                          CYR_SERB_soft_t := oct"017";  015
                          CYR_OLD_yatz    := oct"053";  043
                          CYR_dotless_i   := oct"075";  061
------ the addition of another form of letters ------------------------
------ cyr_ de, zhe, ka, el, ya ---------------------------------------
                          CYR_BEET_ZHE    := oct"021";  017
                          CYR_BEET_zhe    := oct"031";  025
                          CYR_BEET_KA     := oct"113";  075
                          CYR_BEET_ka     := oct"153";  107
                          CYR_BEET_YA     := oct"027";  023
                          CYR_BEET_ya     := oct"037";  031
-----------------------------------------------------------------------
***********************************************************************)

function IfFontExist(ss : string; font : integer;
                     flerror : boolean) : boolean;
var fl : boolean;
begin
     fl:=true;
     if (font < 0) or (font > MaxFontNumber) then
     begin
         fl:=false;
         if flerror then
         begin
              ErrorLog('*** Error : '+ss+' D '+ConvDecLongInt(font)
                        + 'is outside range !');
              FlagError:=true; FlagSevere:=true;
         end
         else begin
              ErrorLog('*** Warning : '+ss+' D '+ConvDecLongInt(font)
                        + 'is outside range !');
         end;
     end
     else if (not FontsParm^[font].FlagFontUsed) then
     begin
          fl:=false;
          if flerror then
          begin
               ErrorLog('*** Error : '+ss+' D '+ConvDecLongInt(font)
                              + 'is not defined !');
               FlagError:=true; FlagSevere:=true;
          end
          else begin
               ErrorLog('*** Warning : '+ss+' D '+ConvDecLongInt(font)
                              + 'is not defined !');
          end;
     end;
     IfFontExist:=fl;
end; {IfFontExist}

procedure CheckTable;
var i, j         : integer;
    ptrD, ptrH   : ptrDiscardChar;
    ptrDD        : ptrDVIRecord;
    FLig         : ptrLigRecord;
    nc, nf, nff  : integer;
    fl           : boolean;
begin

  {--- check that all fonts are defined ---}
  for i:=0 to 255 do
  with CharDataGlb^[i] do
  begin

      if (marked in [CharUsed, CharDVI]) and (FlTFMData)
      then begin
            fl:=IfFontExist('CHARACTER/TFMFONT',sizefont,true);
      end;

      case marked of
      CharUsed : begin
            fl:=IfFontExist('CHARACTER/FONT',mapfont,true);
      end;
      CharDVI  : begin
              if (DefMapfont or DefMapchar)
                 then fl:=IfFontExist('CHARACTER/FONT',mapfont,true);
              ptrDD:=ptrDVI;
              while ptrDD <> nil do
              begin
                   if (ptrDD^.TDVI = DVIFont) then
                   begin
                      fl:=IfFontExist('CHARACTER/SETDVI/FONT',ptrDD^.nfont,true);
                      if not fl then
                      begin
                           ptrDD^.cwidth:=0.0;
                           ptrDD^.cheight:=0.0;
                           ptrDD^.cdepth:=0.0;
                      end;
                   end;
                   ptrDD:=ptrDD^.ptrNext;
              end;
      end;
      end; {case}
  end; {for i}

  ptrD:=ptrDiscCharGlb;
  while ptrD <> nil do
  begin
       fl:=IfFontExist('DISCARD/FONT',ptrD^.fontnum,false);
       ptrD:=ptrD^.ptrNext;
  end;

  {--- check that there are no mapping to discarded characters ---}
  ptrH:=nil;
  ptrD:=ptrDiscCharGlb;
  while ptrD <> nil do
  begin
        nc:=ptrD^.charnum;
        nf:=ptrD^.fontnum;

        fl:=false;
        for i:=0 to 255 do
        with CharDataGlb^[i] do
        begin
            case marked of
            CharUsed : begin
                          if (nc = mapchar) and (nf = mapfont) then
                          begin
                              fl:=true;
                          end;
                      end;
            CharDVI  : begin
                         nff:=0;
                         ptrDD:=ptrDVI;
                         while ptrDD <> nil do
                         begin
                            case ptrDD^.TDVI of
                            DVIFont : nff:=ptrDD^.nfont;
                            DVIChar : if (nf = nff)
                                          and (nc = ptrDD^.nchar)
                              then begin
                                   fl:=true;
                              end;
                            end; {case}
                            ptrDD:=ptrDD^.ptrNext;
                         end; {while}
                       end;
            end; {case}
        end; {for i}

        if fl then
        begin
            ErrorLog('*** Error : character '+ConvChar(nc)+' from font D '+ConvInt(nf));
            ErrorLog('            is used in [CHARACTER] list and [DISCARD]');
            ErrorLog('            list of the mapping table simultaneously.');
            ErrorLog('            DISCARD declaration is ignored.');

            if ptrH = nil then ptrDiscCharGlb:=ptrD^.ptrNext
                          else ptrH^.ptrNext:=ptrD^.ptrNext;
            dispose(ptrD);
            if ptrH = nil then ptrD:=ptrDiscCharGlb
                          else ptrD:=ptrH^.ptrNext;
       end
       else begin
            ptrH:=ptrD;
            ptrD:=ptrD^.ptrNext;
       end;
 end;

 {--- check that commands
            setchar/selectfont/sizechar/sizefont
      are explicit ---}
 {--- mark fonts which are necessary for MAPFONT in *.VPL ---}

  for i:=0 to 255 do
  with CharDataGlb^[i] do
  if marked in [CharUsed, CharDVI] then
  begin
         defined:=true;

         if FlTFMData then
         begin
              if not DefSizechar then
              begin
                   ErrorLog('*** Warning : SIZECHAR is not specified for character '+ConvChar(i));
                   ErrorLog('              The specification SETCHAR '+ConvChar(sizechar)+' is used');
              end;

              if not DefSizefont then
              begin
                   ErrorLog('*** Warning : SIZEFONT is not specified for character '+ConvChar(i));
                   ErrorLog('              The specification SELECTFONT D '+ConvInt(sizefont)+' is used');
              end;
         end;

         if (marked = CharUsed) or
            ((marked = CharDVI) and (DefMapfont or DefMapchar))
         then begin
              if not DefMapchar then
              begin
                   ErrorLog('*** Warning : SETCHAR is not specified for character '+ConvChar(i));
                   ErrorLog('              The specification SETCHAR '+ConvChar(mapchar)+' is used');
              end;

             if not DefMapfont then
             begin
                  ErrorLog('*** Warning : SELECTFONT is not specified for character '+ConvChar(i));
                  ErrorLog('              The specification SELECTFONT D '+ConvInt(mapfont)+' is used');
            end;

            if (mapfont <= MaxFontNumber)
               and (mapfont >= 0) and (marked = CharUsed)
            then FontsParm^[mapfont].FlagFontInclude:=true;
         end;

         if marked = CharDVI then
         begin
              ptrDD:=ptrDVI; nff:=-1;
              while ptrDD <> nil do
              begin
                   case ptrDD^.TDVI of
                   DVIFont : begin
                                 nff:=ptrDD^.nfont;
                             end;
                   DVIChar : begin
                                 if nff < 0 then
                                 begin
                                      ErrorLog('*** Error : No SELECTFONT before first SETCHAR from DVI list');
                                      LogReadState;
                                      FlagError:=true;
                                 end;

                                 if (nff <= MaxFontNumber) and (nff >= 0)
                                    then FontsParm^[nff].FlagFontInclude:=true;
                             end;
                   end; {case}
                   ptrDD:=ptrDD^.ptrNext;
              end; {while}
         end;

   end; {for i}

   {--- check that there are no cycles in VARCHAR/NEXTLARGER ---}
   FLig:=nil;
   CheckFont(VParamGlb, FontDimenGlb, CharDataGlb^, FLig);

end; {CheckTable}


procedure FixCheck1(var ptrL : ptrLigRecord;
                    s : string;
                    ichar : byte;
                    jj : integer);
begin
    ptrL^.marked:=LigDiscard;
    ErrorLog('*** Error : LIGTABLE [input] contains the record '+s);
    ErrorLog('               with the absent character '+ConvChar(ichar));
    ErrorLog('            LIGTABLE record '+ConvInt(jj)+' is ignored.');
end; {FixCheck1}


procedure CheckLigTableTable(flfirst : boolean);
var ptrL : ptrLigRecord;
    jj         : integer;
begin

   {--- mark as 'discard' not used records from Table LigTable ---}
   ptrL:=ptrLigTable; jj:=0;

   while ptrL <> nil do
   with ptrL^ do
   begin
      if marked <> LigDiscard then
      begin
           jj:=jj+1;
           if flfirst then marked:=LigUsed;

           if marked in [LigUsed, LigUsedBound, LigAdded] then
           case TTLig of

           TLabel : begin
                 if not (CharDataGlb^[LigChar].marked
                                         in [CharUsed, CharDVI])
                    then FixCheck1(ptrL,'LABEL',LigChar,jj)
                 else
                 if (not flfirst) and (CharIndexArr[LigChar] = nil)
                    then CharIndexArr[LigChar]:=ptrL;
           end;

           TLabelBoundary : if (not flfirst) and (CharIndexArr[256] = nil)
                    then CharIndexArr[256]:=ptrL;

           TSkip, TStop : ;

           TKern : if (not flfirst) and (KernChar = BoundCharGlb)
                   then FlBoundCharGlb:=true
                else
                if not (CharDataGlb^[KernChar].marked
                                         in [CharUsed, CharDVI])
                   then FixCheck1(ptrL,'KRN',KernChar,jj);

           else begin {Lig}
                if not (CharDataGlb^[InsChar].marked
                                         in [CharUsed, CharDVI])
                   then FixCheck1(ptrL,'LIG(Insert Char)',InsChar,jj)
                else
                if (not flfirst) and (NextChar = BoundCharGlb)
                   then begin
                        FlBoundCharGlb:=true; marked:=LigUsedBound;
                   end
                else
                if not (CharDataGlb^[NextChar].marked
                                         in [CharUsed, CharDVI])
                   then FixCheck1(ptrL,'LIG(Next Char)',NextChar,jj);

           end; {else}
           end; {case, if}

      end;
      ptrL:=ptrL^.ptrNext;
   end; {while}

end; {CheckLigTableTable}


