/* wmputc.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_putc (wm_handle wh, char c)
{
  int mx, my;

  switch (c)
    {
    case '\n':
      wh->x = 0;
      ++wh->y;
      break;
    default:
      mx = wh->x+wh->ax;
      my = wh->y+wh->ay;
      if (wh->display)
        {
          if (wh->visible || MASK (wh, mx, my))
            _wm_putc2 (c, wh->x+wh->x0, wh->y+wh->y0, wh->wattr);
        }
      else
        wh->update_req = TRUE;
      _wm_store1 (wh, mx, my, c, wh->wattr);
      if (++wh->x >= wh->width)
        {
          if (wh->wrap)
            {
              wh->x = 0;
              ++wh->y;
            }
          else
            --wh->x;
        }
    }
  if (wh->y >= wh->height)
    {
      --wh->y;
      wm_scroll (wh, 1);
    }
  _wm_cursor1 ();
}
