/* connect.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include <rsxnt.h>
#include <rsxntso.h>

int __connect (int fd, __const__ struct sockaddr *addr, int addrlen)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();

    if (!_rsxnt_socket_inited)
      return _rsxnt_errno(ENETDOWN);

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_mode != HT_SOCKET)
        return _rsxnt_errno(EBADF);
    else {
        if ((*wsa_connect) ((int)p->file[fd].f_handle, addr, addrlen) == SOCKET_ERROR)
            return _rsxnt_socket_errno();
        return 0;
    }
}
