#
# DOS.S  (c) Rainer Schnitker
#
# Provide syscalls for Win32 and MSDOS
#
# History:
#
#  6/95 : first code
#  7/95 : modify import address to call dummy code if RSXNT is not imported
#  3/96 : modify init for new start address
#  4/96 : fix 3/96 for win32s
#         fix 7/95 for linked programs without ntbind.dll
#  5/96 : redesign
#  4/97 : makelib wants hint value (instead ordinal)
#

.data
        __win32_app:
        .long   0

        __dummy_address:
        .long   0

.text

        .align  2, 0x90
        .globl  __dos_init
__dos_init:
        movl    $__text, %eax           # if DOS, eax = 0x10000/0x1000
        cmpl    $0x10000, %eax          # compare to dos text addr
        je      1f
        cmpl    $0x1000, %eax           # compare to new dos text addr
        je      1f
        movl    %eax, __win32_app

__rsxnt_init:                           # ntbind will override next address
        jmp     *__dummy_address        # to the import section - RSXNT_Init
1:      ret     $4                      # for dos extender

        .align  2, 0x90
        .globl  __dos_syscall
__dos_syscall:
        cmpl    $0, __win32_app
        je      1f
__rsxnt_call:                           # ntbind will override next address
        jmp     *__dummy_address        # to the import section - RXNT_Call
1:      int     $0x21                   # for dos extender
        ret

        call    _force_reloc_call

# add syscall import entries for RSXNT.DLL

.stabs "__ImpNT_RSXNT_Call=RSXNT.dll", 36, 0, 0, __rsxnt_call+2
.stabs "__ImpNT_RSXNT_Init=RSXNT.dll", 36, 0, 1, __rsxnt_init+2

