/*
    DllEntry - called from dll0.s, init C runtime, call LibMain

    Copyright (C) 1996
	Rainer Schnitker, Heeper Str. 283, 33607 Bielefeld
	email: rainer@mathematik.uni-bielefeld.de

    All rights reserved
*/

#ifdef __GNUC__
#include <wingnuc.h>
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define DLL_INIT 0
#define DLL_TERM 1

/* emx init dll function */
unsigned long _DLL_InitTerm(unsigned long handle, unsigned long flags);

/* Win32 LibMain */
BOOL APIENTRY LibMain(HANDLE hInst, DWORD fdwReason, LPVOID lpReserved);


BOOL APIENTRY _DllEntryPoint(HANDLE hInst, DWORD fdwReason, LPVOID lpReserved)
{
    unsigned long ret;

    if (fdwReason == DLL_PROCESS_ATTACH)
        ret = _DLL_InitTerm(0, DLL_INIT);
    else if (fdwReason == DLL_PROCESS_DETACH)
        ret = _DLL_InitTerm(0, DLL_TERM);
    else
        ret = 1;

    if (!ret)
        return FALSE;
    else
        return LibMain(hInst, fdwReason, lpReserved);
}
