#!/usr/bin/perl

package eBay::API::XML::Call::IssueRefund;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. IssueRefund.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::IssueRefund

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::IssueRefund inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::IssueRefund::IssueRefundRequestType;
use eBay::API::XML::Call::IssueRefund::IssueRefundResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'IssueRefund';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::IssueRefund::IssueRefundRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::IssueRefund::IssueRefundResponseType';
}

#
# input properties
#

=head2 setItemID()

ID of the Half.com item associated with the refund payment to the buyer.
To uniquely identify a transaction, you need to specify both ItemID
and TransactionID. Use GetSellerPayments to determine the item ID
and transaction ID associated with the original sale payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setRefundAmount()

The amount the seller wants to refund to the buyer, in US Dollars (USD).
Must be greater than 0.00. Half.com allows a maximum of the original item
sale price (transaction price plus original shipping reimbursement) plus
return shipping costs (the amount the buyer paid to return the item).
Typically, the return shipping cost is based on the current cost of
shipping the individual item (not the discounted cost calculated during
the original checkout for a multi-item order). You can also issue a
partial refund for the amount you want the buyer to receive. If
RefundType=Full or RefundType=FullPlusShipping and you do not pass
RefundAmount in the request, Half.com will calculate the refund amount for
you. If you pass RefundAmount in the request, the amount you specify will
override Half.com's calculated value. Required if RefundType=
CustomOrPartial.

  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut
       
sub setRefundAmount {
   my $self   = shift;
   my $pRefundAmount = shift;
   $self->getRequestDataType()->setRefundAmount($pRefundAmount);
}

=head2 setRefundMessage()

Note to the buyer. Cannot include HTML.

MaxLength: 400

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setRefundMessage {
   my $self   = shift;
   my $sRefundMessage = shift;
   $self->getRequestDataType()->setRefundMessage($sRefundMessage);
}

=head2 setRefundReason()

Explanation of the reason that the refund is being issued.

  RequiredInput: Yes
#    Argument: 'ns:RefundReasonCodeType'

=cut
       
sub setRefundReason {
   my $self   = shift;
   my $sRefundReason = shift;
   $self->getRequestDataType()->setRefundReason($sRefundReason);
}

=head2 setRefundType()

Explanation of the costs that the refund amount covers.

  RequiredInput: Yes
#    Argument: 'ns:RefundTypeCodeType'

=cut
       
sub setRefundType {
   my $self   = shift;
   my $sRefundType = shift;
   $self->getRequestDataType()->setRefundType($sRefundType);
}

=head2 setTransactionID()

ID of the Half.com transaction associated with the refund payment.
To uniquely identify a transaction, you need to specify both ItemID
and TransactionID. Use GetSellerPayments to determine the item ID
and transaction ID associated with the original sale payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#

=head2 getRefundFromSeller()

Total amount that the seller asked Half.com to refund to 
a buyer for a Half.com transaction.

  Returned: Always
#    Returns: 'ns:AmountType'

=cut
       
sub getRefundFromSeller {
   my $self = shift;
   return $self->getResponseDataType()->getRefundFromSeller();
}

=head2 getTotalRefundToBuyer()

Total amount that Half.com refunded to the buyer (which could include the refund amount 
from the seller plus a refund amount from Half.com).

  Returned: Always
#    Returns: 'ns:AmountType'

=cut
       
sub getTotalRefundToBuyer {
   my $self = shift;
   return $self->getResponseDataType()->getTotalRefundToBuyer();
}





1;   
