package Locales::DB::Territory::el;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::el::VERSION = '0.09';

$Locales::DB::Territory::el::cldr_version = '2.0';

%Locales::DB::Territory::el::code_to_name = (
    '001' => 'Κόσμος',
    '002' => 'Αφρική',
    '003' => "Βόρεια\ Αμερική",
    '005' => "Νότια\ Αμερική",
    '009' => 'Ωκεανία',
    '011' => "Δυτική\ Αφρική",
    '013' => "Κεντρική\ Αμερική",
    '014' => "Ανατολική\ Αφρική",
    '015' => "Βόρεια\ Αφρική",
    '017' => "Μέση\ Αφρική",
    '018' => "Νότιος\ Αφρική",
    '019' => 'Αμερική',
    '021' => "Βόρειος\ Αμερική",
    '029' => 'Καραϊβική',
    '030' => "Ανατολική\ Ασία",
    '034' => "Νότια\ Ασία",
    '035' => "Νοτιοανατολική\ Ασία",
    '039' => "Νότια\ Ευρώπη",
    '053' => "Αυστραλία\ και\ Νέα\ Ζηλανδία",
    '054' => 'Μελανησία',
    '057' => "Περιοχή\ Μικρονησίας",
    '061' => 'Πολυνησία',
    '062' => "Νότια\ Κεντρική\ Ασία",
    142   => 'Ασία',
    143   => "Κεντρική\ Ασία",
    145   => "Δυτική\ Ασία",
    150   => 'Ευρώπη',
    151   => "Ανατολική\ Ευρώπη",
    154   => "Βόρεια\ Ευρώπη",
    155   => "Δυτική\ Ευρώπη",
    172   => "Κοινοπολιτεία\ Ανεξαρτήτων\ Πολιτειών",
    200   => 'Czechoslovakia',
    419   => "Λατινική\ Αμερική\ και\ Καραϊβική",
    830   => "Νησιά\ Τσάνελ",
    'ac'  => "Νήσος\ Ασενσιόν",
    'ad'  => 'Ανδόρα',
    'ae'  => "Ηνωμένα\ Αραβικά\ Εμιράτα",
    'af'  => 'Αφγανιστάν',
    'ag'  => "Αντίγκουα\ και\ Μπαρμπούντα",
    'ai'  => 'Ανγκουίλα',
    'al'  => 'Αλβανία',
    'am'  => 'Αρμενία',
    'an'  => "Ολλανδικές\ Αντίλλες",
    'ao'  => 'Ανγκόλα',
    'aq'  => 'Ανταρκτική',
    'ar'  => 'Αργεντινή',
    'as'  => "Αμερικανική\ Σαμόα",
    'at'  => 'Αυστρία',
    'au'  => 'Αυστραλία',
    'aw'  => 'Αρούμπα',
    'ax'  => "Νήσοι\ Άλαντ",
    'az'  => 'Αζερμπαϊτζάν',
    'ba'  => "Βοσνία\ \-\ Ερζεγοβίνη",
    'bb'  => 'Μπαρμπάντος',
    'bd'  => 'Μπανγκλαντές',
    'be'  => 'Βέλγιο',
    'bf'  => "Μπουρκίνα\ Φάσο",
    'bg'  => 'Βουλγαρία',
    'bh'  => 'Μπαχρέιν',
    'bi'  => 'Μπουρούντι',
    'bj'  => 'Μπενίν',
    'bl'  => "Άγιος\ Βαρθολομαίος",
    'bm'  => 'Βερμούδες',
    'bn'  => 'Μπρουνέι',
    'bo'  => 'Βολιβία',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Βραζιλία',
    'bs'  => 'Μπαχάμες',
    'bt'  => 'Μπουτάν',
    'bv'  => "Νήσος\ Μπουβέ",
    'bw'  => 'Μποτσουάνα',
    'by'  => 'Λευκορωσία',
    'bz'  => 'Μπελίσε',
    'ca'  => 'Καναδάς',
    'cc'  => "Νήσοι\ Κόκος",
    'cd'  => 'Κονγκό',
    'cf'  => "Κεντροαφρικανική\ Δημοκρατία",
    'cg'  => "Κόνγκο\ \[Δημοκρατία\ του\]",
    'ch'  => 'Ελβετία',
    'ci'  => "Ακτή\ Ελεφαντοστού",
    'ck'  => "Νήσοι\ Κουκ",
    'cl'  => 'Χιλή',
    'cm'  => 'Καμερούν',
    'cn'  => 'Κίνα',
    'co'  => 'Κολομβία',
    'cp'  => "Νήσος\ Κλίπερτον",
    'cr'  => "Κόστα\ Ρίκα",
    'cs'  => "Σερβία\ και\ Μαυροβούνιο",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Κούβα',
    'cv'  => "Πράσινο\ Ακρωτήριο",
    'cx'  => "Νήσος\ Χριστουγέννων",
    'cy'  => 'Κύπρος',
    'cz'  => 'Τσεχία',
    'dd'  => "East\ Germany",
    'de'  => 'Γερμανία',
    'dg'  => "Ντιέγκο\ Γκαρσία",
    'dj'  => 'Τζιμπουτί',
    'dk'  => 'Δανία',
    'dm'  => 'Ντομίνικα',
    'do'  => "Δομινικανή\ Δημοκρατία",
    'dz'  => 'Αλγερία',
    'ea'  => "Θεούτα\ και\ Μελίλα",
    'ec'  => 'Εκουαδόρ',
    'ee'  => 'Εσθονία',
    'eg'  => 'Αίγυπτος',
    'eh'  => "Δυτική\ Σαχάρα",
    'er'  => 'Ερυθραία',
    'es'  => 'Ισπανία',
    'et'  => 'Αιθιοπία',
    'eu'  => "Ευρωπαϊκή\ Ένωση",
    'fi'  => 'Φινλανδία',
    'fj'  => 'Φίτζι',
    'fk'  => "Νήσοι\ Φώκλαντ",
    'fm'  => 'Μικρονησία',
    'fo'  => "Νήσοι\ Φερόε",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Γαλλία',
    'fx'  => "Μητροπολιτική\ Γαλλία",
    'ga'  => 'Γκαμπόν',
    'gb'  => "Ηνωμένο\ Βασίλειο",
    'gd'  => 'Γρενάδα',
    'ge'  => 'Γεωργία',
    'gf'  => "Γαλλική\ Γουιάνα",
    'gg'  => 'Γκερνσέι',
    'gh'  => 'Γκάνα',
    'gi'  => 'Γιβραλτάρ',
    'gl'  => 'Γροιλανδία',
    'gm'  => 'Γκάμπια',
    'gn'  => 'Γουινέα',
    'gp'  => 'Γουαδελούπη',
    'gq'  => "Ισημερινή\ Γουινέα",
    'gr'  => 'Ελλάδα',
    'gs'  => "Νότια\ Γεωργία\ και\ Νότιες\ Νήσοι\ Σάντουιτς",
    'gt'  => 'Γουατεμάλα',
    'gu'  => 'Γκουάμ',
    'gw'  => "Γουινέα\-Μπισάου",
    'gy'  => 'Γουιάνα',
    'hk'  => "Χονγκ\ Κονγκ",
    'hm'  => "Νήσοι\ Χερντ\ και\ Μακντόναλντ",
    'hn'  => 'Ονδούρα',
    'hr'  => 'Κροατία',
    'ht'  => 'Αϊτή',
    'hu'  => 'Ουγγαρία',
    'ic'  => "Κανάριοι\ Νήσοι",
    'id'  => 'Ινδονησία',
    'ie'  => 'Ιρλανδία',
    'il'  => 'Ισραήλ',
    'im'  => "Νήσος\ Μαν",
    'in'  => 'Ινδία',
    'io'  => "Βρετανικά\ Εδάφη\ Ινδικού\ Ωκεανού",
    'iq'  => 'Ιράκ',
    'ir'  => 'Ιράν',
    'is'  => 'Ισλανδία',
    'it'  => 'Ιταλία',
    'je'  => 'Υερσέη',
    'jm'  => 'Τζαμάικα',
    'jo'  => 'Ιορδανία',
    'jp'  => 'Ιαπωνία',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Κένυα',
    'kg'  => 'Κιργιστάν',
    'kh'  => 'Καμπότζη',
    'ki'  => 'Κιριμπάτι',
    'km'  => 'Κομόρος',
    'kn'  => "Σαιντ\ Κιτς\ και\ Νέβις",
    'kp'  => "Βόρεια\ Κορέα",
    'kr'  => "Νότια\ Κορέα",
    'kw'  => 'Κουβέιτ',
    'ky'  => "Νήσοι\ Κέιμαν",
    'kz'  => 'Καζακστάν',
    'la'  => 'Λάος',
    'lb'  => 'Λίβανος',
    'lc'  => "Αγία\ Λουκία",
    'li'  => 'Λιχτενστάιν',
    'lk'  => "Σρι\ Λάνκα",
    'lr'  => 'Λιβερία',
    'ls'  => 'Λεσότο',
    'lt'  => 'Λιθουανία',
    'lu'  => 'Λουξεμβούργο',
    'lv'  => 'Λετονία',
    'ly'  => 'Λιβύη',
    'ma'  => 'Μαρόκο',
    'mc'  => 'Μονακό',
    'md'  => 'Μολδαβία',
    'me'  => 'Μαυροβούνιο',
    'mf'  => "Άγιος\ Μαρτίνος",
    'mg'  => 'Μαδαγασκάρη',
    'mh'  => "Νήσοι\ Μάρσαλ",
    'mi'  => "Midway\ Islands",
    'mk'  => 'ΠΓΔΜ',
    'ml'  => 'Μάλι',
    'mm'  => 'Μιανμάρ',
    'mn'  => 'Μογγολία',
    'mo'  => 'Μακάο',
    'mp'  => "Βόρειες\ Μαριάνες\ Νήσοι",
    'mq'  => 'Μαρτινίκα',
    'mr'  => 'Μαυριτανία',
    'ms'  => 'Μονσεράτ',
    'mt'  => 'Μάλτα',
    'mu'  => 'Μαυρίκιος',
    'mv'  => 'Μαλδίβες',
    'mw'  => 'Μαλάουι',
    'mx'  => 'Μεξικό',
    'my'  => 'Μαλαισία',
    'mz'  => 'Μοζαμβίκη',
    'na'  => 'Ναμίμπια',
    'nc'  => "Νέα\ Καληδονία",
    'ne'  => 'Νίγηρας',
    'nf'  => "Νήσος\ Νόρφολκ",
    'ng'  => 'Νιγηρία',
    'ni'  => 'Νικαράγουα',
    'nl'  => 'Ολλανδία',
    'no'  => 'Νορβηγία',
    'np'  => 'Νεπάλ',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Ναούρου',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Νιούε',
    'nz'  => "Νέα\ Ζηλανδία",
    'om'  => 'Ομάν',
    'pa'  => 'Παναμάς',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Περού',
    'pf'  => "Γαλλική\ Πολυνησία",
    'pg'  => "Παπούα\ Νέα\ Γουινέα",
    'ph'  => 'Φιλιππίνες',
    'pk'  => 'Πακιστάν',
    'pl'  => 'Πολωνία',
    'pm'  => "Σαιντ\ Πιέρ\ και\ Μικελόν",
    'pn'  => 'Πίτκερν',
    'pr'  => "Πουέρτο\ Ρίκο",
    'ps'  => "Παλαιστινιακά\ Εδάφη",
    'pt'  => 'Πορτογαλία',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Παλάου',
    'py'  => 'Παραγουάη',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Κατάρ',
    'qo'  => "Περιφερειακή\ Ωκεανία",
    're'  => 'Ρεϋνιόν',
    'ro'  => 'Ρουμανία',
    'rs'  => 'Σερβία',
    'ru'  => 'Ρωσία',
    'rw'  => 'Ρουάντα',
    'sa'  => "Σαουδική\ Αραβία",
    'sb'  => "Νήσοι\ Σολομώντος",
    'sc'  => 'Σεϋχέλλες',
    'sd'  => 'Σουδάν',
    'se'  => 'Σουηδία',
    'sg'  => 'Σιγκαπούρη',
    'sh'  => "Αγία\ Ελένη",
    'si'  => 'Σλοβενία',
    'sj'  => "Σβάλμπαρντ\ και\ Νήσοι\ Γιάν\ Μέϋεν",
    'sk'  => 'Σλοβακία',
    'sl'  => "Σιέρα\ Λεόνε",
    'sm'  => "Άγιος\ Μαρίνος",
    'sn'  => 'Σενεγάλη',
    'so'  => 'Σομαλία',
    'sr'  => 'Σουρινάμ',
    'st'  => "Σάο\ Τομέ\ και\ Πρίνσιπε",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "Ελ\ Σαλβαδόρ",
    'sy'  => 'Συρία',
    'sz'  => 'Ζουαζηλάνδη',
    'ta'  => "Τριστάν\ ντα\ Κούνια",
    'tc'  => "Νήσοι\ Τερκς\ και\ Κάικος",
    'td'  => 'Τσαντ',
    'tf'  => "Γαλλικά\ Νότια\ Εδάφη",
    'tg'  => 'Τόγκο',
    'th'  => 'Ταϊλάνδη',
    'tj'  => 'Τατζικιστάν',
    'tk'  => 'Τοκελάου',
    'tl'  => "Ανατολικό\ Τιμόρ",
    'tm'  => 'Τουρκμενιστάν',
    'tn'  => 'Τυνησία',
    'to'  => 'Τόνγκα',
    'tr'  => 'Τουρκία',
    'tt'  => "Τρινιντάντ\ και\ Τομπάγκο",
    'tv'  => 'Τουβαλού',
    'tw'  => 'Ταϊβάν',
    'tz'  => 'Τανζανία',
    'ua'  => 'Ουκρανία',
    'ug'  => 'Ουγκάντα',
    'um'  => "Απομακρυσμένες\ Νησίδες\ Η\.Π\.Α\.",
    'us'  => "Ηνωμένες\ Πολιτείες\ της\ Αμερικής",
    'uy'  => 'Ουρουγουάη',
    'uz'  => 'Ουζμπεκιστάν',
    'va'  => 'Βατικανό',
    'vc'  => "Άγιος\ Βικέντιος\ και\ Γρεναδίνες",
    'vd'  => "North\ Vietnam",
    've'  => 'Βενεζουέλα',
    'vg'  => "Βρετανικές\ Παρθένοι\ Νήσοι",
    'vi'  => "Αμερικανικές\ Παρθένοι\ Νήσοι",
    'vn'  => 'Βιετνάμ',
    'vu'  => 'Βανουάτου',
    'wf'  => "Νήσοι\ Ουαλλίς\ και\ Φουτουνά",
    'wk'  => "Wake\ Island",
    'ws'  => 'Σαμόα',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Υεμένη',
    'yt'  => 'Μαγιότ',
    'za'  => "Νότια\ Αφρική",
    'zm'  => 'Ζάμπια',
    'zw'  => 'Ζιμπάμπουε',
    'zz'  => "Άγνωστη\ ή\ μη\ έγκυρη\ περιοχή",
);

%Locales::DB::Territory::el::name_to_code = (
    'britishantarcticterritory'                                              => 'bq',
    'cantonandenderburyislands'                                              => 'ct',
    'czechoslovakia'                                                         => 200,
    'dronningmaudland'                                                       => 'nq',
    'eastgermany'                                                            => 'dd',
    'frenchsouthernandantarcticterritories'                                  => 'fq',
    'johnstonisland'                                                         => 'jt',
    'midwayislands'                                                          => 'mi',
    'neutralzone'                                                            => 'nt',
    'northvietnam'                                                           => 'vd',
    'pacificislandstrustterritory'                                           => 'pc',
    'panamacanalzone'                                                        => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                              => 'yd',
    "u\.s\.miscellaneouspacificislands"                                      => 'pu',
    'unionofsovietsocialistrepublics'                                        => 'su',
    'wakeisland'                                                             => 'wk',
    'ΆγιοςΒαρθολομαίος'                                     => 'bl',
    'ΆγιοςΒικέντιοςκαιΓρεναδίνες'                 => 'vc',
    'ΆγιοςΜαρίνος'                                               => 'sm',
    'ΆγιοςΜαρτίνος'                                             => 'mf',
    'Άγνωστηήμηέγκυρηπεριοχή'                         => 'zz',
    'Αίγυπτος'                                                       => 'eg',
    'ΑγίαΕλένη'                                                     => 'sh',
    'ΑγίαΛουκία'                                                   => 'lc',
    'Αζερμπαϊτζάν'                                               => 'az',
    'Αιθιοπία'                                                       => 'et',
    'ΑκτήΕλεφαντοστού'                                       => 'ci',
    'Αλβανία'                                                         => 'al',
    'Αλγερία'                                                         => 'dz',
    'Αμερική'                                                         => '019',
    'ΑμερικανικέςΠαρθένοιΝήσοι'                     => 'vi',
    'ΑμερικανικήΣαμόα'                                       => 'as',
    'ΑνατολικήΑσία'                                             => '030',
    'ΑνατολικήΑφρική'                                         => '014',
    'ΑνατολικήΕυρώπη'                                         => 151,
    'ΑνατολικόΤιμόρ'                                           => 'tl',
    'Ανγκουίλα'                                                     => 'ai',
    'Ανγκόλα'                                                         => 'ao',
    'Ανδόρα'                                                           => 'ad',
    'ΑντίγκουακαιΜπαρμπούντα'                         => 'ag',
    'Ανταρκτική'                                                   => 'aq',
    "ΑπομακρυσμένεςΝησίδεςΗ\.Π\.Α\."                 => 'um',
    'Αργεντινή'                                                     => 'ar',
    'Αρμενία'                                                         => 'am',
    'Αρούμπα'                                                         => 'aw',
    'Ασία'                                                               => 142,
    'Αυστρία'                                                         => 'at',
    'Αυστραλία'                                                     => 'au',
    'ΑυστραλίακαιΝέαΖηλανδία'                         => '053',
    'Αφγανιστάν'                                                   => 'af',
    'Αφρική'                                                           => '002',
    'Αϊτή'                                                               => 'ht',
    'Βέλγιο'                                                           => 'be',
    'Βανουάτου'                                                     => 'vu',
    'Βατικανό'                                                       => 'va',
    'Βενεζουέλα'                                                   => 've',
    'Βερμούδες'                                                     => 'bm',
    'Βιετνάμ'                                                         => 'vn',
    'Βολιβία'                                                         => 'bo',
    'ΒοσνίαΕρζεγοβίνη'                                       => 'ba',
    'Βουλγαρία'                                                     => 'bg',
    'Βραζιλία'                                                       => 'br',
    'ΒρετανικάΕδάφηΙνδικούΩκεανού'               => 'io',
    'ΒρετανικέςΠαρθένοιΝήσοι'                         => 'vg',
    'ΒόρειαΑμερική'                                             => '003',
    'ΒόρειαΑφρική'                                               => '015',
    'ΒόρειαΕυρώπη'                                               => 154,
    'ΒόρειαΚορέα'                                                 => 'kp',
    'ΒόρειεςΜαριάνεςΝήσοι'                               => 'mp',
    'ΒόρειοςΑμερική'                                           => '021',
    'Γαλλία'                                                           => 'fr',
    'ΓαλλικάΝότιαΕδάφη'                                     => 'tf',
    'ΓαλλικήΓουιάνα'                                           => 'gf',
    'ΓαλλικήΠολυνησία'                                       => 'pf',
    'Γερμανία'                                                       => 'de',
    'Γεωργία'                                                         => 'ge',
    'Γιβραλτάρ'                                                     => 'gi',
    'Γκάμπια'                                                         => 'gm',
    'Γκάνα'                                                             => 'gh',
    'Γκαμπόν'                                                         => 'ga',
    'Γκερνσέι'                                                       => 'gg',
    'Γκουάμ'                                                           => 'gu',
    'Γουαδελούπη'                                                 => 'gp',
    'Γουατεμάλα'                                                   => 'gt',
    'Γουιάνα'                                                         => 'gy',
    'Γουινέα'                                                         => 'gn',
    'ΓουινέαΜπισάου'                                           => 'gw',
    'Γρενάδα'                                                         => 'gd',
    'Γροιλανδία'                                                   => 'gl',
    'Δανία'                                                             => 'dk',
    'ΔομινικανήΔημοκρατία'                               => 'do',
    'ΔυτικήΑσία'                                                   => 145,
    'ΔυτικήΑφρική'                                               => '011',
    'ΔυτικήΕυρώπη'                                               => 155,
    'ΔυτικήΣαχάρα'                                               => 'eh',
    'Εκουαδόρ'                                                       => 'ec',
    'ΕλΣαλβαδόρ'                                                   => 'sv',
    'Ελβετία'                                                         => 'ch',
    'Ελλάδα'                                                           => 'gr',
    'Ερυθραία'                                                       => 'er',
    'Εσθονία'                                                         => 'ee',
    'ΕυρωπαϊκήΈνωση'                                           => 'eu',
    'Ευρώπη'                                                           => 150,
    'Ζάμπια'                                                           => 'zm',
    'Ζιμπάμπουε'                                                   => 'zw',
    'Ζουαζηλάνδη'                                                 => 'sz',
    'ΗνωμέναΑραβικάΕμιράτα'                             => 'ae',
    'ΗνωμένεςΠολιτείεςτηςΑμερικής'               => 'us',
    'ΗνωμένοΒασίλειο'                                         => 'gb',
    'ΘεούτακαιΜελίλα'                                         => 'ea',
    'Ιαπωνία'                                                         => 'jp',
    'Ινδία'                                                             => 'in',
    'Ινδονησία'                                                     => 'id',
    'Ιορδανία'                                                       => 'jo',
    'Ιράκ'                                                               => 'iq',
    'Ιράν'                                                               => 'ir',
    'Ιρλανδία'                                                       => 'ie',
    'ΙσημερινήΓουινέα'                                       => 'gq',
    'Ισλανδία'                                                       => 'is',
    'Ισπανία'                                                         => 'es',
    'Ισραήλ'                                                           => 'il',
    'Ιταλία'                                                           => 'it',
    'Κένυα'                                                             => 'ke',
    'Κίνα'                                                               => 'cn',
    'Καζακστάν'                                                     => 'kz',
    'Καμερούν'                                                       => 'cm',
    'Καμπότζη'                                                       => 'kh',
    'ΚανάριοιΝήσοι'                                             => 'ic',
    'Καναδάς'                                                         => 'ca',
    'Καραϊβική'                                                     => '029',
    'Κατάρ'                                                             => 'qa',
    'ΚεντρικήΑμερική'                                         => '013',
    'ΚεντρικήΑσία'                                               => 143,
    'ΚεντροαφρικανικήΔημοκρατία'                   => 'cf',
    'Κιργιστάν'                                                     => 'kg',
    'Κιριμπάτι'                                                     => 'ki',
    'ΚοινοπολιτείαΑνεξαρτήτωνΠολιτειών'     => 172,
    'Κολομβία'                                                       => 'co',
    'Κομόρος'                                                         => 'km',
    'Κονγκό'                                                           => 'cd',
    'Κουβέιτ'                                                         => 'kw',
    'Κούβα'                                                             => 'cu',
    'Κροατία'                                                         => 'hr',
    'ΚόνγκοΔημοκρατίατου'                                 => 'cg',
    'Κόσμος'                                                           => '001',
    'ΚόσταΡίκα'                                                     => 'cr',
    'Κύπρος'                                                           => 'cy',
    'Λάος'                                                               => 'la',
    'Λίβανος'                                                         => 'lb',
    'ΛατινικήΑμερικήκαιΚαραϊβική'                 => 419,
    'Λεσότο'                                                           => 'ls',
    'Λετονία'                                                         => 'lv',
    'Λευκορωσία'                                                   => 'by',
    'Λιβερία'                                                         => 'lr',
    'Λιβύη'                                                             => 'ly',
    'Λιθουανία'                                                     => 'lt',
    'Λιχτενστάιν'                                                 => 'li',
    'Λουξεμβούργο'                                               => 'lu',
    'Μάλι'                                                               => 'ml',
    'Μάλτα'                                                             => 'mt',
    'ΜέσηΑφρική'                                                   => '017',
    'Μαγιότ'                                                           => 'yt',
    'Μαδαγασκάρη'                                                 => 'mg',
    'Μακάο'                                                             => 'mo',
    'Μαλάουι'                                                         => 'mw',
    'Μαλαισία'                                                       => 'my',
    'Μαλδίβες'                                                       => 'mv',
    'Μαρτινίκα'                                                     => 'mq',
    'Μαρόκο'                                                           => 'ma',
    'Μαυρίκιος'                                                     => 'mu',
    'Μαυριτανία'                                                   => 'mr',
    'Μαυροβούνιο'                                                 => 'me',
    'Μελανησία'                                                     => '054',
    'Μεξικό'                                                           => 'mx',
    'ΜητροπολιτικήΓαλλία'                                 => 'fx',
    'Μιανμάρ'                                                         => 'mm',
    'Μικρονησία'                                                   => 'fm',
    'Μογγολία'                                                       => 'mn',
    'Μοζαμβίκη'                                                     => 'mz',
    'Μολδαβία'                                                       => 'md',
    'Μονακό'                                                           => 'mc',
    'Μονσεράτ'                                                       => 'ms',
    'Μπανγκλαντές'                                               => 'bd',
    'Μπαρμπάντος'                                                 => 'bb',
    'Μπαχάμες'                                                       => 'bs',
    'Μπαχρέιν'                                                       => 'bh',
    'Μπελίσε'                                                         => 'bz',
    'Μπενίν'                                                           => 'bj',
    'Μποτσουάνα'                                                   => 'bw',
    'ΜπουρκίναΦάσο'                                             => 'bf',
    'Μπουρούντι'                                                   => 'bi',
    'Μπουτάν'                                                         => 'bt',
    'Μπρουνέι'                                                       => 'bn',
    'ΝέαΖηλανδία'                                                 => 'nz',
    'ΝέαΚαληδονία'                                               => 'nc',
    'ΝήσοιΆλαντ'                                                   => 'ax',
    'ΝήσοιΚέιμαν'                                                 => 'ky',
    'ΝήσοιΚουκ'                                                     => 'ck',
    'ΝήσοιΚόκος'                                                   => 'cc',
    'ΝήσοιΜάρσαλ'                                                 => 'mh',
    'ΝήσοιΟυαλλίςκαιΦουτουνά'                         => 'wf',
    'ΝήσοιΣολομώντος'                                         => 'sb',
    'ΝήσοιΤερκςκαιΚάικος'                                 => 'tc',
    'ΝήσοιΦερόε'                                                   => 'fo',
    'ΝήσοιΦώκλαντ'                                               => 'fk',
    'ΝήσοιΧερντκαιΜακντόναλντ'                       => 'hm',
    'ΝήσοςΑσενσιόν'                                             => 'ac',
    'ΝήσοςΚλίπερτον'                                           => 'cp',
    'ΝήσοςΜαν'                                                       => 'im',
    'ΝήσοςΜπουβέ'                                                 => 'bv',
    'ΝήσοςΝόρφολκ'                                               => 'nf',
    'ΝήσοςΧριστουγέννων'                                   => 'cx',
    'Νίγηρας'                                                         => 'ne',
    'Ναμίμπια'                                                       => 'na',
    'Ναούρου'                                                         => 'nr',
    'Νεπάλ'                                                             => 'np',
    'ΝησιάΤσάνελ'                                                 => 830,
    'Νιγηρία'                                                         => 'ng',
    'Νικαράγουα'                                                   => 'ni',
    'Νιούε'                                                             => 'nu',
    'Νορβηγία'                                                       => 'no',
    'ΝοτιοανατολικήΑσία'                                   => '035',
    'ΝτιέγκοΓκαρσία'                                           => 'dg',
    'Ντομίνικα'                                                     => 'dm',
    'ΝότιαΑμερική'                                               => '005',
    'ΝότιαΑσία'                                                     => '034',
    'ΝότιαΑφρική'                                                 => 'za',
    'ΝότιαΓεωργίακαιΝότιεςΝήσοιΣάντουιτς' => 'gs',
    'ΝότιαΕυρώπη'                                                 => '039',
    'ΝότιαΚεντρικήΑσία'                                     => '062',
    'ΝότιαΚορέα'                                                   => 'kr',
    'ΝότιοςΑφρική'                                               => '018',
    'Ολλανδία'                                                       => 'nl',
    'ΟλλανδικέςΑντίλλες'                                   => 'an',
    'Ομάν'                                                               => 'om',
    'Ονδούρα'                                                         => 'hn',
    'Ουγγαρία'                                                       => 'hu',
    'Ουγκάντα'                                                       => 'ug',
    'Ουζμπεκιστάν'                                               => 'uz',
    'Ουκρανία'                                                       => 'ua',
    'Ουρουγουάη'                                                   => 'uy',
    'ΠΓΔΜ'                                                               => 'mk',
    'Πίτκερν'                                                         => 'pn',
    'Πακιστάν'                                                       => 'pk',
    'Παλάου'                                                           => 'pw',
    'ΠαλαιστινιακάΕδάφη'                                   => 'ps',
    'Παναμάς'                                                         => 'pa',
    'ΠαπούαΝέαΓουινέα'                                       => 'pg',
    'Παραγουάη'                                                     => 'py',
    'ΠεριοχήΜικρονησίας'                                   => '057',
    'ΠεριφερειακήΩκεανία'                                 => 'qo',
    'Περού'                                                             => 'pe',
    'Πολυνησία'                                                     => '061',
    'Πολωνία'                                                         => 'pl',
    'Πορτογαλία'                                                   => 'pt',
    'ΠουέρτοΡίκο'                                                 => 'pr',
    'ΠράσινοΑκρωτήριο'                                       => 'cv',
    'Ρεϋνιόν'                                                         => 're',
    'Ρουάντα'                                                         => 'rw',
    'Ρουμανία'                                                       => 'ro',
    'Ρωσία'                                                             => 'ru',
    'ΣάοΤομέκαιΠρίνσιπε'                                   => 'st',
    'ΣαιντΚιτςκαιΝέβις'                                     => 'kn',
    'ΣαιντΠιέρκαιΜικελόν'                                 => 'pm',
    'Σαμόα'                                                             => 'ws',
    'ΣαουδικήΑραβία'                                           => 'sa',
    'ΣβάλμπαρντκαιΝήσοιΓιάνΜέϋεν'                 => 'sj',
    'Σενεγάλη'                                                       => 'sn',
    'Σερβία'                                                           => 'rs',
    'ΣερβίακαιΜαυροβούνιο'                               => 'cs',
    'Σεϋχέλλες'                                                     => 'sc',
    'ΣιέραΛεόνε'                                                   => 'sl',
    'Σιγκαπούρη'                                                   => 'sg',
    'Σλοβακία'                                                       => 'sk',
    'Σλοβενία'                                                       => 'si',
    'Σομαλία'                                                         => 'so',
    'Σουδάν'                                                           => 'sd',
    'Σουηδία'                                                         => 'se',
    'Σουρινάμ'                                                       => 'sr',
    'ΣριΛάνκα'                                                       => 'lk',
    'Συρία'                                                             => 'sy',
    'Τανζανία'                                                       => 'tz',
    'Τατζικιστάν'                                                 => 'tj',
    'Ταϊβάν'                                                           => 'tw',
    'Ταϊλάνδη'                                                       => 'th',
    'Τζαμάικα'                                                       => 'jm',
    'Τζιμπουτί'                                                     => 'dj',
    'Τοκελάου'                                                       => 'tk',
    'Τουβαλού'                                                       => 'tv',
    'Τουρκία'                                                         => 'tr',
    'Τουρκμενιστάν'                                             => 'tm',
    'ΤρινιντάντκαιΤομπάγκο'                             => 'tt',
    'ΤριστάννταΚούνια'                                       => 'ta',
    'Τσαντ'                                                             => 'td',
    'Τσεχία'                                                           => 'cz',
    'Τυνησία'                                                         => 'tn',
    'Τόγκο'                                                             => 'tg',
    'Τόνγκα'                                                           => 'to',
    'Υεμένη'                                                           => 'ye',
    'Υερσέη'                                                           => 'je',
    'Φίτζι'                                                             => 'fj',
    'Φιλιππίνες'                                                   => 'ph',
    'Φινλανδία'                                                     => 'fi',
    'Χιλή'                                                               => 'cl',
    'ΧονγκΚονγκ'                                                   => 'hk',
    'Ωκεανία'                                                         => '009',
);

1;

