package WebService::Mattermost::V4::API::Resource::Role::View::Plugins;

# ABSTRACT: Links a resource to the plugins view.

use Moo::Role;
use Types::Standard 'Str';

################################################################################

has view_name => (is => 'ro', isa => Str, default => 'Plugins');

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Role::View::Plugins - Links a resource to the plugins view.

=head1 VERSION

version 0.25

=head1 DESCRIPTION

Set a resource as using the L<WebService::Mattermost::V4::API::Object::Plugins>
view.

=head1 ATTRIBUTES

=over 4

=item C<view_name>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
