# Generated by default/object.tt
package Paws::Quicksight::ResourcePermission;
  use Moose;
  has Actions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Principal => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::ResourcePermission

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::ResourcePermission object:

  $service_obj->Method(Att1 => { Actions => $value, ..., Principal => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::ResourcePermission object:

  $result = $service_obj->Method(...);
  $result->Att1->Actions

=head1 DESCRIPTION

Permission for the resource.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Actions => ArrayRef[Str|Undef]

The IAM action to grant or revoke permissions on.


=head2 B<REQUIRED> Principal => Str

The Amazon Resource Name (ARN) of the principal. This can be one of the
following:

=over

=item *

The ARN of an Amazon QuickSight user or group associated with a data
source or dataset. (This is common.)

=item *

The ARN of an Amazon QuickSight user, group, or namespace associated
with an analysis, dashboard, template, or theme. (This is common.)

=item *

The ARN of an AWS account root: This is an IAM ARN rather than a
QuickSight ARN. Use this option only to share resources (templates)
across AWS accounts. (This is less common.)

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

