package Locales::DB::Territory::bn;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::bn::VERSION = '0.09';

$Locales::DB::Territory::bn::cldr_version = '2.0';

%Locales::DB::Territory::bn::code_to_name = (
    '001' => 'পৃথিবী',
    '002' => 'আফ্রিকা',
    '003' => "উত্তর\ আমেরিক",
    '005' => "দক্ষিন\ আমেরিকা",
    '009' => 'ওসানিয়া',
    '011' => "পশ্চিমাঞ্চলীয়\ আফ্রিকা",
    '013' => "মধ্য\ আমেরিকা",
    '014' => "পূর্ব\ আফ্রিকা",
    '015' => "উত্তর\ আফ্রিকা",
    '017' => "মধ্য\ আফ্রিকা",
    '018' => "দক্ষিণাঞ্চলীয়\ আফ্রিকা",
    '019' => 'আমেরিকাস',
    '021' => "উত্তরাঞ্চলীয়\ আমেরিকা",
    '029' => 'ক্যারাবিয়ান',
    '030' => "পূর্ব\ এশিয়া",
    '034' => "দক্ষিণাঞ্চলীয়\ এশিয়া",
    '035' => "দক্ষিন\ পূর্ব\ এশিয়া",
    '039' => "দক্ষিণাঞ্চলীয়\ ইউরোপ",
    '053' => "অস্ট্রেলিয়া\ এবং\ নিউজিল্যান্ড",
    '054' => 'ম্যালেনেশিয়া',
    '057' => "ম্যালেনিশা\ অঞ্চল",
    '061' => 'পলিনেশিয়া',
    '062' => "দক্ষিন\ মধ্য\ এশিয়া",
    142   => 'এশিয়া',
    143   => "মধ্য\ এশিয়া",
    145   => "পশ্চিমাঞ্চলীয়\ এশিয়া",
    150   => 'ইউরোপ',
    151   => "পূর্ব\ ইউরোপ",
    154   => "উত্তরাঞ্চলীয়\ ইউরোপ",
    155   => "পশ্চিমাঞ্চলীয়\ ইউরোপ",
    172   => "স্বাধীন\ রাষ্ট্রের\ কমনওয়েলথ",
    200   => 'চেকোস্লোভাকিয়া',
    419   => "ল্যাটিন\ আমেরিকা\ এবং\ ক্যারাবিয়ান",
    830   => "চ্যানেল\ দ্বীপপুঞ্জ",
    'ac'  => "অ্যাসসেনশন\ আইল্যান্ড",
    'ad'  => 'এ্যান্ডোরা',
    'ae'  => "সংযুক্ত\ আরব\ আমিরাত",
    'af'  => 'আফগানিস্তান',
    'ag'  => "এন্টিগুয়া\ ও\ বারবুডা",
    'ai'  => 'এ্যাঙ্গুইলা',
    'al'  => 'আলব্যানিয়া',
    'am'  => 'আর্মেনিয়া',
    'an'  => "নেদারল্যান্ডস\ এ্যান্টিলিস",
    'ao'  => 'এ্যাঙ্গোলা',
    'aq'  => 'এন্টার্কটিকা',
    'ar'  => 'আর্জেণ্টাইনা',
    'as'  => "আমেরিকান\ সামোয়া",
    'at'  => 'অস্ট্রিয়া',
    'au'  => 'অস্ট্রেলিয়া',
    'aw'  => 'আরুবা',
    'ax'  => "আলান্ড\ দ্বীপপুঞ্জ",
    'az'  => 'আজারবাইজান',
    'ba'  => "বসনিয়া\ ও\ হার্জেগোভিনা",
    'bb'  => 'বারবাদোস',
    'bd'  => 'বাংলাদেশ',
    'be'  => 'বেলজিয়াম',
    'bf'  => "বুরকিনা\ ফাসো",
    'bg'  => 'বুলগেরিয়া',
    'bh'  => 'বাহরাইন',
    'bi'  => 'বুরুন্ডি',
    'bj'  => 'বেনিন',
    'bl'  => "সেন্ট\ বারথেলিমি",
    'bm'  => 'বারমুডা',
    'bn'  => 'ব্রুনেই',
    'bo'  => 'বোলিভিয়া',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'ব্রাজিল',
    'bs'  => "বাহামা\ দ্বীপপুঞ্জ",
    'bt'  => 'ভুটান',
    'bv'  => "বোভেট\ দ্বীপ",
    'bw'  => 'বতসোয়ানা',
    'by'  => 'বেলোরুশিয়া',
    'bz'  => 'বেলিয',
    'ca'  => 'কানাডা',
    'cc'  => "কোকোস\ দ্বীপপুঞ্জ",
    'cd'  => "কঙ্গো\[DRC\]",
    'cf'  => "মধ্য\ আফ্রিকান\ প্রজাতন্ত্র",
    'cg'  => "কঙ্গো\ \[প্রজাতন্ত্র\]",
    'ch'  => 'সুইজর্লণ্ড',
    'ci'  => "আভরি\ কোস্ট",
    'ck'  => "কুক\ দ্বীপপুঞ্জ",
    'cl'  => 'চিলি',
    'cm'  => 'ক্যামেরুন',
    'cn'  => 'চীন',
    'co'  => 'কোলোম্বিয়া',
    'cp'  => "ক্লিপারটন\ আইল্যান্ড",
    'cr'  => 'কোস্টারিকা',
    'cs'  => "সারবিয়ান\ এবং\ মন্টেনিগ্রো",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'কিউবা',
    'cv'  => 'কেপভার্দে',
    'cx'  => "ক্রিসমাস\ দ্বীপ",
    'cy'  => 'সাইপ্রাস',
    'cz'  => "চেক\ প্রজাতন্ত্র",
    'dd'  => "East\ Germany",
    'de'  => 'জার্মানি',
    'dg'  => "দিয়েগো\ গার্সিয়া",
    'dj'  => 'জিবুতি',
    'dk'  => 'ডেনমার্ক',
    'dm'  => 'ডোমিনিকা',
    'do'  => "ডোমেনিকান\ প্রজাতন্ত্র",
    'dz'  => 'এলজিরিয়া',
    'ea'  => "কুউটা\ এবং\ মেলিলা",
    'ec'  => 'ইকুয়েডর',
    'ee'  => 'এস্তোনিয়া',
    'eg'  => 'মিশর',
    'eh'  => "পশ্চিমী\ সাহারা",
    'er'  => 'ইরিত্রিয়া',
    'es'  => 'স্পেন',
    'et'  => 'ইফিওপিয়া',
    'eu'  => "ইউরোপীয়\ ইউনিয়ন",
    'fi'  => 'ফিন্ল্যাণ্ড',
    'fj'  => 'ফিজি',
    'fk'  => "ফকল্যান্ড\ আইল্যান্ড\ \[\ ইসল্যাস\ মাসভেনিস\]",
    'fm'  => 'মাইক্রোনেশিয়া',
    'fo'  => "ফ্যারও\ দ্বীপপুঞ্জ",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'ফ্রান্স',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'গ্যাবন',
    'gb'  => 'গ্রেটবৃটেন',
    'gd'  => 'গ্রেনাডা',
    'ge'  => 'জর্জিয়া',
    'gf'  => "ফরাসী\ গায়ানা",
    'gg'  => 'গ্রাঞ্জি',
    'gh'  => 'ঘানা',
    'gi'  => 'জিব্রাল্টার',
    'gl'  => 'গ্রীনল্যান্ড',
    'gm'  => 'গাম্বিয়া',
    'gn'  => 'গিনি',
    'gp'  => 'গুয়াদেলৌপ',
    'gq'  => "নিরক্ষীয়\ গিনি",
    'gr'  => 'গ্রীস্',
    'gs'  => "দক্ষিণ\ জর্জিয়া\ ও\ দক্ষিণ\ স্যান্ডউইচ\ দ্বীপপুঞ",
    'gt'  => 'গোয়াটিমালা',
    'gu'  => 'গুয়াম',
    'gw'  => "গিনি\-বিসাউ",
    'gy'  => 'গিয়ানা',
    'hk'  => 'হংকং',
    'hm'  => "হার্ড\ দ্বীপ\ এবং\ ম্যাকডোনাল্ড\ দ্বীপপুঞ্জ",
    'hn'  => 'হণ্ডুরাস',
    'hr'  => 'ক্রোয়েশিয়া',
    'ht'  => 'হাইতি',
    'hu'  => 'হাঙ্গেরি',
    'ic'  => "ক্যানারি\ দ্বীপপুঞ্জ",
    'id'  => 'ইন্দোনেশিয়া',
    'ie'  => 'আয়ার্লণ্ড',
    'il'  => 'ইস্রায়েল',
    'im'  => 'ম্যানদ্বীপ',
    'in'  => 'ভারত',
    'io'  => "ব্রিটিশ\ ভারত\ মহাসাগরীয়\ অঞ্চল",
    'iq'  => 'ইরাক',
    'ir'  => 'ইরান',
    'is'  => 'আইসলণ্ড',
    'it'  => 'ইতালী',
    'je'  => 'জার্সি',
    'jm'  => 'জ্যামেকা',
    'jo'  => 'জর্ডন',
    'jp'  => 'জাপান',
    'jt'  => "Johnston\ Island",
    'ke'  => 'কেনিয়া',
    'kg'  => 'কির্গিজিয়া',
    'kh'  => 'কাম্বোজ',
    'ki'  => 'কিরিবাতি',
    'km'  => 'কমোরোস',
    'kn'  => "সেন্ট\ কিটস\ ও\ নেভিস",
    'kp'  => "উত্তর\ কোরিয়া",
    'kr'  => "দক্ষিণ\ কোরিয়া",
    'kw'  => 'কুয়েত',
    'ky'  => "কেম্যান\ দ্বীপপুঞ্জ",
    'kz'  => 'কাজাকস্থান',
    'la'  => 'লাওস',
    'lb'  => 'লেবানন',
    'lc'  => "সেন্ট\ লুসিয়া",
    'li'  => 'লিচেনস্টেইন',
    'lk'  => 'শ্রীলঙ্কা',
    'lr'  => 'লাইবেরিয়া',
    'ls'  => 'লেসোথো',
    'lt'  => 'লিত্ভা',
    'lu'  => 'লাক্সেমবার্গ',
    'lv'  => 'লাত্ভিয়া',
    'ly'  => 'লিবিয়া',
    'ma'  => 'মোরক্কো',
    'mc'  => 'মোনাকো',
    'md'  => 'মোল্দাভিয়া',
    'me'  => 'মন্টিনিগ্রো',
    'mf'  => "সেন্ট\ মার্টিন",
    'mg'  => 'মাদাগাস্কার',
    'mh'  => "মার্শাল\ দ্বীপপুঞ্জ",
    'mi'  => "Midway\ Islands",
    'mk'  => "মেসিডোনিয়া\[FYROM\]",
    'ml'  => 'মালি',
    'mm'  => 'মায়ানমার',
    'mn'  => 'মঙ্গোলিয়া',
    'mo'  => 'ম্যাকাও',
    'mp'  => "উত্তরাঞ্চলীয়\ মারিয়ানা\ দ্বীপপুঞ্জ",
    'mq'  => 'মার্টিনিক',
    'mr'  => 'মরিতানিয়া',
    'ms'  => 'মন্টসেরাট',
    'mt'  => 'মাল্টা',
    'mu'  => 'মরিশাস',
    'mv'  => 'মালদ্বীপ',
    'mw'  => 'মালাউই',
    'mx'  => 'মক্সিকো',
    'my'  => 'মাল্যাশিয়া',
    'mz'  => 'মোজাম্বিক',
    'na'  => 'নামিবিয়া',
    'nc'  => "নিউ\ ক্যালেডোনিয়া",
    'ne'  => 'নাইজার',
    'nf'  => "নিরফোক\ দ্বীপ",
    'ng'  => 'নাইজেরিয়া',
    'ni'  => 'নিকারাগুয়া',
    'nl'  => 'হলণ্ড',
    'no'  => 'নরওয়ে',
    'np'  => 'নেপাল',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'নাউরু',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'নিউয়ে',
    'nz'  => "নিউ\ জিলণ্ড",
    'om'  => 'ওমান',
    'pa'  => 'পানামা',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'পিরু',
    'pf'  => "ফরাসী\ পলিনেশিয়া",
    'pg'  => "পাপুয়া\ নিউ\ গিনি",
    'ph'  => 'ফিলিপাইন',
    'pk'  => 'পাকিস্তান',
    'pl'  => 'পোল্যাণ্ড',
    'pm'  => "সেন্ট\ পিয়ের\ ও\ মিকুয়েলন",
    'pn'  => 'পিটকেয়ার্ন',
    'pr'  => 'পুয়ের্টোরিকো',
    'ps'  => "ফিলিস্তিন\ অঞ্চল",
    'pt'  => 'পর্তুগাল',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'পালাউ',
    'py'  => 'প্যারাগোয়ে',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'কাতার',
    'qo'  => "আউটলাইনিং\ ওসানিয়া",
    're'  => 'রিইউনিয়ন',
    'ro'  => 'রুমানিয়া',
    'rs'  => 'সারবিয়া',
    'ru'  => 'রাশিয়া',
    'rw'  => 'রুয়ান্ডা',
    'sa'  => "সাউদি\ আরব",
    'sb'  => "সলোমন\ দ্বীপপুঞ্জ",
    'sc'  => 'সিসিলি',
    'sd'  => 'সুদান',
    'se'  => 'সুইডেন',
    'sg'  => 'সিঙ্গাপুর',
    'sh'  => "সেন্ট\ হেলেনা",
    'si'  => 'স্লোভানিয়া',
    'sj'  => "স্বালবার্ড\ ও\ জান\ মেয়েন",
    'sk'  => 'শ্লোভাকিয়া',
    'sl'  => 'সিয়েরালিওন',
    'sm'  => "সান\ মারিনো",
    'sn'  => 'সেনেগাল',
    'so'  => 'সোমালি',
    'sr'  => 'সুরিনাম',
    'st'  => "সাওটোমা\ ও\ প্রিন্সিপি",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "এল\ সালভেদর",
    'sy'  => 'সিরিয়া',
    'sz'  => 'সোয়াজিল্যান্ড',
    'ta'  => "ট্রিস্টান\ ডা\ কুনা",
    'tc'  => "তুর্কস\ ও\ কাইকোস\ দ্বীপপুঞ্জ",
    'td'  => 'চাদ',
    'tf'  => "ফরাসী\ দক্ষিণাঞ্চল",
    'tg'  => 'টোগো',
    'th'  => 'থাই',
    'tj'  => 'তাজিকস্থান',
    'tk'  => 'টোকেলাউ',
    'tl'  => "পূর্ব\ টিমোর",
    'tm'  => 'তুর্কমেনিয়া',
    'tn'  => 'টিউনিস্',
    'to'  => 'টোঙ্গা',
    'tr'  => 'তুরস্ক',
    'tt'  => "ত্রিনিনাদ\ ও\ টোব্যাগো",
    'tv'  => 'টুভালু',
    'tw'  => 'তাইওয়ান',
    'tz'  => 'তাঞ্জানিয়া',
    'ua'  => 'ইউক্রেইন',
    'ug'  => 'উগান্ডা',
    'um'  => "যুক্তরাষ্ট্রের\ ক্ষুদ্র\ ও\ পার্শ্ববর্তী\ দ্বীপপুঞ্জ",
    'us'  => "মার্কিন\ যুক্তরাষ্ট্র",
    'uy'  => 'উরুগোয়ে',
    'uz'  => 'উজ্বেকিস্থান',
    'va'  => "ভ্যাটিকান\ সিটি",
    'vc'  => "সেন্ট\ ভিনসেন্ট\ ও\ দ্যা\ গ্রেনাডিনস",
    'vd'  => "North\ Vietnam",
    've'  => 'ভেনেজুয়েলা',
    'vg'  => "ব্রিটিশ\ ভার্জিন\ দ্বীপপুঞ্জ",
    'vi'  => "মার্কিন\ ভার্জিন\ দ্বীপপুঞ্জ",
    'vn'  => 'ভিয়েতনাম',
    'vu'  => 'ভানুয়াটু',
    'wf'  => "ওয়ালিস\ ও\ ফুটুনা",
    'wk'  => "Wake\ Island",
    'ws'  => 'সামোয়া',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'ইমেন',
    'yt'  => 'মায়োত্তে',
    'za'  => "দক্ষিণ\ আফ্রিকা",
    'zm'  => 'জাম্বিয়া',
    'zw'  => 'জিম্বাবুয়ে',
    'zz'  => "অজানা\ অথবা\ ভুল\ স্থান",
);

%Locales::DB::Territory::bn::name_to_code = (
    'britishantarcticterritory'                                                                                                            => 'bq',
    'cantonandenderburyislands'                                                                                                            => 'ct',
    'dronningmaudland'                                                                                                                     => 'nq',
    'eastgermany'                                                                                                                          => 'dd',
    'frenchsouthernandantarcticterritories'                                                                                                => 'fq',
    'johnstonisland'                                                                                                                       => 'jt',
    'metropolitanfrance'                                                                                                                   => 'fx',
    'midwayislands'                                                                                                                        => 'mi',
    'neutralzone'                                                                                                                          => 'nt',
    'northvietnam'                                                                                                                         => 'vd',
    'pacificislandstrustterritory'                                                                                                         => 'pc',
    'panamacanalzone'                                                                                                                      => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                                                                                            => 'yd',
    "u\.s\.miscellaneouspacificislands"                                                                                                    => 'pu',
    'unionofsovietsocialistrepublics'                                                                                                      => 'su',
    'wakeisland'                                                                                                                           => 'wk',
    'অজানাঅথবাভুলস্থান'                                                                                  => 'zz',
    'অস্ট্রিয়া'                                                                                                       => 'at',
    'অস্ট্রেলিয়া'                                                                                                 => 'au',
    'অস্ট্রেলিয়াএবংনিউজিল্যান্ড'                                                    => '053',
    'অ্যাসসেনশনআইল্যান্ড'                                                                            => 'ac',
    'আইসলণ্ড'                                                                                                                => 'is',
    'আউটলাইনিংওসানিয়া'                                                                                  => 'qo',
    'আজারবাইজান'                                                                                                       => 'az',
    'আফগানিস্তান'                                                                                                    => 'af',
    'আফ্রিকা'                                                                                                                => '002',
    'আভরিকোস্ট'                                                                                                          => 'ci',
    'আমেরিকানসামোয়া'                                                                                        => 'as',
    'আমেরিকাস'                                                                                                             => '019',
    'আয়ার্লণ্ড'                                                                                                       => 'ie',
    'আরুবা'                                                                                                                      => 'aw',
    'আর্জেণ্টাইনা'                                                                                                 => 'ar',
    'আর্মেনিয়া'                                                                                                       => 'am',
    'আলব্যানিয়া'                                                                                                    => 'al',
    'আলান্ডদ্বীপপুঞ্জ'                                                                                     => 'ax',
    'ইউক্রেইন'                                                                                                             => 'ua',
    'ইউরোপ'                                                                                                                      => 150,
    'ইউরোপীয়ইউনিয়ন'                                                                                        => 'eu',
    'ইকুয়েডর'                                                                                                             => 'ec',
    'ইতালী'                                                                                                                      => 'it',
    'ইন্দোনেশিয়া'                                                                                                 => 'id',
    'ইফিওপিয়া'                                                                                                          => 'et',
    'ইমেন'                                                                                                                         => 'ye',
    'ইরাক'                                                                                                                         => 'iq',
    'ইরান'                                                                                                                         => 'ir',
    'ইরিত্রিয়া'                                                                                                       => 'er',
    'ইস্রায়েল'                                                                                                          => 'il',
    'উগান্ডা'                                                                                                                => 'ug',
    'উজ্বেকিস্থান'                                                                                                 => 'uz',
    'উত্তরআফ্রিকা'                                                                                                 => '015',
    'উত্তরআমেরিক'                                                                                                    => '003',
    'উত্তরকোরিয়া'                                                                                                 => 'kp',
    'উত্তরাঞ্চলীয়আমেরিকা'                                                                         => '021',
    'উত্তরাঞ্চলীয়ইউরোপ'                                                                               => 154,
    'উত্তরাঞ্চলীয়মারিয়ানাদ্বীপপুঞ্জ'                                     => 'mp',
    'উরুগোয়ে'                                                                                                             => 'uy',
    'এন্টার্কটিকা'                                                                                                 => 'aq',
    'এন্টিগুয়াওবারবুডা'                                                                               => 'ag',
    'এলজিরিয়া'                                                                                                          => 'dz',
    'এলসালভেদর'                                                                                                          => 'sv',
    'এশিয়া'                                                                                                                   => 142,
    'এস্তোনিয়া'                                                                                                       => 'ee',
    'এ্যাঙ্গুইলা'                                                                                                    => 'ai',
    'এ্যাঙ্গোলা'                                                                                                       => 'ao',
    'এ্যান্ডোরা'                                                                                                       => 'ad',
    'ওমান'                                                                                                                         => 'om',
    'ওয়ালিসওফুটুনা'                                                                                           => 'wf',
    'ওসানিয়া'                                                                                                             => '009',
    'কঙ্গোdrc'                                                                                                                   => 'cd',
    'কঙ্গোপ্রজাতন্ত্র'                                                                                     => 'cg',
    'কমোরোস'                                                                                                                   => 'km',
    'কাজাকস্থান'                                                                                                       => 'kz',
    'কাতার'                                                                                                                      => 'qa',
    'কানাডা'                                                                                                                   => 'ca',
    'কাম্বোজ'                                                                                                                => 'kh',
    'কিউবা'                                                                                                                      => 'cu',
    'কিরিবাতি'                                                                                                             => 'ki',
    'কির্গিজিয়া'                                                                                                    => 'kg',
    'কুউটাএবংমেলিলা'                                                                                           => 'ea',
    'কুকদ্বীপপুঞ্জ'                                                                                              => 'ck',
    'কুয়েত'                                                                                                                   => 'kw',
    'কেনিয়া'                                                                                                                => 'ke',
    'কেপভার্দে'                                                                                                          => 'cv',
    'কেম্যানদ্বীপপুঞ্জ'                                                                                  => 'ky',
    'কোকোসদ্বীপপুঞ্জ'                                                                                        => 'cc',
    'কোলোম্বিয়া'                                                                                                    => 'co',
    'কোস্টারিকা'                                                                                                       => 'cr',
    'ক্যানারিদ্বীপপুঞ্জ'                                                                               => 'ic',
    'ক্যামেরুন'                                                                                                          => 'cm',
    'ক্যারাবিয়ান'                                                                                                 => '029',
    'ক্রিসমাসদ্বীপ'                                                                                              => 'cx',
    'ক্রোয়েশিয়া'                                                                                                 => 'hr',
    'ক্লিপারটনআইল্যান্ড'                                                                               => 'cp',
    'গাম্বিয়া'                                                                                                          => 'gm',
    'গিনি'                                                                                                                         => 'gn',
    'গিনিবিসাউ'                                                                                                          => 'gw',
    'গিয়ানা'                                                                                                                => 'gy',
    'গুয়াদেলৌপ'                                                                                                       => 'gp',
    'গুয়াম'                                                                                                                   => 'gu',
    'গোয়াটিমালা'                                                                                                    => 'gt',
    'গ্যাবন'                                                                                                                   => 'ga',
    'গ্রাঞ্জি'                                                                                                             => 'gg',
    'গ্রীনল্যান্ড'                                                                                                 => 'gl',
    'গ্রীস্'                                                                                                                   => 'gr',
    'গ্রেটবৃটেন'                                                                                                       => 'gb',
    'গ্রেনাডা'                                                                                                             => 'gd',
    'ঘানা'                                                                                                                         => 'gh',
    'চাদ'                                                                                                                            => 'td',
    'চিলি'                                                                                                                         => 'cl',
    'চীন'                                                                                                                            => 'cn',
    'চেকপ্রজাতন্ত্র'                                                                                           => 'cz',
    'চেকোস্লোভাকিয়া'                                                                                        => 200,
    'চ্যানেলদ্বীপপুঞ্জ'                                                                                  => 830,
    'জর্জিয়া'                                                                                                             => 'ge',
    'জর্ডন'                                                                                                                      => 'jo',
    'জাপান'                                                                                                                      => 'jp',
    'জাম্বিয়া'                                                                                                          => 'zm',
    'জার্মানি'                                                                                                             => 'de',
    'জার্সি'                                                                                                                   => 'je',
    'জিবুতি'                                                                                                                   => 'dj',
    'জিব্রাল্টার'                                                                                                    => 'gi',
    'জিম্বাবুয়ে'                                                                                                    => 'zw',
    'জ্যামেকা'                                                                                                             => 'jm',
    'টিউনিস্'                                                                                                                => 'tn',
    'টুভালু'                                                                                                                   => 'tv',
    'টোকেলাউ'                                                                                                                => 'tk',
    'টোগো'                                                                                                                         => 'tg',
    'টোঙ্গা'                                                                                                                   => 'to',
    'ট্রিস্টানডাকুনা'                                                                                        => 'ta',
    'ডেনমার্ক'                                                                                                             => 'dk',
    'ডোমিনিকা'                                                                                                             => 'dm',
    'ডোমেনিকানপ্রজাতন্ত্র'                                                                         => 'do',
    'তাইওয়ান'                                                                                                             => 'tw',
    'তাজিকস্থান'                                                                                                       => 'tj',
    'তাঞ্জানিয়া'                                                                                                    => 'tz',
    'তুরস্ক'                                                                                                                   => 'tr',
    'তুর্কমেনিয়া'                                                                                                 => 'tm',
    'তুর্কসওকাইকোসদ্বীপপুঞ্জ'                                                                => 'tc',
    'ত্রিনিনাদওটোব্যাগো'                                                                               => 'tt',
    'থাই'                                                                                                                            => 'th',
    'দক্ষিণআফ্রিকা'                                                                                              => 'za',
    'দক্ষিণকোরিয়া'                                                                                              => 'kr',
    'দক্ষিণজর্জিয়াওদক্ষিণস্যান্ডউইচদ্বীপপুঞ'                => 'gs',
    'দক্ষিণাঞ্চলীয়আফ্রিকা'                                                                      => '018',
    'দক্ষিণাঞ্চলীয়ইউরোপ'                                                                            => '039',
    'দক্ষিণাঞ্চলীয়এশিয়া'                                                                         => '034',
    'দক্ষিনআমেরিকা'                                                                                              => '005',
    'দক্ষিনপূর্বএশিয়া'                                                                                  => '035',
    'দক্ষিনমধ্যএশিয়া'                                                                                     => '062',
    'দিয়েগোগার্সিয়া'                                                                                     => 'dg',
    'নরওয়ে'                                                                                                                   => 'no',
    'নাইজার'                                                                                                                   => 'ne',
    'নাইজেরিয়া'                                                                                                       => 'ng',
    'নাউরু'                                                                                                                      => 'nr',
    'নামিবিয়া'                                                                                                          => 'na',
    'নিউক্যালেডোনিয়া'                                                                                     => 'nc',
    'নিউজিলণ্ড'                                                                                                          => 'nz',
    'নিউয়ে'                                                                                                                   => 'nu',
    'নিকারাগুয়া'                                                                                                    => 'ni',
    'নিরক্ষীয়গিনি'                                                                                              => 'gq',
    'নিরফোকদ্বীপ'                                                                                                    => 'nf',
    'নেদারল্যান্ডসএ্যান্টিলিস'                                                             => 'an',
    'নেপাল'                                                                                                                      => 'np',
    'পর্তুগাল'                                                                                                             => 'pt',
    'পলিনেশিয়া'                                                                                                       => '061',
    'পশ্চিমাঞ্চলীয়আফ্রিকা'                                                                      => '011',
    'পশ্চিমাঞ্চলীয়ইউরোপ'                                                                            => 155,
    'পশ্চিমাঞ্চলীয়এশিয়া'                                                                         => 145,
    'পশ্চিমীসাহারা'                                                                                              => 'eh',
    'পাকিস্তান'                                                                                                          => 'pk',
    'পানামা'                                                                                                                   => 'pa',
    'পাপুয়ানিউগিনি'                                                                                           => 'pg',
    'পালাউ'                                                                                                                      => 'pw',
    'পিটকেয়ার্ন'                                                                                                    => 'pn',
    'পিরু'                                                                                                                         => 'pe',
    'পুয়ের্টোরিকো'                                                                                              => 'pr',
    'পূর্বআফ্রিকা'                                                                                                 => '014',
    'পূর্বইউরোপ'                                                                                                       => 151,
    'পূর্বএশিয়া'                                                                                                    => '030',
    'পূর্বটিমোর'                                                                                                       => 'tl',
    'পৃথিবী'                                                                                                                   => '001',
    'পোল্যাণ্ড'                                                                                                          => 'pl',
    'প্যারাগোয়ে'                                                                                                    => 'py',
    'ফকল্যান্ডআইল্যান্ডইসল্যাসমাসভেনিস'                                  => 'fk',
    'ফরাসীগায়ানা'                                                                                                 => 'gf',
    'ফরাসীদক্ষিণাঞ্চল'                                                                                     => 'tf',
    'ফরাসীপলিনেশিয়া'                                                                                        => 'pf',
    'ফিজি'                                                                                                                         => 'fj',
    'ফিন্ল্যাণ্ড'                                                                                                    => 'fi',
    'ফিলিপাইন'                                                                                                             => 'ph',
    'ফিলিস্তিনঅঞ্চল'                                                                                           => 'ps',
    'ফ্যারওদ্বীপপুঞ্জ'                                                                                     => 'fo',
    'ফ্রান্স'                                                                                                                => 'fr',
    'বতসোয়ানা'                                                                                                          => 'bw',
    'বসনিয়াওহার্জেগোভিনা'                                                                         => 'ba',
    'বাংলাদেশ'                                                                                                             => 'bd',
    'বারবাদোস'                                                                                                             => 'bb',
    'বারমুডা'                                                                                                                => 'bm',
    'বাহরাইন'                                                                                                                => 'bh',
    'বাহামাদ্বীপপুঞ্জ'                                                                                     => 'bs',
    'বুরকিনাফাসো'                                                                                                    => 'bf',
    'বুরুন্ডি'                                                                                                             => 'bi',
    'বুলগেরিয়া'                                                                                                       => 'bg',
    'বেনিন'                                                                                                                      => 'bj',
    'বেলজিয়াম'                                                                                                          => 'be',
    'বেলিয'                                                                                                                      => 'bz',
    'বেলোরুশিয়া'                                                                                                    => 'by',
    'বোভেটদ্বীপ'                                                                                                       => 'bv',
    'বোলিভিয়া'                                                                                                          => 'bo',
    'ব্রাজিল'                                                                                                                => 'br',
    'ব্রিটিশভারতমহাসাগরীয়অঞ্চল'                                                       => 'io',
    'ব্রিটিশভার্জিনদ্বীপপুঞ্জ'                                                             => 'vg',
    'ব্রুনেই'                                                                                                                => 'bn',
    'ভানুয়াটু'                                                                                                          => 'vu',
    'ভারত'                                                                                                                         => 'in',
    'ভিয়েতনাম'                                                                                                          => 'vn',
    'ভুটান'                                                                                                                      => 'bt',
    'ভেনেজুয়েলা'                                                                                                    => 've',
    'ভ্যাটিকানসিটি'                                                                                              => 'va',
    'মক্সিকো'                                                                                                                => 'mx',
    'মঙ্গোলিয়া'                                                                                                       => 'mn',
    'মধ্যআফ্রিকা'                                                                                                    => '017',
    'মধ্যআফ্রিকানপ্রজাতন্ত্র'                                                                => 'cf',
    'মধ্যআমেরিকা'                                                                                                    => '013',
    'মধ্যএশিয়া'                                                                                                       => 143,
    'মন্টসেরাট'                                                                                                          => 'ms',
    'মন্টিনিগ্রো'                                                                                                    => 'me',
    'মরিতানিয়া'                                                                                                       => 'mr',
    'মরিশাস'                                                                                                                   => 'mu',
    'মাইক্রোনেশিয়া'                                                                                           => 'fm',
    'মাদাগাস্কার'                                                                                                    => 'mg',
    'মায়ানমার'                                                                                                          => 'mm',
    'মায়োত্তে'                                                                                                          => 'yt',
    'মার্কিনভার্জিনদ্বীপপুঞ্জ'                                                             => 'vi',
    'মার্কিনযুক্তরাষ্ট্র'                                                                            => 'us',
    'মার্টিনিক'                                                                                                          => 'mq',
    'মার্শালদ্বীপপুঞ্জ'                                                                                  => 'mh',
    'মালদ্বীপ'                                                                                                             => 'mv',
    'মালাউই'                                                                                                                   => 'mw',
    'মালি'                                                                                                                         => 'ml',
    'মাল্টা'                                                                                                                   => 'mt',
    'মাল্যাশিয়া'                                                                                                    => 'my',
    'মিশর'                                                                                                                         => 'eg',
    'মেসিডোনিয়াfyrom'                                                                                               => 'mk',
    'মোজাম্বিক'                                                                                                          => 'mz',
    'মোনাকো'                                                                                                                   => 'mc',
    'মোরক্কো'                                                                                                                => 'ma',
    'মোল্দাভিয়া'                                                                                                    => 'md',
    'ম্যাকাও'                                                                                                                => 'mo',
    'ম্যানদ্বীপ'                                                                                                       => 'im',
    'ম্যালেনিশাঅঞ্চল'                                                                                        => '057',
    'ম্যালেনেশিয়া'                                                                                              => '054',
    'যুক্তরাষ্ট্রেরক্ষুদ্রওপার্শ্ববর্তীদ্বীপপুঞ্জ' => 'um',
    'রাশিয়া'                                                                                                                => 'ru',
    'রিইউনিয়ন'                                                                                                          => 're',
    'রুমানিয়া'                                                                                                          => 'ro',
    'রুয়ান্ডা'                                                                                                          => 'rw',
    'লাইবেরিয়া'                                                                                                       => 'lr',
    'লাওস'                                                                                                                         => 'la',
    'লাক্সেমবার্গ'                                                                                                 => 'lu',
    'লাত্ভিয়া'                                                                                                          => 'lv',
    'লিচেনস্টেইন'                                                                                                    => 'li',
    'লিত্ভা'                                                                                                                   => 'lt',
    'লিবিয়া'                                                                                                                => 'ly',
    'লেবানন'                                                                                                                   => 'lb',
    'লেসোথো'                                                                                                                   => 'ls',
    'ল্যাটিনআমেরিকাএবংক্যারাবিয়ান'                                              => 419,
    'শ্রীলঙ্কা'                                                                                                          => 'lk',
    'শ্লোভাকিয়া'                                                                                                    => 'sk',
    'সংযুক্তআরবআমিরাত'                                                                                     => 'ae',
    'সলোমনদ্বীপপুঞ্জ'                                                                                        => 'sb',
    'সাইপ্রাস'                                                                                                             => 'cy',
    'সাউদিআরব'                                                                                                             => 'sa',
    'সাওটোমাওপ্রিন্সিপি'                                                                               => 'st',
    'সানমারিনো'                                                                                                          => 'sm',
    'সামোয়া'                                                                                                                => 'ws',
    'সারবিয়া'                                                                                                             => 'rs',
    'সারবিয়ানএবংমন্টেনিগ্রো'                                                                => 'cs',
    'সিঙ্গাপুর'                                                                                                          => 'sg',
    'সিয়েরালিওন'                                                                                                    => 'sl',
    'সিরিয়া'                                                                                                                => 'sy',
    'সিসিলি'                                                                                                                   => 'sc',
    'সুইজর্লণ্ড'                                                                                                       => 'ch',
    'সুইডেন'                                                                                                                   => 'se',
    'সুদান'                                                                                                                      => 'sd',
    'সুরিনাম'                                                                                                                => 'sr',
    'সেনেগাল'                                                                                                                => 'sn',
    'সেন্টকিটসওনেভিস'                                                                                        => 'kn',
    'সেন্টপিয়েরওমিকুয়েলন'                                                                      => 'pm',
    'সেন্টবারথেলিমি'                                                                                           => 'bl',
    'সেন্টভিনসেন্টওদ্যাগ্রেনাডিনস'                                                 => 'vc',
    'সেন্টমার্টিন'                                                                                                 => 'mf',
    'সেন্টলুসিয়া'                                                                                                 => 'lc',
    'সেন্টহেলেনা'                                                                                                    => 'sh',
    'সোমালি'                                                                                                                   => 'so',
    'সোয়াজিল্যান্ড'                                                                                           => 'sz',
    'স্পেন'                                                                                                                      => 'es',
    'স্বাধীনরাষ্ট্রেরকমনওয়েলথ'                                                          => 172,
    'স্বালবার্ডওজানমেয়েন'                                                                         => 'sj',
    'স্লোভানিয়া'                                                                                                    => 'si',
    'হংকং'                                                                                                                         => 'hk',
    'হণ্ডুরাস'                                                                                                             => 'hn',
    'হলণ্ড'                                                                                                                      => 'nl',
    'হাইতি'                                                                                                                      => 'ht',
    'হাঙ্গেরি'                                                                                                             => 'hu',
    'হার্ডদ্বীপএবংম্যাকডোনাল্ডদ্বীপপুঞ্জ'                            => 'hm',
);

1;

