/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class CompositeNoDestAlphaOpImage
extends PointOpImage {
    private RenderedImage alpha1;
    private RenderedImage alpha2;
    private boolean premultiplied;
    private RasterFormatTag[] tags;

    public CompositeNoDestAlphaOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, RenderedImage renderedImage3, RenderedImage renderedImage4, boolean bl) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.alpha1 = renderedImage3;
        this.alpha2 = renderedImage4;
        this.premultiplied = bl;
        this.tags = this.getFormatTags();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor;
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, this.tags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(rasterArray[1], rectangle, this.tags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor4 = new RasterAccessor(this.alpha1.getData(rectangle), rectangle, this.tags[2], this.alpha1.getColorModel());
        RasterAccessor rasterAccessor5 = null;
        if (this.alpha2 == null) {
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[3], this.getColorModel());
        } else {
            rasterAccessor5 = new RasterAccessor(this.alpha2.getData(rectangle), rectangle, this.tags[3], this.alpha2.getColorModel());
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[4], this.getColorModel());
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte[] byArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            byArray4 = rasterAccessor4.getByteDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 0.003921569f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    float f2 = 1.0f - (float)(byArray3[n24] & 0xFF) * f;
                    int n27 = 0;
                    while (n27 < n15) {
                        byArray5[n27][n25 + nArray3[n27]] = (byte)((float)(byArray[n27][n22 + nArray[n27]] & 0xFF) + (float)(byArray2[n27][n23 + nArray2[n27]] & 0xFF) * f2);
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    float f3 = (float)(byArray3[n31] & 0xFF) * f;
                    float f4 = 1.0f - f3;
                    int n34 = 0;
                    while (n34 < n15) {
                        byArray5[n34][n32 + nArray3[n34]] = (byte)((float)(byArray[n34][n29 + nArray[n34]] & 0xFF) * f3 + (float)(byArray2[n34][n30 + nArray2[n34]] & 0xFF) * f4);
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    float f5;
                    float f6;
                    int n42 = byArray3[n38] & 0xFF;
                    float f7 = (float)(byArray4[n39] & 0xFF) * (1.0f - (float)n42 * f);
                    float f8 = (float)n42 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n42 / f8;
                        f5 = f7 / f8;
                    }
                    int n43 = 0;
                    while (n43 < n15) {
                        byArray5[n43][n40 + nArray3[n43]] = (byte)((float)(byArray[n43][n36 + nArray[n43]] & 0xFF) * f6 + (float)(byArray2[n43][n37 + nArray2[n43]] & 0xFF) * f5);
                        ++n43;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 1.5259022E-5f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    float f2 = 1.0f - (float)(sArray3[n24] & 0xFFFF) * f;
                    int n27 = 0;
                    while (n27 < n15) {
                        sArray5[n27][n25 + nArray3[n27]] = (short)((float)(sArray[n27][n22 + nArray[n27]] & 0xFFFF) + (float)(sArray2[n27][n23 + nArray2[n27]] & 0xFFFF) * f2);
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    float f3 = (float)(sArray3[n31] & 0xFFFF) * f;
                    float f4 = 1.0f - f3;
                    int n34 = 0;
                    while (n34 < n15) {
                        sArray5[n34][n32 + nArray3[n34]] = (short)((float)(sArray[n34][n29 + nArray[n34]] & 0xFFFF) * f3 + (float)(sArray2[n34][n30 + nArray2[n34]] & 0xFFFF) * f4);
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    float f5;
                    float f6;
                    int n42 = sArray3[n38] & 0xFFFF;
                    float f7 = (float)(sArray4[n39] & 0xFFFF) * (1.0f - (float)n42 * f);
                    float f8 = (float)n42 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n42 / f8;
                        f5 = f7 / f8;
                    }
                    int n43 = 0;
                    while (n43 < n15) {
                        sArray5[n43][n40 + nArray3[n43]] = (short)((float)(sArray[n43][n36 + nArray[n43]] & 0xFFFF) * f6 + (float)(sArray2[n43][n37 + nArray2[n43]] & 0xFFFF) * f5);
                        ++n43;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 3.051851E-5f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    float f2 = 1.0f - (float)sArray3[n24] * f;
                    int n27 = 0;
                    while (n27 < n15) {
                        sArray5[n27][n25 + nArray3[n27]] = (short)((float)sArray[n27][n22 + nArray[n27]] + (float)sArray2[n27][n23 + nArray2[n27]] * f2);
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    float f3 = (float)sArray3[n31] * f;
                    float f4 = 1.0f - f3;
                    int n34 = 0;
                    while (n34 < n15) {
                        sArray5[n34][n32 + nArray3[n34]] = (short)((float)sArray[n34][n29 + nArray[n34]] * f3 + (float)sArray2[n34][n30 + nArray2[n34]] * f4);
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    float f5;
                    float f6;
                    short s = sArray3[n38];
                    float f7 = (float)sArray4[n39] * (1.0f - (float)s * f);
                    float f8 = (float)s + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)s / f8;
                        f5 = f7 / f8;
                    }
                    int n42 = 0;
                    while (n42 < n15) {
                        sArray5[n42][n40 + nArray3[n42]] = (short)((float)sArray[n42][n36 + nArray[n42]] * f6 + (float)sArray2[n42][n37 + nArray2[n42]] * f5);
                        ++n42;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray6 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            nArray6 = rasterAccessor4.getIntDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray7 = rasterAccessor5.getBandOffsets();
        int[][] nArray8 = rasterAccessor5.getIntDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 4.656613E-10f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    float f2 = 1.0f - (float)nArray5[n24] * f;
                    int n27 = 0;
                    while (n27 < n15) {
                        nArray8[n27][n25 + nArray7[n27]] = (int)((float)nArray2[n27][n22 + nArray[n27]] + (float)nArray4[n27][n23 + nArray3[n27]] * f2);
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    float f3 = (float)nArray5[n31] * f;
                    float f4 = 1.0f - f3;
                    int n34 = 0;
                    while (n34 < n15) {
                        nArray8[n34][n32 + nArray7[n34]] = (int)((float)nArray2[n34][n29 + nArray[n34]] * f3 + (float)nArray4[n34][n30 + nArray3[n34]] * f4);
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    float f5;
                    float f6;
                    int n42 = nArray5[n38];
                    float f7 = (float)nArray6[n39] * (1.0f - (float)n42 * f);
                    float f8 = (float)n42 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n42 / f8;
                        f5 = f7 / f8;
                    }
                    int n43 = 0;
                    while (n43 < n15) {
                        nArray8[n43][n40 + nArray7[n43]] = (int)((float)nArray2[n43][n36 + nArray[n43]] * f6 + (float)nArray4[n43][n37 + nArray3[n43]] * f5);
                        ++n43;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        float[] fArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            fArray4 = rasterAccessor4.getFloatDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    float f = 1.0f - fArray3[n24];
                    int n27 = 0;
                    while (n27 < n15) {
                        fArray5[n27][n25 + nArray3[n27]] = fArray[n27][n22 + nArray[n27]] + fArray2[n27][n23 + nArray2[n27]] * f;
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    float f = fArray3[n31];
                    float f2 = 1.0f - f;
                    int n34 = 0;
                    while (n34 < n15) {
                        fArray5[n34][n32 + nArray3[n34]] = fArray[n34][n29 + nArray[n34]] * f + fArray2[n34][n30 + nArray2[n34]] * f2;
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    float f;
                    float f3;
                    float f4 = fArray3[n38];
                    float f5 = fArray4[n39] * (1.0f - f4);
                    float f6 = f4 + f5;
                    if (f6 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = f4 / f6;
                        f = f5 / f6;
                    }
                    int n42 = 0;
                    while (n42 < n15) {
                        fArray5[n42][n40 + nArray3[n42]] = fArray[n42][n36 + nArray[n42]] * f3 + fArray2[n42][n37 + nArray2[n42]] * f;
                        ++n42;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double[] dArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            int n21 = 0;
            while (n21 < n14) {
                int n22 = n16;
                int n23 = n17;
                int n24 = n18 + n7;
                int n25 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n26 = 0;
                while (n26 < n13) {
                    double d = 1.0 - dArray3[n24];
                    int n27 = 0;
                    while (n27 < n15) {
                        dArray5[n27][n25 + nArray3[n27]] = dArray[n27][n22 + nArray[n27]] + dArray2[n27][n23 + nArray2[n27]] * d;
                        ++n27;
                    }
                    n22 += n2;
                    n23 += n4;
                    n24 += n6;
                    n25 += n12;
                    ++n26;
                }
                ++n21;
            }
        } else if (this.alpha2 == null) {
            int n28 = 0;
            while (n28 < n14) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                int n33 = 0;
                while (n33 < n13) {
                    double d = dArray3[n31];
                    double d2 = 1.0 - d;
                    int n34 = 0;
                    while (n34 < n15) {
                        dArray5[n34][n32 + nArray3[n34]] = dArray[n34][n29 + nArray[n34]] * d + dArray2[n34][n30 + nArray2[n34]] * d2;
                        ++n34;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n12;
                    ++n33;
                }
                ++n28;
            }
        } else {
            int n35 = 0;
            while (n35 < n14) {
                int n36 = n16;
                int n37 = n17;
                int n38 = n18 + n7;
                int n39 = n19 + n10;
                int n40 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                int n41 = 0;
                while (n41 < n13) {
                    double d;
                    double d3;
                    double d4 = dArray3[n38];
                    double d5 = dArray4[n39] * (1.0 - d4);
                    double d6 = d4 + d5;
                    if (d6 == 0.0) {
                        d3 = 0.0;
                        d = 0.0;
                    } else {
                        d3 = d4 / d6;
                        d = d5 / d6;
                    }
                    int n42 = 0;
                    while (n42 < n15) {
                        dArray5[n42][n40 + nArray3[n42]] = dArray[n42][n36 + nArray[n42]] * d3 + dArray2[n42][n37 + nArray2[n42]] * d;
                        ++n42;
                    }
                    n36 += n2;
                    n37 += n4;
                    n38 += n6;
                    n39 += n9;
                    n40 += n12;
                    ++n41;
                }
                ++n35;
            }
        }
    }

    protected synchronized RasterFormatTag[] getFormatTags() {
        RenderedImage[] renderedImageArray;
        if (this.alpha2 == null) {
            renderedImageArray = new RenderedImage[3];
        } else {
            renderedImageArray = new RenderedImage[4];
            renderedImageArray[3] = this.alpha2;
        }
        renderedImageArray[0] = this.getSourceImage(0);
        renderedImageArray[1] = this.getSourceImage(1);
        renderedImageArray[2] = this.alpha1;
        return RasterAccessor.findCompatibleTags(renderedImageArray, this);
    }
}

