use strict;
use warnings;
use File::Find;
use File::Path;
use File::Spec;
use Config qw(%Config);

$| = 1;

print "checking for mlpod2html... ";
my $mlpod2html = do{
	my $mlpod2html = File::Spec->catfile($Config{binexp}, 'mlpod2html');
	-x $mlpod2html ? $mlpod2html : undef;
};
if ($mlpod2html) {
	print "$mlpod2html\n";
}
else {
	print "no\n";
}

my @pod; # [pm, html]

find({
    wanted => sub {
	my $fpath = $_;
	$fpath =~ m!\.pm$! or return;

	my @fname = File::Spec->splitdir($fpath);
	shift @fname; # ..を消す
	shift @fname; # libを消す
	my $fname = pop @fname; # ファイル名を消す
	$fname =~ s/\.pm$/.html/;

	if (@fname) {
	    mkpath([File::Spec->catdir(@fname)]);
	}

	push @pod, [
	    $fpath,
	    File::Spec->catdir(@fname, $fname),
	   ];
    },
    no_chdir => 1,
}, '../lib');
push(@pod,
	 ['../ext/Tripletail-HtmlFilter/HtmlFilter.pm' => 'Tripletail/HtmlFilter.html'],
	 ['policy.pod', 'policy.html'],
	 ['security.pod', 'security.html'],
	 ['tips.pod', 'tips.html'],
);

open my $fh, '>', 'Makefile' or die;
print $fh "# This makefile has been generated by Makefile.PL.\n";
print $fh "# Do not edit by hand.\n";
print $fh "\n";
print $fh "MLPOD2HTML=$mlpod2html\n";
print $fh "MISSING_DIR=http://search.cpan.org/perldoc/\n";
print $fh q{FIXLINK=perl -i -ple 's{perldoc/(.*?)\.html}{$$x=$$1;$$x=~s{/}{::}g;"perldoc/$$x";}eg'}."\n";
print $fh "\n";
print $fh "all: doc\n";
print $fh "\n";
foreach my $pod (@pod) {
    print $fh "$pod->[1]: $pod->[0]\n";
    print $fh "\t\$(MLPOD2HTML) $pod->[0] -o $pod->[1].tmp --poddir=. --missing-dir=http://search.cpan.org/perldoc/ --css=style.css\n";
    print $fh "\t\$(FIXLINK) $pod->[1].tmp\n";
    print $fh "\tmv $pod->[1].tmp $pod->[1]\n";
    print $fh "\n";
}
if ($mlpod2html) {
	print $fh "doc: ".join(' ', map {$_->[1]} @pod)."\n";
}
else {
	print $fh "doc:\n";
	print $fh "\t\@echo Note: html doc will not be generated for lack of mlpod2html.\n"
}
print $fh "\n";
print $fh "test test_dynamic test_static: \n";
print $fh "\n";
print $fh "clean: \n";
print $fh "\trm -f Makefile\n";
if ($mlpod2html) {
	foreach my $pod (@pod) {
		print $fh "\trm -f $pod->[1]\n";
	}
}
print $fh "\n";
print $fh "touch:\n";
print $fh "\ttouch -t 01010000 \`find -name '*.html'\`\n";
print $fh "rebuild: touch all\n";
print $fh "\n";
print $fh ".PHONY: all doc test test_dynamic test_static clean\n";
close $fh;
