# notify.pl #

use strict;
use warnings FATAL => 'all';
use autodie ':all';

use FindBin qw{};
use Getopt::Long qw{};

use blib "$FindBin::Bin/../blib";
use Systemd::Daemon qw{ notify };

my $sleep = 0;
my $exit  = 0;
Getopt::Long::GetOptions(
    'sleep=i'   => \$sleep,
    'exit=i'    => \$exit,
) or die;
@ARGV % 2 == 0 or die;

#   `join` or `map` applied to `@ARGV` cause Perl diagnostics:
#       Insecure dependency in eval_sv() while running with -T switch
my @args = @ARGV;
my $notify = 'notify( ';
while ( @args ) {
    $notify .= shift( @args ) . ' => ' . shift( @args ) . ( @args ? ', ' : ' ' );
}; # while
$notify .= ')';
my $rc = notify( @ARGV );
$notify .= ' => ' . $rc;
STDERR->print( "# ", $notify, "\n" );

sleep( $sleep );
exit( $exit );

# end of file #
