/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNoteBox
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final UStroke stroke;

    public ComponentRoseNoteBox(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, Display display, ISkinSimple iSkinSimple, double d, UStroke uStroke) {
        super(display, htmlColor3, uFont, HorizontalAlignment.LEFT, 4, 4, 4, iSkinSimple, 0.0, false);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
        this.deltaShadow = d;
        this.stroke = uStroke;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    public double getPaddingX() {
        return 5.0;
    }

    public double getPaddingY() {
        return 5.0;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        uGraphic = uGraphic.apply(new UChangeBackColor(this.back)).apply(new UChangeColor(this.foregroundColor));
        uGraphic = uGraphic.apply(this.stroke);
        URectangle uRectangle = new URectangle(n2, n);
        uRectangle.setDeltaShadow(this.deltaShadow);
        uGraphic.draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }
}

