# Generated by default/object.tt
package Paws::NimbleStudio::StreamingSession;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Ec2InstanceType => (is => 'ro', isa => 'Str', request_name => 'ec2InstanceType', traits => ['NameInRequest']);
  has LaunchProfileId => (is => 'ro', isa => 'Str', request_name => 'launchProfileId', traits => ['NameInRequest']);
  has SessionId => (is => 'ro', isa => 'Str', request_name => 'sessionId', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StatusCode => (is => 'ro', isa => 'Str', request_name => 'statusCode', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has StreamingImageId => (is => 'ro', isa => 'Str', request_name => 'streamingImageId', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::NimbleStudio::Tags', request_name => 'tags', traits => ['NameInRequest']);
  has TerminateAt => (is => 'ro', isa => 'Str', request_name => 'terminateAt', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);
  has UpdatedBy => (is => 'ro', isa => 'Str', request_name => 'updatedBy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::StreamingSession

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::StreamingSession object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UpdatedBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::StreamingSession object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the resource.


=head2 CreatedAt => Str

The Unix epoch timestamp in seconds for when the resource was created.


=head2 CreatedBy => Str

The user ID of the user that created the streaming session.


=head2 Ec2InstanceType => Str

The EC2 Instance type used for the streaming session.


=head2 LaunchProfileId => Str

The ID of the launch profile used to control access from the streaming
session.


=head2 SessionId => Str

The session ID.


=head2 State => Str

The current state.


=head2 StatusCode => Str

The status code.


=head2 StatusMessage => Str

The status message for the streaming session.


=head2 StreamingImageId => Str

The ID of the streaming image.


=head2 Tags => L<Paws::NimbleStudio::Tags>

A collection of labels, in the form of key:value pairs, that apply to
this resource.


=head2 TerminateAt => Str

The time the streaming session will automatically terminate if not
terminated by the user.


=head2 UpdatedAt => Str

The Unix epoch timestamp in seconds for when the resource was updated.


=head2 UpdatedBy => Str

The user ID of the user that most recently updated the resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

