# Generated by default/object.tt
package Paws::NetworkFirewall::RulesSource;
  use Moose;
  has RulesSourceList => (is => 'ro', isa => 'Paws::NetworkFirewall::RulesSourceList');
  has RulesString => (is => 'ro', isa => 'Str');
  has StatefulRules => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::StatefulRule]');
  has StatelessRulesAndCustomActions => (is => 'ro', isa => 'Paws::NetworkFirewall::StatelessRulesAndCustomActions');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RulesSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RulesSource object:

  $service_obj->Method(Att1 => { RulesSourceList => $value, ..., StatelessRulesAndCustomActions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RulesSource object:

  $result = $service_obj->Method(...);
  $result->Att1->RulesSourceList

=head1 DESCRIPTION

The stateless or stateful rules definitions for use in a single rule
group. Each rule group requires a single C<RulesSource>. You can use an
instance of this for either stateless rules or stateful rules.

=head1 ATTRIBUTES


=head2 RulesSourceList => L<Paws::NetworkFirewall::RulesSourceList>

Stateful inspection criteria for a domain list rule group.


=head2 RulesString => Str

Stateful inspection criteria, provided in Suricata compatible intrusion
prevention system (IPS) rules. Suricata is an open-source network IPS
that includes a standard rule-based language for network traffic
inspection.

These rules contain the inspection criteria and the action to take for
traffic that matches the criteria, so this type of rule group doesn't
have a separate action setting.


=head2 StatefulRules => ArrayRef[L<Paws::NetworkFirewall::StatefulRule>]

The 5-tuple stateful inspection criteria. This contains an array of
individual 5-tuple stateful rules to be used together in a stateful
rule group.


=head2 StatelessRulesAndCustomActions => L<Paws::NetworkFirewall::StatelessRulesAndCustomActions>

Stateless inspection criteria to be used in a stateless rule group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

