package Net::Amazon::EMR::InstanceGroupConfig;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

has 'BidPrice' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                    coerce => 1,
                );

has 'Configurations' => ( is => 'ro', 
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofConfiguration',
                          coerce => 1,
                      );

has 'EbsConfiguration' => ( is => 'ro', 
                            isa => 'Net::Amazon::EMR::Type::EbsConfiguration',
                            coerce => 1,
                      );
has 'InstanceCount' => ( is => 'ro', 
                         isa => 'Int',
                         required => 1,
                     );

subtype 'Net::Amazon::EMR::Type::InstanceGroupConfig::Role' => as 'Str' => where { m/^(?:MASTER | CORE | TASK)$/x };
has 'InstanceRole' => ( is => 'ro', 
                        isa => 'Net::Amazon::EMR::Type::InstanceGroupConfig::Role',
                        required => 1,
                    );


has 'InstanceType' => ( is => 'ro',
                        isa => 'Net::Amazon::EMR::Type::NonEmptyConstrainedStr',
                        coerce => 1,
                        required => 1,
                    );

subtype 'Net::Amazon::EMR::Type::InstanceGroupConfig::Market' => as 'Str' => where { m/^(?:ON_DEMAND | SPOT)$/x };

has 'Market' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::InstanceGroupConfig::Market',
              );

has 'Name' => ( is => 'ro', 
                isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                coerce => 1,
            );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceGroupConfig

=head1 DESCRIPTION

Implements the InstanceGroupConfig data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceGroupConfig.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
