# Generated by default/object.tt
package Paws::Lightsail::ContainerServiceDeployment;
  use Moose;
  has Containers => (is => 'ro', isa => 'Paws::Lightsail::ContainerMap', request_name => 'containers', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has PublicEndpoint => (is => 'ro', isa => 'Paws::Lightsail::ContainerServiceEndpoint', request_name => 'publicEndpoint', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has Version => (is => 'ro', isa => 'Int', request_name => 'version', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServiceDeployment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServiceDeployment object:

  $service_obj->Method(Att1 => { Containers => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServiceDeployment object:

  $result = $service_obj->Method(...);
  $result->Att1->Containers

=head1 DESCRIPTION

Describes a container deployment configuration of an Amazon Lightsail
container service.

A deployment specifies the settings, such as the ports and launch
command, of containers that are deployed to your container service.

=head1 ATTRIBUTES


=head2 Containers => L<Paws::Lightsail::ContainerMap>

An object that describes the configuration for the containers of the
deployment.


=head2 CreatedAt => Str

The timestamp when the deployment was created.


=head2 PublicEndpoint => L<Paws::Lightsail::ContainerServiceEndpoint>

An object that describes the endpoint of the deployment.


=head2 State => Str

The state of the deployment.

A deployment can be in one of the following states:

=over

=item *

C<Activating> - The deployment is being created.

=item *

C<Active> - The deployment was successfully created, and it's currently
running on the container service. The container service can have only
one deployment in an active state at a time.

=item *

C<Inactive> - The deployment was previously successfully created, but
it is not currently running on the container service.

=item *

C<Failed> - The deployment failed. Use the C<GetContainerLog> action to
view the log events for the containers in the deployment to try to
determine the reason for the failure.

=back



=head2 Version => Int

The version number of the deployment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

