# Generated by default/object.tt
package Paws::SageMaker::NeoVpcConfig;
  use Moose;
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Subnets => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::NeoVpcConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::NeoVpcConfig object:

  $service_obj->Method(Att1 => { SecurityGroupIds => $value, ..., Subnets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::NeoVpcConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->SecurityGroupIds

=head1 DESCRIPTION

The VpcConfig configuration object that specifies the VPC that you want
the compilation jobs to connect to. For more information on controlling
access to your Amazon S3 buckets used for compilation job, see Give
Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon
VPC (https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> SecurityGroupIds => ArrayRef[Str|Undef]

The VPC security group IDs. IDs have the form of C<sg-xxxxxxxx>.
Specify the security groups for the VPC that is specified in the
C<Subnets> field.


=head2 B<REQUIRED> Subnets => ArrayRef[Str|Undef]

The ID of the subnets in the VPC that you want to connect the
compilation job to for accessing the model in Amazon S3.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

