package Dist::Zilla::PluginBundle::BerryGenomics;
use Moose;
use namespace::autoclean;

our $VERSION = '0.0.1'; # VERSION
# ABSTRACT: Dist::Zilla::PluginBundle for BerryGenomics Bioinformatics Department

with 'Dist::Zilla::Role::PluginBundle::Easy';
has installer => (
  is => 'ro',
  isa => 'Str',
  lazy => 1,
  default => sub { $_[0]->payload->{installer} || 'ModuleBuild' },
);

sub configure {
  my $self = shift;
  # Firstly, import plugins from @Basic bundle;
  $self->add_plugins(qw(MetaJSON MetaYAML License ExtraTests ExecDir ShareDir Manifest ManifestSkip));
  # Secondly, plugin FakeRelease;
  $self->add_plugins(qw(TestRelease FakeRelease));
  # 3. add installer prereqs
  my @installer_accepts = qw( MakeMaker MakeMaker::IncShareDir ModuleBuild ModuleBuildTiny );
  my %accepts = map { $_ => 1 } @installer_accepts;
  unless ($accepts{$self->installer}) {
    die sprintf("Unknown installer: '%s'. " .
      "Acceptable values are MakeMaker, ModuleBuild and ModuleBuildTiny\n",
      $self->installer);
  }
  $self->add_plugins( $self->installer );
  # 4. some helper plugins
  $self->add_plugins( qw(InstallGuide OurPkgVersion PodWeaver ReadmeFromPod PodSyntaxTests) );
  $self->add_plugins(
    # 5. Readme.md
    [ 'ReadmeAnyFromPod', { type => 'markdown', filename => 'README.md', location => 'root' } ],
    [ 'CopyFilesFromBuild', { copy => [ 'LICENSE' ] } ],
    [ 'MetaNoIndex', { directory => [ qw( t xt inc share eg examples ) ] } ],
  );

  my @dirty_files = ('dist.ini', 'Changes', 'META.json', 'README.md', 'LICENSE');
  # 6. Git
  $self->add_plugins(
    [ 'Git::GatherDir', { exclude_filename => \@dirty_files, include_dotfiles => 1 } ],
    [ 'Git::Check', { allow_dirty => \@dirty_files, untracked_files => 'warn' } ],
    [ 'Git::Commit', { allow_dirty => \@dirty_files, commit_msg => 'Auto commited by dzil with version %v at %d%n%n%c%n' } ],
    [ 'Git::CommitBuild', { release_branch => 'release/%b', release_message => 'Release %v of %h (on %b)'} ],
    [ 'Git::Tag', { tag_format => '%v', tag_message => 'Auto tagged by dzil release(%v)' } ],
    [ 'Git::Push', { remotes_must_exist => 0 } ],
    [ 'Git::NextVersion', { first_version => '0.0.1', version_by_branch => 1, version_regexp => ^v?(\d+(\.\d+){0,2})$}],
    [ 'ChangelogFromGit::CPAN::Changes', { tag_regexp => 'semantic', group_by_author => 1 } ],
    [ 'Run::BeforeBuild' { run => 'git checkout Changes' } ],
    [ 'Run::AfterRelease', { run => 'mkdir -p release 2>/dev/null; cp %n-%v.tar.gz release/ -f'} ],
  );
  $self->add_plugins( [ 'AutoPrereqs' ] );
}
__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::PluginBundle::BerryGenomics - Dist::Zilla::PluginBundle for BerryGenomics Bioinformatics Department

=head1 VERSION

version 0.0.1

=head1 AUTHOR

Huo Linhe <huolinhe@berrygenomics.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Berry Genomics.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
