#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More;

plan skip_all => "Disabled" if $ENV{NO_JIRA_CHECK};

my @commits = split /\n/, <<'EOC';
20ff519f (HEAD -> master) PERL-947 Eliminate circular references
95527a86 (sandbox/master, origin/master, origin/HEAD, dagolden/master) PERL-875 Improve transaction test diagnostics
0fd22625 PERL-937 Check nested clusterTime field for validity
9162d1d3 PERL-875 Implement transaction spec
cc7f238b PERL-918 Update retryable-writes test specs
b137116c PERL-937 Ignore cluster time documents that don't have a timestamp
bee77e66 PERL-937 Ignore empty clusterTime documents
b0c9cc86 PERL-912 PERL-936 PERL-940 Update change streams
d99fad8e PERL-890 command monitoring updates
9687f61a PERL-937 Gossip cluster time during SDAM
73ff2ca6 PERL-859 limit aggregation examples to MongoDB 3.6
4aef9055 PERL-859 Add examples for aggregate, run_command and indexing
380e8177 PERL-941 Bump BSON prereq to v1.6.5
5a1c9cdc PERL-856 Deprecate md5 field in GridFS file documents

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}

done_testing();
