/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Pair;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingEval
extends AbstractEval {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MORE = false;
    private final Lexicon lex;
    private final boolean useTag;

    @Override
    protected Set<?> makeObjects(Tree tree) {
        Sentence<TaggedWord> twList = this.useTag ? TaggingEval.myExtractor(tree) : tree.taggedYield();
        HashSet<Pair<Integer, WordTag>> set = new HashSet<Pair<Integer, WordTag>>();
        int sz = twList.size();
        for (int i = 0; i < sz; ++i) {
            TaggedWord tw = (TaggedWord)twList.get(i);
            Pair<Integer, WordTag> positionWT = new Pair<Integer, WordTag>(i, new WordTag(tw.value(), tw.tag()));
            set.add(positionWT);
        }
        return set;
    }

    public TaggingEval(String str) {
        this(str, true, null);
    }

    public TaggingEval(String str, boolean runningAverages, Lexicon lex) {
        this(str, runningAverages, lex, false);
    }

    public TaggingEval(String str, boolean runningAverages, Lexicon lex, boolean useTag) {
        super(str, runningAverages);
        this.lex = lex;
        this.useTag = useTag;
    }

    private static Sentence<TaggedWord> myExtractor(Tree t) {
        return TaggingEval.myExtractor(t, new Sentence<TaggedWord>());
    }

    private static Sentence<TaggedWord> myExtractor(Tree t, Sentence<TaggedWord> ty) {
        Tree[] kids = t.children();
        if (kids.length == 1 && kids[0].isLeaf()) {
            if (t.label() instanceof HasTag) {
                ty.add(new TaggedWord(kids[0].label().value(), ((HasTag)((Object)t.label())).tag()));
            } else {
                ty.add(new TaggedWord(kids[0].label().value(), t.label().value()));
            }
        } else {
            for (int i = 0; i < kids.length; ++i) {
                TaggingEval.myExtractor(kids[i], ty);
            }
        }
        return ty;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        Sentence<TaggedWord> sGold = gold.taggedYield();
        Sentence<TaggedWord> sGuess = this.useTag ? TaggingEval.myExtractor(guess) : guess.taggedYield();
        if (sGuess.size() != sGold.size()) {
            pw.println("Warning: yield length differs:");
            pw.println("Guess: " + sGuess);
            pw.println("Gold:  " + sGold);
        }
        super.evaluate(guess, gold, pw);
    }
}

