#!/usr/bin/perl

use Test::More tests => 3;
use Data::Dump qw(dump);

use lib 'lib';

BEGIN {
	use_ok( 'Biblio::RFID::SmartX' );
}

my $tags =
[ [
	"\xde\xad\xbe\xbe\xfc\x38\x02\x00\x00\x00\x00\x00\x21\x07\x44\x00",
	"\x00\x01\x1d\x58\x1e\x58\x1f\x58\x29\x58\x00\x00\x00\x00\x00\x00",
	"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	undef,
	"\x99\x88\x77\x66\x55\x44\x33\x22\x11\x00\x00\x12\x22\x22\x22\x21",
	"\x32\x30\x31\x33\x34\x35\x36\x31\x91\x11\x11\x11\x11\x90\x6d\x00",
	"\x33\x33\x33\x00\x00\x00\x00\x06\x00\x30\x32\x53\x52\x43\x45\x04",
],[
	"\x01\x02\x03\x04\xdc\x38\x02\x00\x00\x00\x00\x00\x21\x07\x44\x00",
	"\x00\x01\x1d\x58\x1e\x58\x1f\x58\x29\x58\x00\x00\x00\x00\x00\x00",
	"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	undef,
	"\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\x00\x21\x11\x11\x11\x12",
	"\x32\x30\x31\x34\x31\x30\x30\x31\x81\x11\x11\x11\x11\x80\x66\x00",
	"\x32\x32\x32\x00\x00\x00\x00\x05\x00\x30\x32\x53\x52\x43\x45\x04",
] ];

foreach my $tag ( @$tags ) {

	ok( $hash = Biblio::RFID::SmartX->to_hash( $tag ), 'to_hash' );
	diag dump $hash;

}

