/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;

final class MlibDFTOpImage
extends UntiledOpImage {
    private int DFTMode;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, EnumeratedParameter enumeratedParameter) {
        int n;
        int n2;
        int n3;
        boolean bl = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        boolean bl2 = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n4 = sampleModel.getNumBands();
        if (bl && n4 != 2 || !bl && n4 != 1) {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage0"));
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n5 = imageLayout2.getWidth(renderedImage);
        int n6 = imageLayout2.getHeight(renderedImage);
        if (n5 == 1 && n6 == 1) {
            n3 = 1;
            n2 = 1;
        } else if (n5 == 1 && n6 > 1) {
            n2 = 1;
            n3 = MathJAI.nextPositivePowerOf2(n6);
        } else if (n5 > 1 && n6 == 1) {
            n2 = MathJAI.nextPositivePowerOf2(n5);
            n3 = 1;
        } else {
            n2 = MathJAI.nextPositivePowerOf2(n5);
            n3 = MathJAI.nextPositivePowerOf2(n6);
        }
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        boolean bl3 = false;
        int n7 = n4;
        if (bl && !bl2) {
            n7 /= 2;
        } else if (!bl && bl2) {
            n7 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n8 = sampleModel2.getNumBands();
        if (n8 != n7) {
            n8 = n7;
            bl3 = true;
        }
        if ((n = sampleModel2.getTransferType()) != 4 && n != 5) {
            n = 4;
            bl3 = true;
        }
        if (bl3) {
            int[] nArray = new int[n8];
            int n9 = 0;
            while (n9 < n8) {
                nArray[n9] = n9;
                ++n9;
            }
            int n10 = n2 * n8;
            sampleModel2 = RasterFactory.createPixelInterleavedSampleModel(n, n2, n3, n8, n10, nArray);
            imageLayout2.setSampleModel(sampleModel2);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public MlibDFTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, EnumeratedParameter enumeratedParameter, boolean bl, EnumeratedParameter enumeratedParameter2) {
        super(renderedImage, map, MlibDFTOpImage.layoutHelper(imageLayout, renderedImage, enumeratedParameter));
        if (enumeratedParameter2.equals(DFTDescriptor.SCALING_NONE)) {
            this.DFTMode = bl ? 0 : 3;
        } else if (enumeratedParameter2.equals(DFTDescriptor.SCALING_UNITARY)) {
            this.DFTMode = bl ? 2 : 5;
        } else if (enumeratedParameter2.equals(DFTDescriptor.SCALING_DIMENSIONS)) {
            this.DFTMode = bl ? 1 : 4;
        } else {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage1"));
        }
    }

    public static boolean isAcceptableSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return true;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        int[] nArray = componentSampleModel.getBandOffsets();
        return nArray.length == 2 && nArray[1] == nArray[0] + 1;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n = MediaLibAccessor.findCompatibleTag(new Raster[]{raster}, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, this.mapDestRect(rectangle, 0), n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n2 = 0;
        while (n2 < mediaLibImageArray2.length) {
            Image.FourierTransform((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (int)this.DFTMode);
            ++n2;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

