/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Requirement {
    private final List<List<String>> requirements = new ArrayList<List<String>>();

    public Requirement(String ... disjunctions) {
        for (String disjunction : disjunctions) {
            List<String> requirement = Arrays.asList(disjunction.split("[ |]+"));
            this.requirements.add(requirement);
        }
    }

    public String getMissingRequirement(Set<String> alreadyAdded) {
        for (List<String> requirement : this.requirements) {
            boolean found = false;
            for (String annotator : requirement) {
                if (!alreadyAdded.contains(annotator)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return StringUtils.join(requirement, "|");
        }
        return null;
    }
}

