/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.regexp.RegexNERSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import java.util.List;

public class GenderAnnotator
implements Annotator {
    private RegexNERSequenceClassifier classifier;
    private Timing timer;
    private boolean verbose;

    public GenderAnnotator() {
        this(false, "edu/stanford/nlp/models/gender/first_name_map_small");
    }

    public GenderAnnotator(boolean verbose, String mapping) {
        this.classifier = new RegexNERSequenceClassifier(mapping, true, true);
        this.timer = new Timing();
        this.verbose = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            this.timer.start();
            System.err.print("Adding gender annotation...");
        }
        if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            throw new RuntimeException("Unable to find sentences in " + annotation);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            this.classifier.classify(tokens);
            for (CoreLabel token : tokens) {
                token.set(MachineReadingAnnotations.GenderAnnotation.class, token.get(CoreAnnotations.AnswerAnnotation.class));
            }
        }
        if (this.verbose) {
            this.timer.stop("done.");
        }
    }
}

