# Generated by default/object.tt
package Paws::Synthetics::CanaryLastRun;
  use Moose;
  has CanaryName => (is => 'ro', isa => 'Str');
  has LastRun => (is => 'ro', isa => 'Paws::Synthetics::CanaryRun');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryLastRun

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryLastRun object:

  $service_obj->Method(Att1 => { CanaryName => $value, ..., LastRun => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryLastRun object:

  $result = $service_obj->Method(...);
  $result->Att1->CanaryName

=head1 DESCRIPTION

This structure contains information about the most recent run of a
single canary.

=head1 ATTRIBUTES


=head2 CanaryName => Str

The name of the canary.


=head2 LastRun => L<Paws::Synthetics::CanaryRun>

The results from this canary's most recent run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

