package Kubernetes::REST::Result2Object;
  use Moo;
  use IO::K8s;
  use Kubernetes::REST::Error;

  has parser => (is => 'ro', default => sub { IO::K8s->new });

  sub result2return {
    my ($self, $call, $req, $response) = @_;

    if ($response->status >= 400) {
      return $self->process_error($response);
    } else {
      return 1 if (not defined $response->content);
      return $self->process_response($call, $response);
    } 
  }

  sub process_response {
    my ($self, $call, $response) = @_;
    
    my $return_class = $self->method_map->{ $call->method };
    die "No return object for " . $call->method if (not defined $return_class);
    my $object = eval {
      $self->parser->json_to_object($return_class, $response->content);
    };
    Kubernetes::REST::Error->throw(
      type => 'UnparseableResponse',
      message => 'Can\'t parse response ' . $response->content . ' with error ' . $@
    ) if ($@);

    return $object;
  }

  sub process_error {
    my ($self, $response) = @_;

    my $struct = eval {
      $self->parser->decode($response->content);
    };

    Kubernetes::REST::Error->throw(
      type => 'UnparseableResponse',
      message => 'Can\'t parse JSON content',
      detail => $response->content,
    ) if ($@);

    # Throw a Kubernetes::REST::RemoteError exception from
    # the info in $struct
    # {"kind":"Status","apiVersion":"v1","metadata":{},"status":"Failure","message":"Unauthorized","reason":"Unauthorized","code":401}
    Kubernetes::REST::RemoteError->throw(
      status => $response->status,
      type => 'RemoteError',
      message => "$struct->{ message }: $struct->{ reason }",
    );
  }

  has method_map => (is => 'ro', default => sub { {
  
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    'v1alpha1::Admissionregistration::CreateInitializerConfiguration' => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    'v1beta1::Admissionregistration::CreateMutatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    'v1beta1::Admissionregistration::CreateValidatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    'v1beta1::Apiextensions::CreateCustomResourceDefinition' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1::Apiregistration::CreateAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1beta1::Apiregistration::CreateAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1::Apps::CreateNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    'v1::Apps::CreateNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::CreateNamespacedDeployment' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::CreateNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::CreateNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1beta1::Apps::CreateNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    'v1beta1::Apps::CreateNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::CreateNamespacedDeploymentRollback' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::CreateNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta2::Apps::CreateNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    'v1beta2::Apps::CreateNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::CreateNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::CreateNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::CreateNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1alpha1::Auditregistration::CreateAuditSink' => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    'v1::Authentication::CreateTokenReview' => 'IO::K8s::Api::Authentication::V1::TokenReview',
    'v1beta1::Authentication::CreateTokenReview' => 'IO::K8s::Api::Authentication::V1beta1::TokenReview',
    'v1::Authorization::CreateNamespacedLocalSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1::LocalSubjectAccessReview',
    'v1::Authorization::CreateSelfSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1::SelfSubjectAccessReview',
    'v1::Authorization::CreateSelfSubjectRulesReview' => 'IO::K8s::Api::Authorization::V1::SelfSubjectRulesReview',
    'v1::Authorization::CreateSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1::SubjectAccessReview',
    'v1beta1::Authorization::CreateNamespacedLocalSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1beta1::LocalSubjectAccessReview',
    'v1beta1::Authorization::CreateSelfSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1beta1::SelfSubjectAccessReview',
    'v1beta1::Authorization::CreateSelfSubjectRulesReview' => 'IO::K8s::Api::Authorization::V1beta1::SelfSubjectRulesReview',
    'v1beta1::Authorization::CreateSubjectAccessReview' => 'IO::K8s::Api::Authorization::V1beta1::SubjectAccessReview',
    'v1::Autoscaling::CreateNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::CreateNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::CreateNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v1::Batch::CreateNamespacedJob' => 'IO::K8s::Api::Batch::V1::Job',
    'v1beta1::Batch::CreateNamespacedCronJob' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v2alpha1::Batch::CreateNamespacedCronJob' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v1beta1::Certificates::CreateCertificateSigningRequest' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Coordination::CreateNamespacedLease' => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    'v1::Core::CreateNamespace' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::CreateNamespacedBinding' => 'IO::K8s::Api::Core::V1::Binding',
    'v1::Core::CreateNamespacedConfigMap' => 'IO::K8s::Api::Core::V1::ConfigMap',
    'v1::Core::CreateNamespacedEndpoints' => 'IO::K8s::Api::Core::V1::Endpoints',
    'v1::Core::CreateNamespacedEvent' => 'IO::K8s::Api::Core::V1::Event',
    'v1::Core::CreateNamespacedLimitRange' => 'IO::K8s::Api::Core::V1::LimitRange',
    'v1::Core::CreateNamespacedPersistentVolumeClaim' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::CreateNamespacedPod' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::CreateNamespacedPodBinding' => 'IO::K8s::Api::Core::V1::Binding',
    'v1::Core::CreateNamespacedPodEviction' => 'IO::K8s::Api::Policy::V1beta1::Eviction',
    'v1::Core::CreateNamespacedPodTemplate' => 'IO::K8s::Api::Core::V1::PodTemplate',
    'v1::Core::CreateNamespacedReplicationController' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::CreateNamespacedResourceQuota' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::CreateNamespacedSecret' => 'IO::K8s::Api::Core::V1::Secret',
    'v1::Core::CreateNamespacedService' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::CreateNamespacedServiceAccount' => 'IO::K8s::Api::Core::V1::ServiceAccount',
    'v1::Core::CreateNode' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::CreatePersistentVolume' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1beta1::Events::CreateNamespacedEvent' => 'IO::K8s::Api::Events::V1beta1::Event',
    'v1beta1::Extensions::CreateNamespacedDaemonSet' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::CreateNamespacedDeployment' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::CreateNamespacedDeploymentRollback' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::CreateNamespacedIngress' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::CreateNamespacedNetworkPolicy' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    'v1beta1::Extensions::CreateNamespacedReplicaSet' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::CreatePodSecurityPolicy' => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    'v1::Networking::CreateNamespacedNetworkPolicy' => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    'v1beta1::Policy::CreateNamespacedPodDisruptionBudget' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::CreatePodSecurityPolicy' => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    'v1::RbacAuthorization::CreateClusterRole' => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    'v1::RbacAuthorization::CreateClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    'v1::RbacAuthorization::CreateNamespacedRole' => 'IO::K8s::Api::Rbac::V1::Role',
    'v1::RbacAuthorization::CreateNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    'v1alpha1::RbacAuthorization::CreateClusterRole' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    'v1alpha1::RbacAuthorization::CreateClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    'v1alpha1::RbacAuthorization::CreateNamespacedRole' => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    'v1alpha1::RbacAuthorization::CreateNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    'v1beta1::RbacAuthorization::CreateClusterRole' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    'v1beta1::RbacAuthorization::CreateClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    'v1beta1::RbacAuthorization::CreateNamespacedRole' => 'IO::K8s::Api::Rbac::V1beta1::Role',
    'v1beta1::RbacAuthorization::CreateNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    'v1alpha1::Scheduling::CreatePriorityClass' => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    'v1beta1::Scheduling::CreatePriorityClass' => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    'v1alpha1::Settings::CreateNamespacedPodPreset' => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    'v1::Storage::CreateStorageClass' => 'IO::K8s::Api::Storage::V1::StorageClass',
    'v1alpha1::Storage::CreateVolumeAttachment' => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    'v1beta1::Storage::CreateStorageClass' => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    'v1beta1::Storage::CreateVolumeAttachment' => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    'v1alpha1::Admissionregistration::DeleteCollectionInitializerConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Admissionregistration::DeleteInitializerConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Admissionregistration::DeleteCollectionMutatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Admissionregistration::DeleteCollectionValidatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Admissionregistration::DeleteMutatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Admissionregistration::DeleteValidatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apiextensions::DeleteCollectionCustomResourceDefinition' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apiextensions::DeleteCustomResourceDefinition' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apiregistration::DeleteAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apiregistration::DeleteCollectionAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apiregistration::DeleteAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apiregistration::DeleteCollectionAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteCollectionNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteCollectionNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteCollectionNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteCollectionNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteCollectionNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Apps::DeleteNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteCollectionNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteCollectionNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteCollectionNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Apps::DeleteNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteCollectionNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteCollectionNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteCollectionNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteCollectionNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteCollectionNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta2::Apps::DeleteNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Auditregistration::DeleteAuditSink' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Auditregistration::DeleteCollectionAuditSink' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Autoscaling::DeleteCollectionNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Autoscaling::DeleteNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2beta1::Autoscaling::DeleteCollectionNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2beta1::Autoscaling::DeleteNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2beta2::Autoscaling::DeleteCollectionNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2beta2::Autoscaling::DeleteNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Batch::DeleteCollectionNamespacedJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Batch::DeleteNamespacedJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Batch::DeleteCollectionNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Batch::DeleteNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2alpha1::Batch::DeleteCollectionNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v2alpha1::Batch::DeleteNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Certificates::DeleteCertificateSigningRequest' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Certificates::DeleteCollectionCertificateSigningRequest' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Coordination::DeleteCollectionNamespacedLease' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Coordination::DeleteNamespacedLease' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedConfigMap' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedEndpoints' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedLimitRange' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedPersistentVolumeClaim' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedPod' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedPodTemplate' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedReplicationController' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedResourceQuota' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedSecret' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNamespacedServiceAccount' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionNode' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteCollectionPersistentVolume' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespace' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedConfigMap' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedEndpoints' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedLimitRange' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedPersistentVolumeClaim' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedPod' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedPodTemplate' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedReplicationController' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedResourceQuota' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedSecret' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNamespacedServiceAccount' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeleteNode' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Core::DeletePersistentVolume' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Events::DeleteCollectionNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Events::DeleteNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionNamespacedIngress' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteCollectionPodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteNamespacedIngress' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeleteNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Extensions::DeletePodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Networking::DeleteCollectionNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Networking::DeleteNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Policy::DeleteCollectionNamespacedPodDisruptionBudget' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Policy::DeleteCollectionPodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Policy::DeleteNamespacedPodDisruptionBudget' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Policy::DeletePodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteCollectionClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteCollectionClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteCollectionNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteCollectionNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::RbacAuthorization::DeleteNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteCollectionClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteCollectionClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteCollectionNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteCollectionNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::RbacAuthorization::DeleteNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteCollectionClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteCollectionClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteCollectionNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteCollectionNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::RbacAuthorization::DeleteNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Scheduling::DeleteCollectionPriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Scheduling::DeletePriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Scheduling::DeleteCollectionPriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Scheduling::DeletePriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Settings::DeleteCollectionNamespacedPodPreset' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Settings::DeleteNamespacedPodPreset' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Storage::DeleteCollectionStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1::Storage::DeleteStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Storage::DeleteCollectionVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1alpha1::Storage::DeleteVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Storage::DeleteCollectionStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Storage::DeleteCollectionVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Storage::DeleteStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    'v1beta1::Storage::DeleteVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    '::Apis::GetAPIVersions' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroupList',
    '::Admissionregistration::GetAdmissionregistrationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1alpha1::Admissionregistration::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Admissionregistration::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Apiextensions::GetApiextensionsAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Apiextensions::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Apiregistration::GetApiregistrationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Apiregistration::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Apiregistration::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Apps::GetAppsAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Apps::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Apps::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta2::Apps::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Auditregistration::GetAuditregistrationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1alpha1::Auditregistration::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Authentication::GetAuthenticationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Authentication::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Authentication::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Authorization::GetAuthorizationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Authorization::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Authorization::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Autoscaling::GetAutoscalingAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Autoscaling::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v2beta1::Autoscaling::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v2beta2::Autoscaling::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Batch::GetBatchAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Batch::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Batch::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v2alpha1::Batch::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Certificates::GetCertificatesAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Certificates::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Version::GetCodeVersion' => 'IO::K8s::Apimachinery::Pkg::Version::Info',
    '::Coordination::GetCoordinationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Coordination::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Core::GetCoreAPIVersions' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIVersions',
    'v1::Core::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Events::GetEventsAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Events::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Extensions::GetExtensionsAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Extensions::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Networking::GetNetworkingAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Networking::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Policy::GetPolicyAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1beta1::Policy::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::RbacAuthorization::GetRbacAuthorizationAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::RbacAuthorization::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1alpha1::RbacAuthorization::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::RbacAuthorization::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Scheduling::GetSchedulingAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1alpha1::Scheduling::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Scheduling::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Settings::GetSettingsAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1alpha1::Settings::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    '::Storage::GetStorageAPIGroup' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    'v1::Storage::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1alpha1::Storage::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1beta1::Storage::GetAPIResources' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    'v1alpha1::Admissionregistration::ListInitializerConfiguration' => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfigurationList',
    'v1beta1::Admissionregistration::ListMutatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfigurationList',
    'v1beta1::Admissionregistration::ListValidatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfigurationList',
    'v1beta1::Apiextensions::ListCustomResourceDefinition' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinitionList',
    'v1::Apiregistration::ListAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIServiceList',
    'v1beta1::Apiregistration::ListAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIServiceList',
    'v1::Apps::ListControllerRevisionForAllNamespaces' => 'IO::K8s::Api::Apps::V1::ControllerRevisionList',
    'v1::Apps::ListDaemonSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1::DaemonSetList',
    'v1::Apps::ListDeploymentForAllNamespaces' => 'IO::K8s::Api::Apps::V1::DeploymentList',
    'v1::Apps::ListNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1::ControllerRevisionList',
    'v1::Apps::ListNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1::DaemonSetList',
    'v1::Apps::ListNamespacedDeployment' => 'IO::K8s::Api::Apps::V1::DeploymentList',
    'v1::Apps::ListNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1::ReplicaSetList',
    'v1::Apps::ListNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1::StatefulSetList',
    'v1::Apps::ListReplicaSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1::ReplicaSetList',
    'v1::Apps::ListStatefulSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1::StatefulSetList',
    'v1beta1::Apps::ListControllerRevisionForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevisionList',
    'v1beta1::Apps::ListDeploymentForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta1::DeploymentList',
    'v1beta1::Apps::ListNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevisionList',
    'v1beta1::Apps::ListNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta1::DeploymentList',
    'v1beta1::Apps::ListNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta1::StatefulSetList',
    'v1beta1::Apps::ListStatefulSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta1::StatefulSetList',
    'v1beta2::Apps::ListControllerRevisionForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevisionList',
    'v1beta2::Apps::ListDaemonSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta2::DaemonSetList',
    'v1beta2::Apps::ListDeploymentForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta2::DeploymentList',
    'v1beta2::Apps::ListNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevisionList',
    'v1beta2::Apps::ListNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1beta2::DaemonSetList',
    'v1beta2::Apps::ListNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta2::DeploymentList',
    'v1beta2::Apps::ListNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSetList',
    'v1beta2::Apps::ListNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta2::StatefulSetList',
    'v1beta2::Apps::ListReplicaSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSetList',
    'v1beta2::Apps::ListStatefulSetForAllNamespaces' => 'IO::K8s::Api::Apps::V1beta2::StatefulSetList',
    'v1alpha1::Auditregistration::ListAuditSink' => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSinkList',
    'v1::Autoscaling::ListHorizontalPodAutoscalerForAllNamespaces' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscalerList',
    'v1::Autoscaling::ListNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscalerList',
    'v2beta1::Autoscaling::ListHorizontalPodAutoscalerForAllNamespaces' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscalerList',
    'v2beta1::Autoscaling::ListNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscalerList',
    'v2beta2::Autoscaling::ListHorizontalPodAutoscalerForAllNamespaces' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscalerList',
    'v2beta2::Autoscaling::ListNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscalerList',
    'v1::Batch::ListJobForAllNamespaces' => 'IO::K8s::Api::Batch::V1::JobList',
    'v1::Batch::ListNamespacedJob' => 'IO::K8s::Api::Batch::V1::JobList',
    'v1beta1::Batch::ListCronJobForAllNamespaces' => 'IO::K8s::Api::Batch::V1beta1::CronJobList',
    'v1beta1::Batch::ListNamespacedCronJob' => 'IO::K8s::Api::Batch::V1beta1::CronJobList',
    'v2alpha1::Batch::ListCronJobForAllNamespaces' => 'IO::K8s::Api::Batch::V2alpha1::CronJobList',
    'v2alpha1::Batch::ListNamespacedCronJob' => 'IO::K8s::Api::Batch::V2alpha1::CronJobList',
    'v1beta1::Certificates::ListCertificateSigningRequest' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequestList',
    'v1beta1::Coordination::ListLeaseForAllNamespaces' => 'IO::K8s::Api::Coordination::V1beta1::LeaseList',
    'v1beta1::Coordination::ListNamespacedLease' => 'IO::K8s::Api::Coordination::V1beta1::LeaseList',
    'v1::Core::ListComponentStatus' => 'IO::K8s::Api::Core::V1::ComponentStatusList',
    'v1::Core::ListConfigMapForAllNamespaces' => 'IO::K8s::Api::Core::V1::ConfigMapList',
    'v1::Core::ListEndpointsForAllNamespaces' => 'IO::K8s::Api::Core::V1::EndpointsList',
    'v1::Core::ListEventForAllNamespaces' => 'IO::K8s::Api::Core::V1::EventList',
    'v1::Core::ListLimitRangeForAllNamespaces' => 'IO::K8s::Api::Core::V1::LimitRangeList',
    'v1::Core::ListNamespace' => 'IO::K8s::Api::Core::V1::NamespaceList',
    'v1::Core::ListNamespacedConfigMap' => 'IO::K8s::Api::Core::V1::ConfigMapList',
    'v1::Core::ListNamespacedEndpoints' => 'IO::K8s::Api::Core::V1::EndpointsList',
    'v1::Core::ListNamespacedEvent' => 'IO::K8s::Api::Core::V1::EventList',
    'v1::Core::ListNamespacedLimitRange' => 'IO::K8s::Api::Core::V1::LimitRangeList',
    'v1::Core::ListNamespacedPersistentVolumeClaim' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaimList',
    'v1::Core::ListNamespacedPod' => 'IO::K8s::Api::Core::V1::PodList',
    'v1::Core::ListNamespacedPodTemplate' => 'IO::K8s::Api::Core::V1::PodTemplateList',
    'v1::Core::ListNamespacedReplicationController' => 'IO::K8s::Api::Core::V1::ReplicationControllerList',
    'v1::Core::ListNamespacedResourceQuota' => 'IO::K8s::Api::Core::V1::ResourceQuotaList',
    'v1::Core::ListNamespacedSecret' => 'IO::K8s::Api::Core::V1::SecretList',
    'v1::Core::ListNamespacedService' => 'IO::K8s::Api::Core::V1::ServiceList',
    'v1::Core::ListNamespacedServiceAccount' => 'IO::K8s::Api::Core::V1::ServiceAccountList',
    'v1::Core::ListNode' => 'IO::K8s::Api::Core::V1::NodeList',
    'v1::Core::ListPersistentVolume' => 'IO::K8s::Api::Core::V1::PersistentVolumeList',
    'v1::Core::ListPersistentVolumeClaimForAllNamespaces' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaimList',
    'v1::Core::ListPodForAllNamespaces' => 'IO::K8s::Api::Core::V1::PodList',
    'v1::Core::ListPodTemplateForAllNamespaces' => 'IO::K8s::Api::Core::V1::PodTemplateList',
    'v1::Core::ListReplicationControllerForAllNamespaces' => 'IO::K8s::Api::Core::V1::ReplicationControllerList',
    'v1::Core::ListResourceQuotaForAllNamespaces' => 'IO::K8s::Api::Core::V1::ResourceQuotaList',
    'v1::Core::ListSecretForAllNamespaces' => 'IO::K8s::Api::Core::V1::SecretList',
    'v1::Core::ListServiceAccountForAllNamespaces' => 'IO::K8s::Api::Core::V1::ServiceAccountList',
    'v1::Core::ListServiceForAllNamespaces' => 'IO::K8s::Api::Core::V1::ServiceList',
    'v1beta1::Events::ListEventForAllNamespaces' => 'IO::K8s::Api::Events::V1beta1::EventList',
    'v1beta1::Events::ListNamespacedEvent' => 'IO::K8s::Api::Events::V1beta1::EventList',
    'v1beta1::Extensions::ListDaemonSetForAllNamespaces' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSetList',
    'v1beta1::Extensions::ListDeploymentForAllNamespaces' => 'IO::K8s::Api::Extensions::V1beta1::DeploymentList',
    'v1beta1::Extensions::ListIngressForAllNamespaces' => 'IO::K8s::Api::Extensions::V1beta1::IngressList',
    'v1beta1::Extensions::ListNamespacedDaemonSet' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSetList',
    'v1beta1::Extensions::ListNamespacedDeployment' => 'IO::K8s::Api::Extensions::V1beta1::DeploymentList',
    'v1beta1::Extensions::ListNamespacedIngress' => 'IO::K8s::Api::Extensions::V1beta1::IngressList',
    'v1beta1::Extensions::ListNamespacedNetworkPolicy' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicyList',
    'v1beta1::Extensions::ListNamespacedReplicaSet' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSetList',
    'v1beta1::Extensions::ListNetworkPolicyForAllNamespaces' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicyList',
    'v1beta1::Extensions::ListPodSecurityPolicy' => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicyList',
    'v1beta1::Extensions::ListReplicaSetForAllNamespaces' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSetList',
    'v1::Networking::ListNamespacedNetworkPolicy' => 'IO::K8s::Api::Networking::V1::NetworkPolicyList',
    'v1::Networking::ListNetworkPolicyForAllNamespaces' => 'IO::K8s::Api::Networking::V1::NetworkPolicyList',
    'v1beta1::Policy::ListNamespacedPodDisruptionBudget' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudgetList',
    'v1beta1::Policy::ListPodDisruptionBudgetForAllNamespaces' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudgetList',
    'v1beta1::Policy::ListPodSecurityPolicy' => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicyList',
    'v1::RbacAuthorization::ListClusterRole' => 'IO::K8s::Api::Rbac::V1::ClusterRoleList',
    'v1::RbacAuthorization::ListClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1::ClusterRoleBindingList',
    'v1::RbacAuthorization::ListNamespacedRole' => 'IO::K8s::Api::Rbac::V1::RoleList',
    'v1::RbacAuthorization::ListNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1::RoleBindingList',
    'v1::RbacAuthorization::ListRoleBindingForAllNamespaces' => 'IO::K8s::Api::Rbac::V1::RoleBindingList',
    'v1::RbacAuthorization::ListRoleForAllNamespaces' => 'IO::K8s::Api::Rbac::V1::RoleList',
    'v1alpha1::RbacAuthorization::ListClusterRole' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleList',
    'v1alpha1::RbacAuthorization::ListClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBindingList',
    'v1alpha1::RbacAuthorization::ListNamespacedRole' => 'IO::K8s::Api::Rbac::V1alpha1::RoleList',
    'v1alpha1::RbacAuthorization::ListNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBindingList',
    'v1alpha1::RbacAuthorization::ListRoleBindingForAllNamespaces' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBindingList',
    'v1alpha1::RbacAuthorization::ListRoleForAllNamespaces' => 'IO::K8s::Api::Rbac::V1alpha1::RoleList',
    'v1beta1::RbacAuthorization::ListClusterRole' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleList',
    'v1beta1::RbacAuthorization::ListClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBindingList',
    'v1beta1::RbacAuthorization::ListNamespacedRole' => 'IO::K8s::Api::Rbac::V1beta1::RoleList',
    'v1beta1::RbacAuthorization::ListNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::RoleBindingList',
    'v1beta1::RbacAuthorization::ListRoleBindingForAllNamespaces' => 'IO::K8s::Api::Rbac::V1beta1::RoleBindingList',
    'v1beta1::RbacAuthorization::ListRoleForAllNamespaces' => 'IO::K8s::Api::Rbac::V1beta1::RoleList',
    'v1alpha1::Scheduling::ListPriorityClass' => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClassList',
    'v1beta1::Scheduling::ListPriorityClass' => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClassList',
    'v1alpha1::Settings::ListNamespacedPodPreset' => 'IO::K8s::Api::Settings::V1alpha1::PodPresetList',
    'v1alpha1::Settings::ListPodPresetForAllNamespaces' => 'IO::K8s::Api::Settings::V1alpha1::PodPresetList',
    'v1::Storage::ListStorageClass' => 'IO::K8s::Api::Storage::V1::StorageClassList',
    'v1alpha1::Storage::ListVolumeAttachment' => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachmentList',
    'v1beta1::Storage::ListStorageClass' => 'IO::K8s::Api::Storage::V1beta1::StorageClassList',
    'v1beta1::Storage::ListVolumeAttachment' => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachmentList',
    
    
    'v1alpha1::Admissionregistration::PatchInitializerConfiguration' => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    'v1beta1::Admissionregistration::PatchMutatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    'v1beta1::Admissionregistration::PatchValidatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    'v1beta1::Apiextensions::PatchCustomResourceDefinition' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1beta1::Apiextensions::PatchCustomResourceDefinitionStatus' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1::Apiregistration::PatchAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1::Apiregistration::PatchAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1beta1::Apiregistration::PatchAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1beta1::Apiregistration::PatchAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1::Apps::PatchNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    'v1::Apps::PatchNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::PatchNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::PatchNamespacedDeployment' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::PatchNamespacedDeploymentScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::PatchNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::PatchNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::PatchNamespacedReplicaSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::PatchNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::PatchNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1::Apps::PatchNamespacedStatefulSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::PatchNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1beta1::Apps::PatchNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    'v1beta1::Apps::PatchNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::PatchNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::PatchNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::PatchNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta1::Apps::PatchNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::PatchNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta2::Apps::PatchNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    'v1beta2::Apps::PatchNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::PatchNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::PatchNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::PatchNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::PatchNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::PatchNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::PatchNamespacedReplicaSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::PatchNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::PatchNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1beta2::Apps::PatchNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::PatchNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1alpha1::Auditregistration::PatchAuditSink' => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    'v1::Autoscaling::PatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v1::Autoscaling::PatchNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::PatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::PatchNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::PatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::PatchNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v1::Batch::PatchNamespacedJob' => 'IO::K8s::Api::Batch::V1::Job',
    'v1::Batch::PatchNamespacedJobStatus' => 'IO::K8s::Api::Batch::V1::Job',
    'v1beta1::Batch::PatchNamespacedCronJob' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v1beta1::Batch::PatchNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v2alpha1::Batch::PatchNamespacedCronJob' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v2alpha1::Batch::PatchNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v1beta1::Certificates::PatchCertificateSigningRequest' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Certificates::PatchCertificateSigningRequestStatus' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Coordination::PatchNamespacedLease' => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    'v1::Core::PatchNamespace' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::PatchNamespaceStatus' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::PatchNamespacedConfigMap' => 'IO::K8s::Api::Core::V1::ConfigMap',
    'v1::Core::PatchNamespacedEndpoints' => 'IO::K8s::Api::Core::V1::Endpoints',
    'v1::Core::PatchNamespacedEvent' => 'IO::K8s::Api::Core::V1::Event',
    'v1::Core::PatchNamespacedLimitRange' => 'IO::K8s::Api::Core::V1::LimitRange',
    'v1::Core::PatchNamespacedPersistentVolumeClaim' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::PatchNamespacedPersistentVolumeClaimStatus' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::PatchNamespacedPod' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::PatchNamespacedPodStatus' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::PatchNamespacedPodTemplate' => 'IO::K8s::Api::Core::V1::PodTemplate',
    'v1::Core::PatchNamespacedReplicationController' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::PatchNamespacedReplicationControllerScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Core::PatchNamespacedReplicationControllerStatus' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::PatchNamespacedResourceQuota' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::PatchNamespacedResourceQuotaStatus' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::PatchNamespacedSecret' => 'IO::K8s::Api::Core::V1::Secret',
    'v1::Core::PatchNamespacedService' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::PatchNamespacedServiceAccount' => 'IO::K8s::Api::Core::V1::ServiceAccount',
    'v1::Core::PatchNamespacedServiceStatus' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::PatchNode' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::PatchNodeStatus' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::PatchPersistentVolume' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1::Core::PatchPersistentVolumeStatus' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1beta1::Events::PatchNamespacedEvent' => 'IO::K8s::Api::Events::V1beta1::Event',
    'v1beta1::Extensions::PatchNamespacedDaemonSet' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::PatchNamespacedDaemonSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::PatchNamespacedDeployment' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::PatchNamespacedDeploymentScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::PatchNamespacedDeploymentStatus' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::PatchNamespacedIngress' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::PatchNamespacedIngressStatus' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::PatchNamespacedNetworkPolicy' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    'v1beta1::Extensions::PatchNamespacedReplicaSet' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::PatchNamespacedReplicaSetScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::PatchNamespacedReplicaSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::PatchNamespacedReplicationControllerDummyScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::PatchPodSecurityPolicy' => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    'v1::Networking::PatchNamespacedNetworkPolicy' => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    'v1beta1::Policy::PatchNamespacedPodDisruptionBudget' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::PatchNamespacedPodDisruptionBudgetStatus' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::PatchPodSecurityPolicy' => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    'v1::RbacAuthorization::PatchClusterRole' => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    'v1::RbacAuthorization::PatchClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    'v1::RbacAuthorization::PatchNamespacedRole' => 'IO::K8s::Api::Rbac::V1::Role',
    'v1::RbacAuthorization::PatchNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    'v1alpha1::RbacAuthorization::PatchClusterRole' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    'v1alpha1::RbacAuthorization::PatchClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    'v1alpha1::RbacAuthorization::PatchNamespacedRole' => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    'v1alpha1::RbacAuthorization::PatchNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    'v1beta1::RbacAuthorization::PatchClusterRole' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    'v1beta1::RbacAuthorization::PatchClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    'v1beta1::RbacAuthorization::PatchNamespacedRole' => 'IO::K8s::Api::Rbac::V1beta1::Role',
    'v1beta1::RbacAuthorization::PatchNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    'v1alpha1::Scheduling::PatchPriorityClass' => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    'v1beta1::Scheduling::PatchPriorityClass' => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    'v1alpha1::Settings::PatchNamespacedPodPreset' => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    'v1::Storage::PatchStorageClass' => 'IO::K8s::Api::Storage::V1::StorageClass',
    'v1alpha1::Storage::PatchVolumeAttachment' => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    'v1beta1::Storage::PatchStorageClass' => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    'v1beta1::Storage::PatchVolumeAttachment' => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    'v1alpha1::Admissionregistration::ReadInitializerConfiguration' => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    'v1beta1::Admissionregistration::ReadMutatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    'v1beta1::Admissionregistration::ReadValidatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    'v1beta1::Apiextensions::ReadCustomResourceDefinition' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1beta1::Apiextensions::ReadCustomResourceDefinitionStatus' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1::Apiregistration::ReadAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1::Apiregistration::ReadAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1beta1::Apiregistration::ReadAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1beta1::Apiregistration::ReadAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1::Apps::ReadNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    'v1::Apps::ReadNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::ReadNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::ReadNamespacedDeployment' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::ReadNamespacedDeploymentScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReadNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::ReadNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::ReadNamespacedReplicaSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReadNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::ReadNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1::Apps::ReadNamespacedStatefulSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReadNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1beta1::Apps::ReadNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    'v1beta1::Apps::ReadNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::ReadNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::ReadNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::ReadNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta1::Apps::ReadNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::ReadNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta2::Apps::ReadNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    'v1beta2::Apps::ReadNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::ReadNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::ReadNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::ReadNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReadNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::ReadNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::ReadNamespacedReplicaSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReadNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::ReadNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1beta2::Apps::ReadNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReadNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1alpha1::Auditregistration::ReadAuditSink' => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    'v1::Autoscaling::ReadNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v1::Autoscaling::ReadNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::ReadNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::ReadNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::ReadNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::ReadNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v1::Batch::ReadNamespacedJob' => 'IO::K8s::Api::Batch::V1::Job',
    'v1::Batch::ReadNamespacedJobStatus' => 'IO::K8s::Api::Batch::V1::Job',
    'v1beta1::Batch::ReadNamespacedCronJob' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v1beta1::Batch::ReadNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v2alpha1::Batch::ReadNamespacedCronJob' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v2alpha1::Batch::ReadNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v1beta1::Certificates::ReadCertificateSigningRequest' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Certificates::ReadCertificateSigningRequestStatus' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Coordination::ReadNamespacedLease' => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    'v1::Core::ReadComponentStatus' => 'IO::K8s::Api::Core::V1::ComponentStatus',
    'v1::Core::ReadNamespace' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::ReadNamespaceStatus' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::ReadNamespacedConfigMap' => 'IO::K8s::Api::Core::V1::ConfigMap',
    'v1::Core::ReadNamespacedEndpoints' => 'IO::K8s::Api::Core::V1::Endpoints',
    'v1::Core::ReadNamespacedEvent' => 'IO::K8s::Api::Core::V1::Event',
    'v1::Core::ReadNamespacedLimitRange' => 'IO::K8s::Api::Core::V1::LimitRange',
    'v1::Core::ReadNamespacedPersistentVolumeClaim' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::ReadNamespacedPersistentVolumeClaimStatus' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::ReadNamespacedPod' => 'IO::K8s::Api::Core::V1::Pod',
    
    'v1::Core::ReadNamespacedPodStatus' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::ReadNamespacedPodTemplate' => 'IO::K8s::Api::Core::V1::PodTemplate',
    'v1::Core::ReadNamespacedReplicationController' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::ReadNamespacedReplicationControllerScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Core::ReadNamespacedReplicationControllerStatus' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::ReadNamespacedResourceQuota' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::ReadNamespacedResourceQuotaStatus' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::ReadNamespacedSecret' => 'IO::K8s::Api::Core::V1::Secret',
    'v1::Core::ReadNamespacedService' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::ReadNamespacedServiceAccount' => 'IO::K8s::Api::Core::V1::ServiceAccount',
    'v1::Core::ReadNamespacedServiceStatus' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::ReadNode' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::ReadNodeStatus' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::ReadPersistentVolume' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1::Core::ReadPersistentVolumeStatus' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1beta1::Events::ReadNamespacedEvent' => 'IO::K8s::Api::Events::V1beta1::Event',
    'v1beta1::Extensions::ReadNamespacedDaemonSet' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::ReadNamespacedDaemonSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::ReadNamespacedDeployment' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::ReadNamespacedDeploymentScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReadNamespacedDeploymentStatus' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::ReadNamespacedIngress' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::ReadNamespacedIngressStatus' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::ReadNamespacedNetworkPolicy' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    'v1beta1::Extensions::ReadNamespacedReplicaSet' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::ReadNamespacedReplicaSetScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReadNamespacedReplicaSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::ReadNamespacedReplicationControllerDummyScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReadPodSecurityPolicy' => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    'v1::Networking::ReadNamespacedNetworkPolicy' => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    'v1beta1::Policy::ReadNamespacedPodDisruptionBudget' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::ReadNamespacedPodDisruptionBudgetStatus' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::ReadPodSecurityPolicy' => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    'v1::RbacAuthorization::ReadClusterRole' => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    'v1::RbacAuthorization::ReadClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    'v1::RbacAuthorization::ReadNamespacedRole' => 'IO::K8s::Api::Rbac::V1::Role',
    'v1::RbacAuthorization::ReadNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    'v1alpha1::RbacAuthorization::ReadClusterRole' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    'v1alpha1::RbacAuthorization::ReadClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    'v1alpha1::RbacAuthorization::ReadNamespacedRole' => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    'v1alpha1::RbacAuthorization::ReadNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    'v1beta1::RbacAuthorization::ReadClusterRole' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    'v1beta1::RbacAuthorization::ReadClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    'v1beta1::RbacAuthorization::ReadNamespacedRole' => 'IO::K8s::Api::Rbac::V1beta1::Role',
    'v1beta1::RbacAuthorization::ReadNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    'v1alpha1::Scheduling::ReadPriorityClass' => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    'v1beta1::Scheduling::ReadPriorityClass' => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    'v1alpha1::Settings::ReadNamespacedPodPreset' => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    'v1::Storage::ReadStorageClass' => 'IO::K8s::Api::Storage::V1::StorageClass',
    'v1alpha1::Storage::ReadVolumeAttachment' => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    'v1beta1::Storage::ReadStorageClass' => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    'v1beta1::Storage::ReadVolumeAttachment' => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    'v1alpha1::Admissionregistration::ReplaceInitializerConfiguration' => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    'v1beta1::Admissionregistration::ReplaceMutatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    'v1beta1::Admissionregistration::ReplaceValidatingWebhookConfiguration' => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    'v1beta1::Apiextensions::ReplaceCustomResourceDefinition' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1beta1::Apiextensions::ReplaceCustomResourceDefinitionStatus' => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    'v1::Apiregistration::ReplaceAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1::Apiregistration::ReplaceAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    'v1beta1::Apiregistration::ReplaceAPIService' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1beta1::Apiregistration::ReplaceAPIServiceStatus' => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    'v1::Apps::ReplaceNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    'v1::Apps::ReplaceNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::ReplaceNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1::DaemonSet',
    'v1::Apps::ReplaceNamespacedDeployment' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::ReplaceNamespacedDeploymentScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReplaceNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1::Deployment',
    'v1::Apps::ReplaceNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::ReplaceNamespacedReplicaSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReplaceNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    'v1::Apps::ReplaceNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1::Apps::ReplaceNamespacedStatefulSetScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Apps::ReplaceNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1::StatefulSet',
    'v1beta1::Apps::ReplaceNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    'v1beta1::Apps::ReplaceNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::ReplaceNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::ReplaceNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    'v1beta1::Apps::ReplaceNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta1::Apps::ReplaceNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta1::Scale',
    'v1beta1::Apps::ReplaceNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    'v1beta2::Apps::ReplaceNamespacedControllerRevision' => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    'v1beta2::Apps::ReplaceNamespacedDaemonSet' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::ReplaceNamespacedDaemonSetStatus' => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    'v1beta2::Apps::ReplaceNamespacedDeployment' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::ReplaceNamespacedDeploymentScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReplaceNamespacedDeploymentStatus' => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    'v1beta2::Apps::ReplaceNamespacedReplicaSet' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::ReplaceNamespacedReplicaSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReplaceNamespacedReplicaSetStatus' => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    'v1beta2::Apps::ReplaceNamespacedStatefulSet' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1beta2::Apps::ReplaceNamespacedStatefulSetScale' => 'IO::K8s::Api::Apps::V1beta2::Scale',
    'v1beta2::Apps::ReplaceNamespacedStatefulSetStatus' => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    'v1alpha1::Auditregistration::ReplaceAuditSink' => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    'v1::Autoscaling::ReplaceNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v1::Autoscaling::ReplaceNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::ReplaceNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta1::Autoscaling::ReplaceNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::ReplaceNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v2beta2::Autoscaling::ReplaceNamespacedHorizontalPodAutoscalerStatus' => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    'v1::Batch::ReplaceNamespacedJob' => 'IO::K8s::Api::Batch::V1::Job',
    'v1::Batch::ReplaceNamespacedJobStatus' => 'IO::K8s::Api::Batch::V1::Job',
    'v1beta1::Batch::ReplaceNamespacedCronJob' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v1beta1::Batch::ReplaceNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    'v2alpha1::Batch::ReplaceNamespacedCronJob' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v2alpha1::Batch::ReplaceNamespacedCronJobStatus' => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    'v1beta1::Certificates::ReplaceCertificateSigningRequest' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Certificates::ReplaceCertificateSigningRequestApproval' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Certificates::ReplaceCertificateSigningRequestStatus' => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    'v1beta1::Coordination::ReplaceNamespacedLease' => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    'v1::Core::ReplaceNamespace' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::ReplaceNamespaceFinalize' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::ReplaceNamespaceStatus' => 'IO::K8s::Api::Core::V1::Namespace',
    'v1::Core::ReplaceNamespacedConfigMap' => 'IO::K8s::Api::Core::V1::ConfigMap',
    'v1::Core::ReplaceNamespacedEndpoints' => 'IO::K8s::Api::Core::V1::Endpoints',
    'v1::Core::ReplaceNamespacedEvent' => 'IO::K8s::Api::Core::V1::Event',
    'v1::Core::ReplaceNamespacedLimitRange' => 'IO::K8s::Api::Core::V1::LimitRange',
    'v1::Core::ReplaceNamespacedPersistentVolumeClaim' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::ReplaceNamespacedPersistentVolumeClaimStatus' => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    'v1::Core::ReplaceNamespacedPod' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::ReplaceNamespacedPodStatus' => 'IO::K8s::Api::Core::V1::Pod',
    'v1::Core::ReplaceNamespacedPodTemplate' => 'IO::K8s::Api::Core::V1::PodTemplate',
    'v1::Core::ReplaceNamespacedReplicationController' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::ReplaceNamespacedReplicationControllerScale' => 'IO::K8s::Api::Autoscaling::V1::Scale',
    'v1::Core::ReplaceNamespacedReplicationControllerStatus' => 'IO::K8s::Api::Core::V1::ReplicationController',
    'v1::Core::ReplaceNamespacedResourceQuota' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::ReplaceNamespacedResourceQuotaStatus' => 'IO::K8s::Api::Core::V1::ResourceQuota',
    'v1::Core::ReplaceNamespacedSecret' => 'IO::K8s::Api::Core::V1::Secret',
    'v1::Core::ReplaceNamespacedService' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::ReplaceNamespacedServiceAccount' => 'IO::K8s::Api::Core::V1::ServiceAccount',
    'v1::Core::ReplaceNamespacedServiceStatus' => 'IO::K8s::Api::Core::V1::Service',
    'v1::Core::ReplaceNode' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::ReplaceNodeStatus' => 'IO::K8s::Api::Core::V1::Node',
    'v1::Core::ReplacePersistentVolume' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1::Core::ReplacePersistentVolumeStatus' => 'IO::K8s::Api::Core::V1::PersistentVolume',
    'v1beta1::Events::ReplaceNamespacedEvent' => 'IO::K8s::Api::Events::V1beta1::Event',
    'v1beta1::Extensions::ReplaceNamespacedDaemonSet' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::ReplaceNamespacedDaemonSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    'v1beta1::Extensions::ReplaceNamespacedDeployment' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::ReplaceNamespacedDeploymentScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReplaceNamespacedDeploymentStatus' => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    'v1beta1::Extensions::ReplaceNamespacedIngress' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::ReplaceNamespacedIngressStatus' => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    'v1beta1::Extensions::ReplaceNamespacedNetworkPolicy' => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    'v1beta1::Extensions::ReplaceNamespacedReplicaSet' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::ReplaceNamespacedReplicaSetScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReplaceNamespacedReplicaSetStatus' => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    'v1beta1::Extensions::ReplaceNamespacedReplicationControllerDummyScale' => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    'v1beta1::Extensions::ReplacePodSecurityPolicy' => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    'v1::Networking::ReplaceNamespacedNetworkPolicy' => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    'v1beta1::Policy::ReplaceNamespacedPodDisruptionBudget' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::ReplaceNamespacedPodDisruptionBudgetStatus' => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    'v1beta1::Policy::ReplacePodSecurityPolicy' => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    'v1::RbacAuthorization::ReplaceClusterRole' => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    'v1::RbacAuthorization::ReplaceClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    'v1::RbacAuthorization::ReplaceNamespacedRole' => 'IO::K8s::Api::Rbac::V1::Role',
    'v1::RbacAuthorization::ReplaceNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    'v1alpha1::RbacAuthorization::ReplaceClusterRole' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    'v1alpha1::RbacAuthorization::ReplaceClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    'v1alpha1::RbacAuthorization::ReplaceNamespacedRole' => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    'v1alpha1::RbacAuthorization::ReplaceNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    'v1beta1::RbacAuthorization::ReplaceClusterRole' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    'v1beta1::RbacAuthorization::ReplaceClusterRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    'v1beta1::RbacAuthorization::ReplaceNamespacedRole' => 'IO::K8s::Api::Rbac::V1beta1::Role',
    'v1beta1::RbacAuthorization::ReplaceNamespacedRoleBinding' => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    'v1alpha1::Scheduling::ReplacePriorityClass' => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    'v1beta1::Scheduling::ReplacePriorityClass' => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    'v1alpha1::Settings::ReplaceNamespacedPodPreset' => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    'v1::Storage::ReplaceStorageClass' => 'IO::K8s::Api::Storage::V1::StorageClass',
    'v1alpha1::Storage::ReplaceVolumeAttachment' => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    'v1beta1::Storage::ReplaceStorageClass' => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    'v1beta1::Storage::ReplaceVolumeAttachment' => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    'v1alpha1::Admissionregistration::WatchInitializerConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Admissionregistration::WatchInitializerConfigurationList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Admissionregistration::WatchMutatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Admissionregistration::WatchMutatingWebhookConfigurationList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Admissionregistration::WatchValidatingWebhookConfiguration' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Admissionregistration::WatchValidatingWebhookConfigurationList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apiextensions::WatchCustomResourceDefinition' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apiextensions::WatchCustomResourceDefinitionList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apiregistration::WatchAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apiregistration::WatchAPIServiceList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apiregistration::WatchAPIService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apiregistration::WatchAPIServiceList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchControllerRevisionListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchDaemonSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchDeploymentListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedControllerRevisionList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedDaemonSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedDeploymentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedReplicaSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchNamespacedStatefulSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchReplicaSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Apps::WatchStatefulSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchControllerRevisionListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchDeploymentListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedControllerRevisionList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedDeploymentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchNamespacedStatefulSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Apps::WatchStatefulSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchControllerRevisionListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchDaemonSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchDeploymentListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedControllerRevision' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedControllerRevisionList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedDaemonSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedDeploymentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedReplicaSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedStatefulSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchNamespacedStatefulSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchReplicaSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta2::Apps::WatchStatefulSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Auditregistration::WatchAuditSink' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Auditregistration::WatchAuditSinkList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Autoscaling::WatchHorizontalPodAutoscalerListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Autoscaling::WatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Autoscaling::WatchNamespacedHorizontalPodAutoscalerList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta1::Autoscaling::WatchHorizontalPodAutoscalerListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta1::Autoscaling::WatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta1::Autoscaling::WatchNamespacedHorizontalPodAutoscalerList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta2::Autoscaling::WatchHorizontalPodAutoscalerListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta2::Autoscaling::WatchNamespacedHorizontalPodAutoscaler' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2beta2::Autoscaling::WatchNamespacedHorizontalPodAutoscalerList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Batch::WatchJobListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Batch::WatchNamespacedJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Batch::WatchNamespacedJobList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Batch::WatchCronJobListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Batch::WatchNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Batch::WatchNamespacedCronJobList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2alpha1::Batch::WatchCronJobListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2alpha1::Batch::WatchNamespacedCronJob' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v2alpha1::Batch::WatchNamespacedCronJobList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Certificates::WatchCertificateSigningRequest' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Certificates::WatchCertificateSigningRequestList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Coordination::WatchLeaseListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Coordination::WatchNamespacedLease' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Coordination::WatchNamespacedLeaseList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchConfigMapListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchEndpointsListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchEventListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchLimitRangeListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespace' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespaceList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedConfigMap' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedConfigMapList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedEndpoints' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedEndpointsList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedEventList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedLimitRange' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedLimitRangeList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPersistentVolumeClaim' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPersistentVolumeClaimList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPod' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPodList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPodTemplate' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedPodTemplateList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedReplicationController' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedReplicationControllerList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedResourceQuota' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedResourceQuotaList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedSecret' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedSecretList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedService' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedServiceAccount' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedServiceAccountList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNamespacedServiceList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNode' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchNodeList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchPersistentVolume' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchPersistentVolumeClaimListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchPersistentVolumeList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchPodListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchPodTemplateListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchReplicationControllerListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchResourceQuotaListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchSecretListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchServiceAccountListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Core::WatchServiceListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Events::WatchEventListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Events::WatchNamespacedEvent' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Events::WatchNamespacedEventList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchDaemonSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchDeploymentListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchIngressListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedDaemonSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedDaemonSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedDeployment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedDeploymentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedIngress' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedIngressList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedNetworkPolicyList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedReplicaSet' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNamespacedReplicaSetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchNetworkPolicyListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchPodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchPodSecurityPolicyList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Extensions::WatchReplicaSetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Networking::WatchNamespacedNetworkPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Networking::WatchNamespacedNetworkPolicyList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Networking::WatchNetworkPolicyListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Policy::WatchNamespacedPodDisruptionBudget' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Policy::WatchNamespacedPodDisruptionBudgetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Policy::WatchPodDisruptionBudgetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Policy::WatchPodSecurityPolicy' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Policy::WatchPodSecurityPolicyList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchClusterRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchClusterRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchNamespacedRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchNamespacedRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchRoleBindingListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::RbacAuthorization::WatchRoleListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchClusterRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchClusterRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchNamespacedRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchNamespacedRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchRoleBindingListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::RbacAuthorization::WatchRoleListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchClusterRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchClusterRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchClusterRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchClusterRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchNamespacedRole' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchNamespacedRoleBinding' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchNamespacedRoleBindingList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchNamespacedRoleList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchRoleBindingListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::RbacAuthorization::WatchRoleListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Scheduling::WatchPriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Scheduling::WatchPriorityClassList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Scheduling::WatchPriorityClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Scheduling::WatchPriorityClassList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Settings::WatchNamespacedPodPreset' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Settings::WatchNamespacedPodPresetList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Settings::WatchPodPresetListForAllNamespaces' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Storage::WatchStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1::Storage::WatchStorageClassList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Storage::WatchVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1alpha1::Storage::WatchVolumeAttachmentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Storage::WatchStorageClass' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Storage::WatchStorageClassList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Storage::WatchVolumeAttachment' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    'v1beta1::Storage::WatchVolumeAttachmentList' => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
  } });

1;
