package Test::NoMalware;

use warnings;
use strict;

use Test::More;

our $VERSION = '3.1';

if ($^O eq "MSWin32") {
    plan skip_all => 'This module/test is not intended to be executed on Windows. You are wasting your time, energy, effort and life by using Windows.';
}


'there';

__END__

=head1 NAME

Test::NoMalware - skip all testing on Windows platform

=head1 SYNOPSIS

    use Test::More;
    use Test::NoMalware;

    ok(1, 'We have future!');

    done_testing();

=head1 DESCRIPTION

In case of MSWin32 C< $Config{'osname'}  >, skips all testing.

Sick and tired of MSWin32 failing tests. Any software from Microsoft is broken by design. They are unable
to make software that lasts, that doesn't throw away all the time and effort invested in it with the
next release. If you have to use it, I'm sorry for you. The only way to help out here is to stop using
Microsoft software and switch to something that has a future.

B<It is very easy to be blinded to the essential design flaws of Microsoft software by the sense of
achievement you get from getting it to work at all.>

=head1 AUTHOR

Jozef Kutej, C<< <jkutej at cpan.org> >>

=head1 LICENSE AND COPYRIGHT

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

