/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.concurrent.SynchronizedInterner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generics {
    private Generics() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <E> ArrayList<E> newArrayList(Collection<? extends E> c) {
        return new ArrayList<E>(c);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Collection<? extends E> c) {
        return new LinkedList<E>(c);
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <E> HashSet<E> newHashSet(Collection<? extends E> c) {
        return new HashSet<E>(c);
    }

    public static <E> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(comparator);
    }

    public static <E> TreeSet<E> newTreeSet(SortedSet<E> s) {
        return new TreeSet<E>(s);
    }

    public static <E> Stack<E> newStack() {
        return new Stack();
    }

    public static <E> BinaryHeapPriorityQueue<E> newBinaryHeapPriorityQueue() {
        return new BinaryHeapPriorityQueue();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> m) {
        return new HashMap<K, V>(m);
    }

    public static <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <E> Index<E> newIndex() {
        return new HashIndex();
    }

    public static <T1, T2> Pair<T1, T2> newPair(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> newTriple(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    public static <T> Interner<T> newInterner() {
        return new Interner();
    }

    public static <T> SynchronizedInterner<T> newSynchronizedInterner(Interner<T> interner) {
        return new SynchronizedInterner<T>(interner);
    }

    public static <T> SynchronizedInterner<T> newSynchronizedInterner(Interner<T> interner, Object mutex) {
        return new SynchronizedInterner<T>(interner, mutex);
    }

    public static <T> WeakReference<T> newWeakReference(T referent) {
        return new WeakReference<T>(referent);
    }
}

