/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graph2.Dijkstra;
import net.sourceforge.plantuml.graph2.GeomUtils;
import net.sourceforge.plantuml.graph2.Neighborhood2;
import net.sourceforge.plantuml.graph2.Singularity2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan {
    private final Map<Point2D.Double, Singularity2> points = new LinkedHashMap<Point2D.Double, Singularity2>();
    private final Collection<Line2D.Double> lines = new ArrayList<Line2D.Double>();

    public void addPoint2D(Point2D.Double double_) {
        if (this.points.containsKey(double_)) {
            throw new IllegalArgumentException();
        }
        this.points.put(double_, new Singularity2(double_));
    }

    public void debugPrint() {
        Log.println("PLAN PRINT");
        for (Singularity2 object : this.points.values()) {
            Log.println("s=" + object);
        }
        for (Line2D.Double double_ : this.lines) {
            Log.println(GeomUtils.toString(double_));
        }
    }

    public void createLink(Point2D point2D, Point2D point2D2) {
        Singularity2 singularity2 = this.points.get(point2D);
        Singularity2 singularity22 = this.points.get(point2D2);
        if (singularity2 == null || singularity22 == null) {
            throw new IllegalArgumentException();
        }
        Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
        singularity2.addLineSegment(double_);
        singularity22.addLineSegment(double_);
        this.lines.add(double_);
    }

    Singularity2 getSingularity(Point2D point2D) {
        Singularity2 singularity2 = this.points.get(point2D);
        if (singularity2 == null) {
            throw new IllegalArgumentException();
        }
        return singularity2;
    }

    List<Neighborhood2> getShortestPathToInternal(Point2D point2D, Point2D point2D2) {
        Object object;
        Dijkstra dijkstra = new Dijkstra();
        if (!this.points.containsKey(point2D) || !this.points.containsKey(point2D2)) {
            throw new IllegalArgumentException();
        }
        Dijkstra.Vertex vertex = dijkstra.addVertex(point2D);
        Dijkstra.Vertex vertex2 = dijkstra.addVertex(point2D2);
        LinkedHashMap<Neighborhood2, Dijkstra.Vertex> linkedHashMap = new LinkedHashMap<Neighborhood2, Dijkstra.Vertex>();
        for (Singularity2 arrayList2 : this.points.values()) {
            for (Neighborhood2 neighborhood2 : arrayList2.getNeighborhoods()) {
                object = dijkstra.addVertex(neighborhood2);
                linkedHashMap.put(neighborhood2, (Dijkstra.Vertex)object);
                if (neighborhood2.getCenter().equals(point2D)) {
                    vertex.addAdjacencies((Dijkstra.Vertex)object, 0.01);
                }
                if (!neighborhood2.getCenter().equals(point2D2)) continue;
                ((Dijkstra.Vertex)object).addAdjacencies(vertex2, 0.01);
            }
        }
        for (Dijkstra.Vertex vertex3 : linkedHashMap.values()) {
            for (Dijkstra.Vertex vertex4 : linkedHashMap.values()) {
                Line2D.Double double_;
                object = (Neighborhood2)vertex3.getData();
                Neighborhood2 neighborhood2 = (Neighborhood2)vertex4.getData();
                if (((Neighborhood2)object).getCenter().equals(neighborhood2.getCenter()) || this.isStrictCrossing(double_ = new Line2D.Double(((Neighborhood2)object).getCenter(), neighborhood2.getCenter())) || !((Neighborhood2)object).isConnectable(neighborhood2)) continue;
                double d = ((Neighborhood2)object).getCenter().distance(neighborhood2.getCenter());
                vertex3.addAdjacencies(vertex4, d);
                vertex4.addAdjacencies(vertex3, d);
            }
        }
        List<Dijkstra.Vertex> list = dijkstra.getShortestPathTo(vertex, vertex2);
        if (list.size() < 2) {
            throw new IllegalStateException("list=" + list);
        }
        ArrayList<Neighborhood2> arrayList = new ArrayList<Neighborhood2>();
        for (Dijkstra.Vertex vertex5 : list.subList(1, list.size() - 1)) {
            arrayList.add((Neighborhood2)vertex5.getData());
        }
        return arrayList;
    }

    public List<Point2D.Double> getIntermediatePoints(Point2D point2D, Point2D point2D2) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        List<Neighborhood2> list = this.getShortestPathToInternal(point2D, point2D2);
        for (int i = 1; i < list.size() - 1; ++i) {
            Neighborhood2 neighborhood2 = list.get(i);
            Point2D.Double double_ = list.get(i - 1).getCenter();
            Point2D.Double double_2 = list.get(i + 1).getCenter();
            Point2D.Double double_3 = neighborhood2.getPointInNeighborhood(this.getMindist(neighborhood2.getCenter()) / 2.0, double_, double_2);
            arrayList.add(double_3);
        }
        return arrayList;
    }

    private boolean isStrictCrossing(Line2D.Double double_) {
        for (Line2D.Double double_2 : this.lines) {
            if (!Plan.intersectsLineStrict(double_2, double_)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersectsLineStrict(Line2D.Double double_, Line2D.Double double_2) {
        assert (Plan.intersectsLineStrictInternal(double_, double_2) == Plan.intersectsLineStrictInternal(double_2, double_));
        assert (Plan.intersectsLineStrictInternal(double_, double_2) == Plan.intersectsLineStrictInternal(Plan.inverse(double_), double_2));
        assert (Plan.intersectsLineStrictInternal(double_, double_2) == Plan.intersectsLineStrictInternal(double_, Plan.inverse(double_2)));
        assert (Plan.intersectsLineStrictInternal(double_, double_2) == Plan.intersectsLineStrictInternal(Plan.inverse(double_), Plan.inverse(double_2)));
        return Plan.intersectsLineStrictInternal(double_, double_2);
    }

    private static Line2D.Double inverse(Line2D.Double double_) {
        return new Line2D.Double(double_.getP2(), double_.getP1());
    }

    private static boolean intersectsLineStrictInternal(Line2D.Double double_, Line2D.Double double_2) {
        if (!double_.intersectsLine(double_2)) {
            return false;
        }
        assert (double_.intersectsLine(double_2));
        Point2D.Double double_3 = (Point2D.Double)double_.getP1();
        Point2D.Double double_4 = (Point2D.Double)double_.getP2();
        Point2D.Double double_5 = (Point2D.Double)double_2.getP1();
        Point2D.Double double_6 = (Point2D.Double)double_2.getP2();
        if (!(double_3.equals(double_5) || double_3.equals(double_6) || double_4.equals(double_5) || double_4.equals(double_6))) {
            return true;
        }
        if (double_3.equals(double_6)) {
            Point2D.Double double_7 = double_5;
            double_5 = double_6;
            double_6 = double_7;
        } else if (double_5.equals(double_4)) {
            Point2D.Double double_8 = double_3;
            double_3 = double_4;
            double_4 = double_8;
        } else if (double_4.equals(double_6)) {
            Point2D.Double double_9 = double_5;
            double_5 = double_6;
            double_6 = double_9;
            double_9 = double_3;
            double_3 = double_4;
            double_4 = double_9;
        }
        assert (double_3.equals(double_5));
        return false;
    }

    final double getMindist(Point2D.Double double_) {
        double d;
        double d2 = Double.MAX_VALUE;
        for (Point2D.Double cloneable : this.points.keySet()) {
            if (double_.equals(cloneable)) continue;
            d = cloneable.distance(double_);
            if (d < 1.0E-4) {
                throw new IllegalStateException();
            }
            d2 = Math.min(d2, d);
        }
        for (Line2D.Double double_2 : this.lines) {
            if (((Line2D)double_2).getP1().equals(double_) || ((Line2D)double_2).getP2().equals(double_)) continue;
            d = double_2.ptSegDist(double_);
            if (d2 < 1.0E-4) {
                throw new IllegalStateException("pt=" + double_ + " line=" + GeomUtils.toString(double_2));
            }
            d2 = Math.min(d2, d);
        }
        if (d2 == 0.0) {
            throw new IllegalStateException();
        }
        return d2;
    }
}

