#!/usr/bin/perl -w

my %data =
(
	'Blowfish'	=> '52a037af4a2aea2d10cc09183b433f1a12c5ce734067d597da040861fed3ae61',
	'Blowfish_PP'	=> '52a037af4a2aea2d10cc09183b433f1a12c5ce734067d597da040861fed3ae61',
	'Camellia'	=> '37adb2c1ba5a6be79c7b886cdd432853bd6dfa6eac8a02cd8a85174ecd17ed12',
	'Camellia_PP'	=> '37adb2c1ba5a6be79c7b886cdd432853bd6dfa6eac8a02cd8a85174ecd17ed12',
	'CAST5'		=> '811a469a643c4f1e9c0236ab1a76682bb918a95c33c7663203fb163df0eb264f',
	'CAST5_PP'	=> '811a469a643c4f1e9c0236ab1a76682bb918a95c33c7663203fb163df0eb264f',
	'DES'		=> 'a47b1b2c90fb3b7a7367c1844d3d07e620b943fdc6728a05e5cf69afe49da6e8',
	'DES_PP'	=> 'a47b1b2c90fb3b7a7367c1844d3d07e620b943fdc6728a05e5cf69afe49da6e8',
	'IDEA'		=> '58678df1889afedbd336fe64a6fb39ab08156a201f832e9a8a2fd460251ebe24',
	'Rijndael'	=> 'a7acc570d3d8fc33e215e369fbc3d6552cfb2c2bf39b5064d5310c0d32eedeb2',
	'Rijndael_PP'	=> 'a7acc570d3d8fc33e215e369fbc3d6552cfb2c2bf39b5064d5310c0d32eedeb2',
	'Twofish'	=> '4873e7735f4c976b4ba9f041d5fc82dea713d312959ad1a710225f0cbc8cf706',

#	Twofish2 taken out for the moment, 'cause I'm not sure about the test data.
#	At least on some machines the test script reports an error.
#	'Twofish2'	=> '0958c674179aefaf13de8b25a613174dc40a90b80918bce55d314c86ecd3db45',

	'XTEA'		=> '6e2ca14be43fde47d5d456f8402b2a9c98984293b5cb4bb2b186113044098c03',
	'XTEA_PP'	=> '6e2ca14be43fde47d5d456f8402b2a9c98984293b5cb4bb2b186113044098c03',
);

use Test::More;

BEGIN { use_ok (Crypt::ECB) }

my $text = "This is just some dummy text!\n";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (sort keys %data)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", 1 if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		my $dec = $ecb->decrypt_hex($data{$cipher});
		ok($dec eq $text, "$cipher: decryption");
	}
}

done_testing( (keys %data) + 1 );
