#!perl

use strict;
use warnings;
use Test::More tests => 2;

use Pod::Advent;

chdir 'ex';

my $advent = Pod::Advent->new;
isa_ok($advent, 'Pod::Advent');
my $s;
$advent->output_string( \$s );
$advent->parse_file( 'sample.pod.txt' );

my $html = do{ local $/ = undef; open FILE, '<', 'sample.html'; <FILE> };

$s =~ s/(Generated by Pod::Advent .+? on) \d{4}-\d\d-\d\d \d\d:\d\d:\d\d (-->)$/$1 2007-12-18 21:23:53 $2/mg;  # fudge the generated time to match.

is($s, $html, "file matches!");

open FILE, '>', '/tmp/s'; print FILE $s; close FILE;

