# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2NetworkAclAssociation;
  use Moose;
  has NetworkAclAssociationId => (is => 'ro', isa => 'Str');
  has NetworkAclId => (is => 'ro', isa => 'Str');
  has SubnetId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2NetworkAclAssociation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2NetworkAclAssociation object:

  $service_obj->Method(Att1 => { NetworkAclAssociationId => $value, ..., SubnetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2NetworkAclAssociation object:

  $result = $service_obj->Method(...);
  $result->Att1->NetworkAclAssociationId

=head1 DESCRIPTION

An association between the network ACL and a subnet.

=head1 ATTRIBUTES


=head2 NetworkAclAssociationId => Str

The identifier of the association between the network ACL and the
subnet.


=head2 NetworkAclId => Str

The identifier of the network ACL.


=head2 SubnetId => Str

The identifier of the subnet that is associated with the network ACL.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

