# Generated by default/object.tt
package Paws::IoT::MachineLearningDetectionConfig;
  use Moose;
  has ConfidenceLevel => (is => 'ro', isa => 'Str', request_name => 'confidenceLevel', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::MachineLearningDetectionConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::MachineLearningDetectionConfig object:

  $service_obj->Method(Att1 => { ConfidenceLevel => $value, ..., ConfidenceLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::MachineLearningDetectionConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfidenceLevel

=head1 DESCRIPTION

The configuration of an ML Detect Security Profile.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ConfidenceLevel => Str

The sensitivity of anomalous behavior evaluation. Can be C<Low>,
C<Medium>, or C<High>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

