# Generated by default/object.tt
package Paws::SSMContacts::Target;
  use Moose;
  has ChannelTargetInfo => (is => 'ro', isa => 'Paws::SSMContacts::ChannelTargetInfo');
  has ContactTargetInfo => (is => 'ro', isa => 'Paws::SSMContacts::ContactTargetInfo');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Target

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Target object:

  $service_obj->Method(Att1 => { ChannelTargetInfo => $value, ..., ContactTargetInfo => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Target object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelTargetInfo

=head1 DESCRIPTION

The contact or contact channel that is being engaged.

=head1 ATTRIBUTES


=head2 ChannelTargetInfo => L<Paws::SSMContacts::ChannelTargetInfo>

Information about the contact channel Incident Manager is engaging.


=head2 ContactTargetInfo => L<Paws::SSMContacts::ContactTargetInfo>

Information about the contact that Incident Manager is engaging.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

