# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl BibliographicReference.t'

######################### We start with some black magic to print on failure.

BEGIN { $| = 1; print "1..50\n"; }
END {print "not ok 1\n" unless $loaded;}
use Carp;
use lib 't';
use strict;
use TestMAGE qw(result is_object);
use vars qw($i $loaded);
# use blib;
use Bio::MAGE;
use Bio::MAGE::Association;
use Bio::MAGE::BQS::BibliographicReference;
use Bio::MAGE::Description::OntologyEntry;
use Bio::MAGE::AuditAndSecurity::Audit;
use Bio::MAGE::AuditAndSecurity::Security;
use Bio::MAGE::NameValueType;
use Bio::MAGE::Description::Description;

$loaded = 1;
$i = 1;
result($i);

######################### End of black magic.

# we test the new() method
my $bibliographicreference;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $bibliographicreference = Bio::MAGE::BQS::BibliographicReference->new();
}
result($bibliographicreference->isa('Bio::MAGE::BQS::BibliographicReference'));

# test the package class method
result($bibliographicreference->package() eq q[BQS]);

# test the class_name class method
result($bibliographicreference->class_name() eq q[Bio::MAGE::BQS::BibliographicReference]);

# set the attribute values in the call to new()
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $bibliographicreference = Bio::MAGE::BQS::BibliographicReference->new(authors => 1,
URI => 2,
volume => 3,
issue => 4,
editor => 5,
title => 6,
publication => 7,
publisher => 8,
year => 9,
pages => 10);
}
# testing attribute authors
result ($bibliographicreference->getAuthors() == 1);
$bibliographicreference->setAuthors(1);
result ($bibliographicreference->getAuthors() == 1);

# testing attribute URI
result ($bibliographicreference->getURI() == 2);
$bibliographicreference->setURI(2);
result ($bibliographicreference->getURI() == 2);

# testing attribute volume
result ($bibliographicreference->getVolume() == 3);
$bibliographicreference->setVolume(3);
result ($bibliographicreference->getVolume() == 3);

# testing attribute issue
result ($bibliographicreference->getIssue() == 4);
$bibliographicreference->setIssue(4);
result ($bibliographicreference->getIssue() == 4);

# testing attribute editor
result ($bibliographicreference->getEditor() == 5);
$bibliographicreference->setEditor(5);
result ($bibliographicreference->getEditor() == 5);

# testing attribute title
result ($bibliographicreference->getTitle() == 6);
$bibliographicreference->setTitle(6);
result ($bibliographicreference->getTitle() == 6);

# testing attribute publication
result ($bibliographicreference->getPublication() == 7);
$bibliographicreference->setPublication(7);
result ($bibliographicreference->getPublication() == 7);

# testing attribute publisher
result ($bibliographicreference->getPublisher() == 8);
$bibliographicreference->setPublisher(8);
result ($bibliographicreference->getPublisher() == 8);

# testing attribute year
result ($bibliographicreference->getYear() == 9);
$bibliographicreference->setYear(9);
result ($bibliographicreference->getYear() == 9);

# testing attribute pages
result ($bibliographicreference->getPages() == 10);
$bibliographicreference->setPages(10);
result ($bibliographicreference->getPages() == 10);

# retrieve the list of association meta-data
my %assns = Bio::MAGE::BQS::BibliographicReference->associations();
my $assn;

# set the association values in the call to new()
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $bibliographicreference = Bio::MAGE::BQS::BibliographicReference->new(parameters => [Bio::MAGE::Description::OntologyEntry->new()],
security => Bio::MAGE::AuditAndSecurity::Security->new(),
auditTrail => [Bio::MAGE::AuditAndSecurity::Audit->new()],
descriptions => [Bio::MAGE::Description::Description->new()],
propertySets => [Bio::MAGE::NameValueType->new()]);
}
# testing association parameters
my $parameters_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $parameters_assn = Bio::MAGE::Description::OntologyEntry->new();
}
result (UNIVERSAL::isa($bibliographicreference->getParameters->[0],q[Bio::MAGE::Description::OntologyEntry]));
result ($bibliographicreference->setParameters([$parameters_assn]));
result (UNIVERSAL::isa($bibliographicreference->getParameters,'ARRAY')
 and scalar @{$bibliographicreference->getParameters()} == 1
 and $bibliographicreference->getParameters->[0] == $parameters_assn);
$bibliographicreference->addParameters($parameters_assn);
result (UNIVERSAL::isa($bibliographicreference->getParameters,'ARRAY')
 and scalar @{$bibliographicreference->getParameters()} == 2
 and $bibliographicreference->getParameters->[0] == $parameters_assn
 and $bibliographicreference->getParameters->[1] == $parameters_assn);


# test the meta-data for the assoication
($assn) = $assns{parameters};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association security
my $security_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $security_assn = Bio::MAGE::AuditAndSecurity::Security->new();
}
result (UNIVERSAL::isa($bibliographicreference->getSecurity,q[Bio::MAGE::AuditAndSecurity::Security]));
result ($bibliographicreference->setSecurity($security_assn) == $security_assn);
result ($bibliographicreference->getSecurity() == $security_assn);



# test the meta-data for the assoication
($assn) = $assns{security};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association auditTrail
my $audittrail_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $audittrail_assn = Bio::MAGE::AuditAndSecurity::Audit->new();
}
result (UNIVERSAL::isa($bibliographicreference->getAuditTrail->[0],q[Bio::MAGE::AuditAndSecurity::Audit]));
result ($bibliographicreference->setAuditTrail([$audittrail_assn]));
result (UNIVERSAL::isa($bibliographicreference->getAuditTrail,'ARRAY')
 and scalar @{$bibliographicreference->getAuditTrail()} == 1
 and $bibliographicreference->getAuditTrail->[0] == $audittrail_assn);
$bibliographicreference->addAuditTrail($audittrail_assn);
result (UNIVERSAL::isa($bibliographicreference->getAuditTrail,'ARRAY')
 and scalar @{$bibliographicreference->getAuditTrail()} == 2
 and $bibliographicreference->getAuditTrail->[0] == $audittrail_assn
 and $bibliographicreference->getAuditTrail->[1] == $audittrail_assn);


# test the meta-data for the assoication
($assn) = $assns{auditTrail};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association descriptions
my $descriptions_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $descriptions_assn = Bio::MAGE::Description::Description->new();
}
result (UNIVERSAL::isa($bibliographicreference->getDescriptions->[0],q[Bio::MAGE::Description::Description]));
result ($bibliographicreference->setDescriptions([$descriptions_assn]));
result (UNIVERSAL::isa($bibliographicreference->getDescriptions,'ARRAY')
 and scalar @{$bibliographicreference->getDescriptions()} == 1
 and $bibliographicreference->getDescriptions->[0] == $descriptions_assn);
$bibliographicreference->addDescriptions($descriptions_assn);
result (UNIVERSAL::isa($bibliographicreference->getDescriptions,'ARRAY')
 and scalar @{$bibliographicreference->getDescriptions()} == 2
 and $bibliographicreference->getDescriptions->[0] == $descriptions_assn
 and $bibliographicreference->getDescriptions->[1] == $descriptions_assn);


# test the meta-data for the assoication
($assn) = $assns{descriptions};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association propertySets
my $propertysets_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $propertysets_assn = Bio::MAGE::NameValueType->new();
}
result (UNIVERSAL::isa($bibliographicreference->getPropertySets->[0],q[Bio::MAGE::NameValueType]));
result ($bibliographicreference->setPropertySets([$propertysets_assn]));
result (UNIVERSAL::isa($bibliographicreference->getPropertySets,'ARRAY')
 and scalar @{$bibliographicreference->getPropertySets()} == 1
 and $bibliographicreference->getPropertySets->[0] == $propertysets_assn);
$bibliographicreference->addPropertySets($propertysets_assn);
result (UNIVERSAL::isa($bibliographicreference->getPropertySets,'ARRAY')
 and scalar @{$bibliographicreference->getPropertySets()} == 2
 and $bibliographicreference->getPropertySets->[0] == $propertysets_assn
 and $bibliographicreference->getPropertySets->[1] == $propertysets_assn);


# test the meta-data for the assoication
($assn) = $assns{propertySets};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing superclass Bio::MAGE::Describable
result ($bibliographicreference->isa(q[Bio::MAGE::Describable]));

# testing superclass Bio::MAGE::Extendable
result ($bibliographicreference->isa(q[Bio::MAGE::Extendable]));

