/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ObjectArrayMorpher
extends AbstractArrayMorpher {
    private Morpher morpher;
    private Method morphMethod;
    private Class target;
    private Class targetArrayClass;
    static /* synthetic */ Class class$0;

    public ObjectArrayMorpher(Morpher morpher) {
        super(false);
        this.setMorpher(morpher);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectArrayMorpher)) {
            return false;
        }
        ObjectArrayMorpher other = (ObjectArrayMorpher)obj;
        return this.morpher.equals(other.morpher);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.morpher).toHashCode();
    }

    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(this.target, dimensions);
            if (dims == 1) {
                int index = 0;
                while (index < length) {
                    try {
                        Object value = Array.get(array, index);
                        if (value != null && !this.morpher.supports(value.getClass())) {
                            throw new MorphException(value.getClass() + " is not supported");
                        }
                        Object morphed = this.morphMethod.invoke((Object)this.morpher, value);
                        Array.set(result, index, morphed);
                    }
                    catch (MorphException me) {
                        throw me;
                    }
                    catch (Exception e) {
                        throw new MorphException(e);
                    }
                    ++index;
                }
            } else {
                int index = 0;
                while (index < length) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                    ++index;
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    public Class morphsTo() {
        return this.targetArrayClass;
    }

    /*
     * Unable to fully structure code
     */
    public boolean supports(Class clazz) {
        if (clazz == null || clazz.isArray()) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            clazz = clazz.getComponentType();
lbl4:
            // 2 sources

            ** while (clazz.isArray())
        }
lbl5:
        // 1 sources

        return this.morpher.supports(clazz);
    }

    private void setMorpher(Morpher morpher) {
        if (morpher == null) {
            throw new IllegalArgumentException("morpher can not be null");
        }
        if (morpher.morphsTo().isArray()) {
            throw new IllegalArgumentException("morpher target class can not be an array");
        }
        this.morpher = morpher;
        this.targetArrayClass = Array.newInstance(morpher.morphsTo(), 1).getClass();
        this.target = morpher.morphsTo();
        try {
            Class<?> clazz = morpher.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.morphMethod = clazz.getDeclaredMethod("morph", classArray);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(nsme.getMessage());
        }
    }
}

