/*
 * Decompiled with CFR 0.152.
 */
package Hadoop.CUICollectorMapReduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class CUICollector {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration(true);
        if (args[2].equals("article")) {
            conf.set("textinputformat.record.delimiter", "@@@@@@@");
        } else {
            conf.set("textinputformat.record.delimiter", "'EOU'.");
        }
        Job job = new Job(conf);
        job.setJarByClass(CUICollector.class);
        job.setMapperClass(CUIMapper.class);
        job.setCombinerClass(CUIReducer.class);
        job.setReducerClass(CUIReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        job.setInputFormatClass(TextInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CUIReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CUIMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        public static final Log log = LogFactory.getLog(CUIMapper.class);
        public static final boolean DEBUG = false;
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            Matcher m_c1;
            String thisString = value.toString();
            String phrases_pattern = "mappings(.*)";
            Pattern p1 = Pattern.compile(phrases_pattern);
            Matcher m_p1 = p1.matcher(thisString);
            String cui_pattern = "C[0-9]{7}";
            Pattern c1 = Pattern.compile(cui_pattern);
            ArrayList my_phrases = new ArrayList();
            while (m_p1.find()) {
                String thisPhrase = m_p1.group(1);
                String[] maps = thisPhrase.split("map\\(");
                ArrayList<String> my_maps = new ArrayList<String>();
                for (int i = 0; i < maps.length; ++i) {
                    String thisMap = maps[i];
                    StringBuilder CUIs = new StringBuilder(64);
                    m_c1 = c1.matcher(thisMap);
                    while (m_c1.find()) {
                        String thisCUI = m_c1.group(0);
                        CUIs.append(thisCUI);
                        CUIs.append(" ");
                    }
                    if (CUIs.toString().isEmpty()) continue;
                    my_maps.add(CUIs.toString());
                }
                if (my_maps.isEmpty()) continue;
                my_phrases.add(my_maps);
            }
            if (!my_phrases.isEmpty()) {
                for (int i = 0; i < my_phrases.size(); ++i) {
                    HashMap<String, String> prior = new HashMap<String, String>();
                    List phrase_1 = (List)my_phrases.get(i);
                    List phrase_2 = null;
                    if (i + 1 < my_phrases.size()) {
                        phrase_2 = (List)my_phrases.get(i + 1);
                    }
                    for (int j = 0; j < phrase_1.size(); ++j) {
                        ArrayList<String> cuiList = new ArrayList<String>();
                        m_c1 = c1.matcher(((String)phrase_1.get(j)).toString());
                        while (m_c1.find()) {
                            cuiList.add(m_c1.group(0));
                        }
                        for (int h = 0; h < cuiList.size() - 1; ++h) {
                            StringBuilder bigram = new StringBuilder(15);
                            bigram.append((String)cuiList.get(h));
                            bigram.append(" ");
                            bigram.append((String)cuiList.get(h + 1));
                            if (prior.get(bigram.toString()) != null) continue;
                            this.word.set(bigram.toString());
                            context.write((Object)this.word, (Object)one);
                            prior.put(bigram.toString(), "1");
                        }
                        if (i + 1 >= my_phrases.size()) continue;
                        for (int k = 0; k < phrase_2.size(); ++k) {
                            ArrayList<String> cuiList2 = new ArrayList<String>();
                            Matcher m_c2 = c1.matcher(((String)phrase_2.get(k)).toString());
                            while (m_c2.find()) {
                                cuiList2.add(m_c2.group(0));
                            }
                            StringBuilder bigram2 = new StringBuilder(15);
                            bigram2.append((String)cuiList.get(cuiList.size() - 1));
                            bigram2.append(" ");
                            bigram2.append((String)cuiList2.get(0));
                            if (prior.get(bigram2.toString()) != null) continue;
                            this.word.set(bigram2.toString());
                            context.write((Object)this.word, (Object)one);
                            prior.put(bigram2.toString(), "1");
                        }
                    }
                }
            }
        }
    }
}

