package OpenInteract::SQLInstall::Group;

# $Id: Group.pm,v 1.9 2002/05/02 12:41:20 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );
use SPOPS::SQLInterface;

use constant DEBUG => 0;

my @TABLES = ( 'sys_group.sql', 'sys_group_user.sql' );

my %FILES = (
    tables        => \@TABLES,
    tables_oracle => [ 'sys_group_oracle.sql', 'sys_group_user.sql',
                       'sys_group_sequence.sql' ],
    tables_pg     => [ @TABLES, 'sys_group_sequence.sql' ],
    tables_ib     => [ 'sys_group_interbase.sql', 'sys_group_user.sql',
                       'sys_group_generator.sql' ],
    security      => [ 'install_security.dat' ],
);

%HANDLERS = (
    create_structure => { '_default_' => [ 'create_structure',
                                           { table_file_list => $FILES{tables} } ],
                          'Oracle'    => [ 'create_structure',
                                           { table_file_list => $FILES{tables_oracle} } ],
                          'Pg'        => [ 'create_structure',
                                           { table_file_list => $FILES{tables_pg} } ],
                          'InterBase' => [ 'create_structure',
                                           { table_file_list => $FILES{tables_ib} } ],
    },
    install_data     => { '_default_' => \&initial_group_data },
    install_security => { '_default_' => [ 'install_data',
                                           { data_file_list => $FILES{security} } ] },
);


sub initial_group_data {
    my ( $class, $p ) = @_;
    my $status_group = $class->create_initial_groups( $p );
    my $status_link  = $class->create_link_groups( $p );
    return [ $status_group, $status_link ];
}


# Create the admin, site admin and public groups

sub create_initial_groups {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my $status = { action => 'data',
                   name   => 'create_initial_groups',
                   ok     => 1 };
    my $CONFIG = $R->CONFIG;
    my $group_class = $R->group;

    my @DATA = (
        [ $CONFIG->{default_objects}{supergroup},       'admin',      'Super group, can do anything' ],
        [ $CONFIG->{default_objects}{public_group},     'public',     'All users should be part of this group' ],
        [ $CONFIG->{default_objects}{site_admin_group}, 'site admin', 'Group for site administrators' ],
    );

    my @msg = ();

    foreach my $data ( @DATA ) {
        DEBUG && warn "Trying to create group ($data->[0]/$data->[1])\n";
        push @msg, "\nStatus of group create for $data->[1]:";
        my $group = $group_class->new;
        $group->{group_id} = $data->[0];
        $group->{name}     = $data->[1];
        $group->{notes}    = $data->[2];
        eval { $group->save({ is_add        => 1,
                              skip_security => 1,
                              skip_cache    => 1,
                              skip_log      => 1 }) };
        if ( $@ ) {
            my $ei = SPOPS::Error->get;
            $status->{ok}  = 0;
            push @msg, "Cannot create group $data->[1] (ID: $data->[0])\n" .
                       "Error: $@\nVerbose: $ei->{system_msg}";
            DEBUG && warn "Cannot create group ($data->[0]/$data->[1]) Error: ", Dumper( $ei ), "\n";
        }
        else {
            push @msg, " -- created ok";
        }
    }
    $status->{msg} = join "\n", @msg;
    return $status;
}


sub create_link_groups {
    my ( $class, $p ) = @_;
    my $status = { action => 'data',
                   name   => 'create_link_groups',
                   ok     => 1 };
    my $CONFIG = OpenInteract::Request->instance->CONFIG;
    my $values = [ $CONFIG->{default_objects}{supergroup},
                   $CONFIG->{default_objects}{superuser} ];
    eval { SPOPS::SQLInterface->db_insert({ db    => $p->{db},
                                            table => 'sys_group_user',
                                            field => [ qw/ group_id user_id / ],
                                            value => $values,
                                            dbi_type_info => { group_id => 'int',
                                                               user_id  => 'int' } }) };
    if ( $@ ) {
        warn "Error inserting user/group link: $@\n";
        $status->{ok}  = 0;
        $status->{msg} = "Error executing insert statement to link the superuser and supergroup" .
                         "Data: ((", join( ', ', @{ $values } ), "))\nError: $@\n";
    }
    else {
        $status->{msg} = 'Users and groups linked ok.';
    }
    return $status;
}

1;
